/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.biojava.nbio.aaproperties.xml.AminoAcidComposition;
import org.biojava.nbio.aaproperties.xml.ElementTable;
import org.biojava.nbio.aaproperties.xml.ModifiedAminoAcidCompoundSet;
import org.biojava.nbio.aaproperties.xml.Name2Count;

@XmlRootElement(name="compoundtable", namespace="http://biojava.org")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AminoAcidCompositionTable {
    @XmlElement(name="compound", required=true)
    private List<AminoAcidComposition> aminoacid;
    private ModifiedAminoAcidCompoundSet modifiedAminoAcidCompoundSet;
    private Map<Character, Double> aaSymbol2MolecularWeight;

    public AminoAcidCompositionTable() {
    }

    public AminoAcidCompositionTable(List<AminoAcidComposition> aaList) {
        this.setAminoacid(aaList);
    }

    public ModifiedAminoAcidCompoundSet getAminoAcidCompoundSet() {
        return this.modifiedAminoAcidCompoundSet;
    }

    public List<AminoAcidComposition> getAminoacid() {
        return this.aminoacid;
    }

    public void setAminoacid(List<AminoAcidComposition> aminoacid) {
        this.aminoacid = aminoacid;
    }

    public Set<Character> getSymbolSet() {
        return this.aaSymbol2MolecularWeight.keySet();
    }

    private void generatesAminoAcidCompoundSet() {
        this.modifiedAminoAcidCompoundSet = new ModifiedAminoAcidCompoundSet(this.aminoacid, this.aaSymbol2MolecularWeight);
    }

    public void computeMolecularWeight(ElementTable eTable) {
        this.aaSymbol2MolecularWeight = new HashMap<Character, Double>();
        for (AminoAcidComposition a : this.aminoacid) {
            if (a.getSymbol().length() != 1) {
                throw new Error(a.getSymbol() + " is not allowed. Symbols must be single character.\r\nPlease check AminoAcidComposition XML file");
            }
            char c = a.getSymbol().charAt(0);
            if (this.aaSymbol2MolecularWeight.keySet().contains(Character.valueOf(c))) {
                throw new Error("Symbol " + c + " is repeated.\r\nPlease check AminoAcidComposition XML file to ensure there are no repeated symbols. Note that this is case-insensitive.\r\nThis means that having 'A' and 'a' would be repeating.");
            }
            double total = 0.0;
            if (a.getElementList() != null) {
                for (Name2Count element : a.getElementList()) {
                    element.getName();
                    if (eTable.getElement(element.getName()) == null) {
                        throw new Error("Element " + element.getName() + " could not be found. \r\nPlease ensure that its name is correct in AminoAcidComposition.xml and is defined in ElementMass.xml.");
                    }
                    eTable.getElement(element.getName()).getMass();
                    total += eTable.getElement(element.getName()).getMass() * (double)element.getCount();
                }
            }
            if (a.getIsotopeList() != null) {
                for (Name2Count isotope : a.getIsotopeList()) {
                    isotope.getName();
                    if (eTable.getIsotope(isotope.getName()) == null) {
                        throw new Error("Isotope " + isotope.getName() + " could not be found. \r\nPlease ensure that its name is correct in AminoAcidComposition.xml and is defined in ElementMass.xml.");
                    }
                    eTable.getIsotope(isotope.getName()).getMass();
                    total += eTable.getIsotope(isotope.getName()).getMass() * (double)isotope.getCount();
                }
            }
            c = a.getSymbol().charAt(0);
            this.aaSymbol2MolecularWeight.put(Character.valueOf(c), total);
        }
        this.generatesAminoAcidCompoundSet();
    }

    public double getMolecularWeight(Character aaSymbol) throws NullPointerException {
        if (this.aaSymbol2MolecularWeight == null) {
            throw new NullPointerException("Please call AminoAcidCompositionTable.computeMolecularWeight(ElementTable) before this method");
        }
        Double d = this.aaSymbol2MolecularWeight.get(aaSymbol);
        if (d == null) {
            return 0.0;
        }
        return d;
    }
}

