/*
 * Decompiled with CFR 0.152.
 */
package pine;

import pine.HtmlEntities$;
import pine.ParseError;
import pine.Reader;
import pine.XmlEntities$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;

public final class HtmlHelpers$ {
    public static final HtmlHelpers$ MODULE$;
    private final Set<String> VoidElements;
    private final Set<String> CdataElements;
    private volatile byte bitmap$init$0;

    static {
        new HtmlHelpers$();
    }

    public Set<String> VoidElements() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.VoidElements;
        }
        throw new UninitializedFieldError("Uninitialized field: HtmlHelpers.scala: 9");
    }

    public Set<String> CdataElements() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.CdataElements;
        }
        throw new UninitializedFieldError("Uninitialized field: HtmlHelpers.scala: 13");
    }

    public String encodeAttributeValue(Object value) {
        return new StringBuilder().append((Object)"\"").append((Object)value.toString().replaceAll("&", "&amp;").replaceAll("\"", "&quot;")).append((Object)"\"").toString();
    }

    public String decodeAttributeValue(String value) {
        return value.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
    }

    public String encodeText(String text, boolean xml) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(text)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(char c) {
                String string;
                char c2 = c;
                switch (c2) {
                    default: {
                        if (c >= ' ') {
                            string = Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
                            break;
                        }
                        string = Predef$.MODULE$.augmentString("");
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        string = Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
                        break;
                    }
                    case '&': {
                        string = Predef$.MODULE$.augmentString("&amp;");
                        break;
                    }
                    case '>': {
                        string = Predef$.MODULE$.augmentString("&gt;");
                        break;
                    }
                    case '<': {
                        string = Predef$.MODULE$.augmentString("&lt;");
                    }
                }
                return string;
            }
        }, Predef$.MODULE$.StringCanBuildFrom());
    }

    public List<String> parseTokenSet(String value) {
        return value.isEmpty() ? List$.MODULE$.empty() : Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(value)).split(' ')).toList();
    }

    public String parseHexBinary(String hex) {
        StringBuilder sb = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), hex.length()).by(2).foreach((Function1)new Serializable(hex, sb){
            public static final long serialVersionUID = 0L;
            private final String hex$1;
            private final StringBuilder sb$1;

            public final StringBuilder apply(int i) {
                String str = this.hex$1.substring(i, i + 2);
                return this.sb$1.append((char)Integer.parseInt(str, 16));
            }
            {
                this.hex$1 = hex$1;
                this.sb$1 = sb$1;
            }
        });
        return sb.toString();
    }

    private String stripLeading(String str, char c) {
        String string;
        if (str.isEmpty()) {
            string = str;
        } else {
            int i = 0;
            while (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i) == c) {
                ++i;
            }
            string = str.substring(i);
        }
        return string;
    }

    public Option<String> decodeEntity(String e, boolean xml) {
        return e.startsWith("#x0") ? new Some((Object)new String(this.parseHexBinary(this.stripLeading(e.substring(3), '0')))) : (e.startsWith("#") ? new Some((Object)((Object)BoxesRunTime.boxToCharacter((char)((char)new StringOps(Predef$.MODULE$.augmentString(e.substring(1))).toInt()))).toString()) : (e.isEmpty() ? None$.MODULE$ : (xml ? XmlEntities$.MODULE$.entities().get((Object)e) : HtmlEntities$.MODULE$.entities().get((Object)e))));
    }

    public String decodeText(String text, boolean xml) {
        Reader reader = new Reader(text);
        return this.f$1(xml, reader);
    }

    public String encodeAttributes(Map<String, Object> attributes) {
        return ((TraversableOnce)attributes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    String string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).append((Object)HtmlHelpers$.MODULE$.encodeAttributeValue(value)).toString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(" ");
    }

    public String node(String tagName, Map<String, Object> attributes, List<String> contents, boolean xml) {
        String string;
        String attrs;
        String string2 = attrs = attributes.isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.encodeAttributes(attributes)}));
        if (!xml && this.VoidElements().contains((Object)tagName) && contents.isEmpty()) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<", "", "/>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tagName, attrs}));
        } else {
            String children2 = contents.mkString();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<", "", ">", "</", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tagName, attrs, children2, tagName}));
        }
        return string;
    }

    public boolean identifierCharacter(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '-' || c == '_' || c == ':';
    }

    private final String f$1(boolean xml$1, Reader reader$1) {
        Option<String> option;
        block8: {
            Option<String> option2;
            block9: {
                String string;
                block7: {
                    String string2;
                    String string3;
                    block6: {
                        option = reader$1.collect('&');
                        if (!None$.MODULE$.equals(option)) break block6;
                        string = reader$1.rest();
                        break block7;
                    }
                    if (!(option instanceof Some)) break block8;
                    Some some = (Some)option;
                    String prefix = (String)some.x();
                    option2 = reader$1.collectUntil((Function1<Object, Object>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char c) {
                            return !RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) && c != '#';
                        }
                    });
                    if (None$.MODULE$.equals(option2)) {
                        throw new ParseError("Ambiguous entity");
                    }
                    if (!(option2 instanceof Some)) break block9;
                    Some some2 = (Some)option2;
                    String e = (String)some2.x();
                    if (reader$1.prefix(';')) {
                        String ent = (String)this.decodeEntity(e, xml$1).getOrElse((Function0)new Serializable(e){
                            public static final long serialVersionUID = 0L;
                            private final String e$1;

                            public final Nothing$ apply() {
                                throw new ParseError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1})));
                            }
                            {
                                this.e$1 = e$1;
                            }
                        });
                        string3 = new StringBuilder().append((Object)prefix).append((Object)ent).append((Object)this.f$1(xml$1, reader$1)).toString();
                    } else {
                        string3 = new StringBuilder().append((Object)prefix).append((Object)"&").append((Object)this.f$1(xml$1, reader$1)).toString();
                    }
                    string = string2 = string3;
                }
                return string;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private HtmlHelpers$() {
        MODULE$ = this;
        this.VoidElements = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"}));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.CdataElements = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"script", "style"}));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

