/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.data.ClearProjectData;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseClearProjectTask
extends AbstractDatabaseTask {
    private int m_action;
    private static final int LOAD_DATA_PROJECT_CLEAR = 0;
    private static final int LOAD_DATA_DATASET_CLEAR = 1;
    private Project m_project = null;
    private Long m_projectId;
    private List<ClearProjectData> m_listDataToClear;
    private List<ClearProjectData> m_listOpenedData;

    public DatabaseClearProjectTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initLoadDataToClearProject(Project p, List<ClearProjectData> listDataToClear, List<ClearProjectData> openedData) {
        this.setTaskInfo(new TaskInfo("Load Data to Delete for Project " + (p == null ? "" : p.getName()), true, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_project = p;
        this.m_listDataToClear = listDataToClear;
        this.m_listOpenedData = openedData;
        this.m_action = 0;
    }

    public void initLoadDataToClearTrash(Long projectId, List<ClearProjectData> listDataToClearTrash, List<ClearProjectData> openedData) {
        this.setTaskInfo(new TaskInfo("Load Data to Delete for  Trash ", true, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_projectId = projectId;
        this.m_listDataToClear = listDataToClearTrash;
        this.m_listOpenedData = openedData;
        this.m_action = 1;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 0: {
                return this.loadDataToClearProject();
            }
            case 1: {
                return this.loadDataToClearTrash();
            }
        }
        return false;
    }

    private boolean loadDataToClearProject() {
        m_logger.debug("loadDataToClearProject " + this.m_project.getId());
        return this.loadDataToClear(this.m_project.getId(), false, this.m_listDataToClear, this.m_listOpenedData);
    }

    private boolean loadDataToClearTrash() {
        m_logger.debug("loadDataToClearTrash " + this.m_projectId);
        return this.loadDataToClear(this.m_projectId, true, this.m_listDataToClear, this.m_listOpenedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDataToClear(long projectId, boolean clearTrashDataOnly, List<ClearProjectData> dataToClear, List<ClearProjectData> openedData) {
        boolean result = true;
        EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId).createEntityManager();
        EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
        try {
            ClearProjectData clearData;
            ArrayList<Long> dsInTrash = new ArrayList<Long>();
            String getTrashDSId = "SELECT ds.id FROM fr.proline.core.orm.uds.Dataset ds  WHERE ds.type = 'TRASH' AND ds.project.id=:projectId ";
            TypedQuery queryGetTrashDSId = entityManagerUDS.createQuery(getTrashDSId, Long.class);
            queryGetTrashDSId.setParameter("projectId", (Object)projectId);
            Long trashId = (Long)queryGetTrashDSId.getSingleResult();
            this.loadDataInTrash(trashId, dsInTrash);
            entityManagerUDS.getTransaction().begin();
            String queryRsUds = "SELECT DISTINCT(ds.resultSetId) FROM fr.proline.core.orm.uds.Dataset ds  WHERE ds.resultSetId IS NOT NULL AND ds.project.id=:projectId ";
            if (clearTrashDataOnly) {
                queryRsUds = queryRsUds + "AND ds.id IN (:trashList) ";
            } else if (!dsInTrash.isEmpty()) {
                queryRsUds = queryRsUds + "AND ds.id NOT IN (:trashList)  ";
            }
            queryRsUds = queryRsUds + "ORDER BY ds.resultSetId";
            TypedQuery queryAllRsUds = entityManagerUDS.createQuery(queryRsUds, Long.class);
            queryAllRsUds.setParameter("projectId", (Object)projectId);
            if (!dsInTrash.isEmpty()) {
                queryAllRsUds.setParameter("trashList", dsInTrash);
            }
            List listResultSetIdsUds = queryAllRsUds.getResultList();
            List listRsmIdsUds = new ArrayList();
            String queryRsmUds = "SELECT DISTINCT(ds.resultSummaryId) FROM fr.proline.core.orm.uds.Dataset ds  WHERE ds.resultSummaryId IS NOT NULL AND ds.project.id=:projectId ";
            if (clearTrashDataOnly) {
                queryRsmUds = queryRsmUds + "AND ds.id IN (:trashList) ";
            } else if (!dsInTrash.isEmpty()) {
                queryRsmUds = queryRsmUds + "AND ds.id NOT IN (:trashList)  ";
            }
            queryRsmUds = queryRsmUds + "ORDER BY ds.resultSummaryId";
            TypedQuery queryAllRsmUds = entityManagerUDS.createQuery(queryRsmUds, Long.class);
            queryAllRsmUds.setParameter("projectId", (Object)projectId);
            if (!dsInTrash.isEmpty()) {
                queryAllRsmUds.setParameter("trashList", dsInTrash);
            }
            listRsmIdsUds = queryAllRsmUds.getResultList();
            List listQtRsmIdsUds = new ArrayList();
            String queryQtRsmUds = "SELECT DISTINCT(mqc.quantResultSummaryId) FROM fr.proline.core.orm.uds.MasterQuantitationChannel mqc, fr.proline.core.orm.uds.Dataset ds WHERE mqc.quantDataset.id =ds.id AND mqc.quantResultSummaryId IS NOT NULL AND ds.project.id=:projectId  ";
            if (clearTrashDataOnly) {
                queryQtRsmUds = queryQtRsmUds + "AND ds.id IN (:trashList)  ";
            } else if (!dsInTrash.isEmpty()) {
                queryQtRsmUds = queryQtRsmUds + "AND ds.id NOT IN (:trashList)  ";
            }
            queryQtRsmUds = queryQtRsmUds + "ORDER BY mqc.quantResultSummaryId";
            TypedQuery queryAllQtRsmUds = entityManagerUDS.createQuery(queryQtRsmUds, Long.class);
            queryAllQtRsmUds.setParameter("projectId", (Object)projectId);
            if (!dsInTrash.isEmpty()) {
                queryAllQtRsmUds.setParameter("trashList", dsInTrash);
            }
            listQtRsmIdsUds = queryAllQtRsmUds.getResultList();
            if (!clearTrashDataOnly || clearTrashDataOnly && listQtRsmIdsUds.isEmpty()) {
                String queryRsmUds2 = "SELECT DISTINCT(qc.identResultSummaryId) FROM fr.proline.core.orm.uds.QuantitationChannel qc, fr.proline.core.orm.uds.Dataset ds WHERE qc.dataset.id =ds.id AND qc.identResultSummaryId IS NOT NULL AND ds.project.id=:projectId   ";
                if (clearTrashDataOnly) {
                    queryRsmUds2 = queryRsmUds2 + "AND ds.id IN (:trashList)  ";
                } else if (!dsInTrash.isEmpty()) {
                    queryRsmUds2 = queryRsmUds2 + "AND ds.id NOT IN (:trashList)  ";
                }
                queryRsmUds2 = queryRsmUds2 + "ORDER BY qc.identResultSummaryId";
                TypedQuery queryAllRsmUds2 = entityManagerUDS.createQuery(queryRsmUds2, Long.class);
                queryAllRsmUds2.setParameter("projectId", (Object)projectId);
                if (!dsInTrash.isEmpty()) {
                    queryAllRsmUds2.setParameter("trashList", dsInTrash);
                }
                listQtRsmIdsUds.addAll(queryAllRsmUds2.getResultList());
            }
            entityManagerUDS.getTransaction().commit();
            ArrayList<Long> openedRsmId = new ArrayList<Long>();
            ArrayList<Long> openedRsId = new ArrayList<Long>();
            for (ClearProjectData d : openedData) {
                if (d.isResultSet()) {
                    openedRsId.add(d.getId());
                    continue;
                }
                if (!d.isResultSummary()) continue;
                openedRsmId.add(d.getId());
            }
            entityManagerMSI.getTransaction().begin();
            if (!listQtRsmIdsUds.isEmpty()) {
                String queryLinked = "SELECT rsm.resultSet.id FROM fr.proline.core.orm.msi.ResultSummary rsm WHERE rsm.resultSet.id IS NOT NULL AND rsm.id IN (:list) ";
                if (!openedRsmId.isEmpty()) {
                    queryLinked = queryLinked + " AND rsm.id NOT IN (:openedRsmlist) ";
                }
                TypedQuery queryLinkedRs = entityManagerMSI.createQuery(queryLinked, Long.class);
                queryLinkedRs.setParameter("list", listQtRsmIdsUds);
                if (!openedRsmId.isEmpty()) {
                    queryLinkedRs.setParameter("openedRsmlist", openedRsmId);
                }
                List tempRSIdsUds = new ArrayList();
                tempRSIdsUds = queryLinkedRs.getResultList();
                listResultSetIdsUds.addAll(tempRSIdsUds);
            }
            if (!listResultSetIdsUds.isEmpty()) {
                String queryRsDecoy = "SELECT rs.decoyResultSet.id FROM fr.proline.core.orm.msi.ResultSet rs WHERE rs.decoyResultSet.id IS NOT NULL AND rs.id IN (:list) ";
                if (!openedRsId.isEmpty()) {
                    queryRsDecoy = queryRsDecoy + " AND (rs.id NOT IN (:openedRslist) AND rs.decoyResultSet.id NOT IN (:openedRslist)) ";
                }
                queryRsDecoy = queryRsDecoy + " ORDER BY rs.decoyResultSet.id";
                TypedQuery sqlQueryDecoyRs = entityManagerMSI.createQuery(queryRsDecoy, Long.class);
                sqlQueryDecoyRs.setParameter("list", (Object)listResultSetIdsUds);
                if (!openedRsId.isEmpty()) {
                    sqlQueryDecoyRs.setParameter("openedRslist", openedRsId);
                }
                listResultSetIdsUds.addAll(sqlQueryDecoyRs.getResultList());
            }
            if (!listRsmIdsUds.isEmpty()) {
                String queryRsmDecoy = "SELECT rsm.decoyResultSummary.id FROM fr.proline.core.orm.msi.ResultSummary rsm WHERE rsm.decoyResultSummary.id IS NOT NULL AND rsm.id IN (:list) ";
                if (!openedRsmId.isEmpty()) {
                    queryRsmDecoy = queryRsmDecoy + " AND (rsm.id NOT IN (:openedRsmlist) AND rsm.decoyResultSummary.id NOT IN (:openedRsmlist)) ";
                }
                queryRsmDecoy = queryRsmDecoy + " ORDER BY rsm.decoyResultSummary.id";
                TypedQuery sqlQueryDecoyRsm = entityManagerMSI.createQuery(queryRsmDecoy, Long.class);
                sqlQueryDecoyRsm.setParameter("list", listRsmIdsUds);
                if (!openedRsmId.isEmpty()) {
                    sqlQueryDecoyRsm.setParameter("openedRsmlist", openedRsmId);
                }
                listRsmIdsUds.addAll(sqlQueryDecoyRsm.getResultList());
            }
            List listResultSetMsi = new ArrayList();
            StringBuilder queryRsMsiBuilder = new StringBuilder("SELECT rs FROM fr.proline.core.orm.msi.ResultSet rs WHERE");
            if (!clearTrashDataOnly && listResultSetIdsUds.isEmpty()) {
                if (!openedRsId.isEmpty()) {
                    queryRsMsiBuilder.append(" rs.id NOT IN (:openedRslist) ");
                }
            } else {
                if (clearTrashDataOnly) {
                    queryRsMsiBuilder.append(" rs.id  IN (:list) ");
                } else {
                    queryRsMsiBuilder.append(" rs.id  NOT IN (:list) ");
                }
                if (!openedRsId.isEmpty()) {
                    queryRsMsiBuilder.append(" AND rs.id NOT IN (:openedRslist) ");
                }
            }
            queryRsMsiBuilder.append(" ORDER BY rs.id ");
            TypedQuery queryAllRsMsi = entityManagerMSI.createQuery(queryRsMsiBuilder.toString(), ResultSet.class);
            if (!listResultSetIdsUds.isEmpty()) {
                queryAllRsMsi.setParameter("list", (Object)listResultSetIdsUds);
            }
            if (!openedRsId.isEmpty()) {
                queryAllRsMsi.setParameter("openedRslist", openedRsId);
            }
            if (!clearTrashDataOnly || !listResultSetIdsUds.isEmpty()) {
                listResultSetMsi = queryAllRsMsi.getResultList();
            }
            ArrayList<Long> listResultSetMsiIds = new ArrayList<Long>();
            for (ResultSet rs : listResultSetMsi) {
                listResultSetMsiIds.add(rs.getId());
            }
            listRsmIdsUds.addAll(listQtRsmIdsUds);
            List<ResultSummary> listResultSummaryMsi = new ArrayList();
            StringBuilder queryRsmMsiBuilder = new StringBuilder("SELECT rsm FROM fr.proline.core.orm.msi.ResultSummary rsm ");
            if (!clearTrashDataOnly && listRsmIdsUds.isEmpty()) {
                if (!openedRsmId.isEmpty()) {
                    queryRsmMsiBuilder.append("WHERE rsm.id NOT IN (:openedRsmlist) ");
                }
            } else {
                if (clearTrashDataOnly) {
                    queryRsmMsiBuilder.append("WHERE rsm.id  IN (:list) ");
                } else {
                    queryRsmMsiBuilder.append("WHERE rsm.id  NOT IN (:list) ");
                }
                if (!openedRsmId.isEmpty()) {
                    queryRsmMsiBuilder.append(" AND rsm.id NOT IN (:openedRsmlist) ");
                }
            }
            queryRsmMsiBuilder.append(" ORDER BY rsm.id ");
            TypedQuery queryAllRsmMsi = entityManagerMSI.createQuery(queryRsmMsiBuilder.toString(), ResultSummary.class);
            if (!listRsmIdsUds.isEmpty()) {
                queryAllRsmMsi.setParameter("list", listRsmIdsUds);
            }
            if (!openedRsmId.isEmpty()) {
                queryAllRsmMsi.setParameter("openedRsmlist", openedRsmId);
            }
            if (!clearTrashDataOnly || !listRsmIdsUds.isEmpty()) {
                listResultSummaryMsi = queryAllRsmMsi.getResultList();
            }
            List listRSMMsi = new ArrayList();
            if (!listResultSetMsi.isEmpty()) {
                String queryRSMMsi = "SELECT rsm FROM fr.proline.core.orm.msi.ResultSummary rsm  WHERE rsm.resultSet.id IN (:list) ";
                if (!openedRsmId.isEmpty()) {
                    queryRSMMsi = queryRSMMsi + " AND rsm.id NOT IN (:openedRsmList) ";
                }
                queryRSMMsi = queryRSMMsi + " ORDER BY rsm.id ";
                TypedQuery queryAllRSMMsi = entityManagerMSI.createQuery(queryRSMMsi, ResultSummary.class);
                queryAllRSMMsi.setParameter("list", listResultSetMsiIds);
                if (!openedRsmId.isEmpty()) {
                    queryAllRSMMsi.setParameter("openedRsmList", openedRsmId);
                }
                listRSMMsi = queryAllRSMMsi.getResultList();
            }
            for (ResultSummary rsm : listRSMMsi) {
                if (listResultSummaryMsi.contains(rsm)) continue;
                listResultSummaryMsi.add(rsm);
            }
            entityManagerMSI.getTransaction().commit();
            for (ResultSet rs : listResultSetMsi) {
                clearData = new ClearProjectData(projectId, rs);
                if (rs.getType().equals((Object)ResultSet.Type.QUANTITATION)) {
                    clearData.setSelected(true);
                    clearData.setIsEditable(false);
                }
                dataToClear.add(clearData);
            }
            for (ResultSummary rsm : listResultSummaryMsi) {
                clearData = new ClearProjectData(projectId, rsm);
                if (rsm.getResultSet() != null && rsm.getResultSet().getType().equals((Object)ResultSet.Type.QUANTITATION)) {
                    clearData.setSelected(true);
                    clearData.setIsEditable(false);
                }
                dataToClear.add(clearData);
            }
        }
        catch (Exception e) {
            m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            this.m_taskError = new TaskError(e);
            try {
                entityManagerMSI.getTransaction().rollback();
                entityManagerUDS.getTransaction().rollback();
            }
            catch (Exception rollbackException) {
                m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
            }
            result = false;
        }
        finally {
            entityManagerMSI.close();
            entityManagerUDS.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDataInTrash(Long trash_Id, List<Long> trashDatasetIds) {
        m_logger.info("loadDataInTrash " + trash_Id);
        boolean result = true;
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            Dataset ds = (Dataset)entityManagerUDS.find(Dataset.class, (Object)trash_Id);
            List<Dataset> children = ds.getChildren();
            do {
                children.stream().forEach(d -> trashDatasetIds.add(d.getId()));
            } while (!(children = this.loadChildren(children)).isEmpty());
        }
        return result;
    }

    private List<Dataset> loadChildren(List<Dataset> datasets) {
        ArrayList<Dataset> allChildren = new ArrayList<Dataset>();
        for (Dataset ds : datasets) {
            List children = ds.getChildren();
            allChildren.addAll(children);
        }
        return allChildren;
    }
}

