/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class DatabaseLoadMSQueriesTask
extends AbstractDatabaseSlicerTask {
    private static final int SLICE_SIZE = 1000;
    public static final int SUB_TASK_MSQUERY = 0;
    public static final int SUB_TASK_COUNT = 1;
    private long m_projectId = -1L;
    private ResultSet m_resultSet;
    private List<DMsQuery> m_listMsQueries;
    private Map<Long, DMsQuery> m_msqQueryMap;
    private MsiSearch m_msiSearch;
    private Map<Long, Integer> m_nbPeptideMatchesByMsQueryIdMap;
    private List<Long> m_msQueriesIds = null;
    private int action;
    private static final int LOAD_MSQUERY = 0;

    public DatabaseLoadMSQueriesTask(AbstractDatabaseCallback callback) {
        super(callback);
    }

    public void initLoadMSQueries(long projectId, ResultSet rs, List<DMsQuery> listMsQueries, Map<Long, Integer> nbPeptideMatchesByMsQueryIdMap) {
        this.init(1, new TaskInfo("Load MSQueries for resultSet " + (rs == null ? "null" : Long.valueOf(rs.getId())), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_resultSet = rs;
        this.m_listMsQueries = listMsQueries;
        this.m_nbPeptideMatchesByMsQueryIdMap = nbPeptideMatchesByMsQueryIdMap;
        this.action = 0;
    }

    @Override
    public boolean fetchData() {
        if (this.action == 0) {
            if (this.needToFetch()) {
                return this.fetchDataMSQueriesMainTask();
            }
            return this.fetchDataSubTaskFor();
        }
        return true;
    }

    @Override
    public void abortTask() {
        super.abortTask();
        switch (this.action) {
            case 0: {
                this.m_listMsQueries = null;
            }
        }
    }

    @Override
    public boolean needToFetch() {
        switch (this.action) {
            case 0: {
                return this.m_listMsQueries == null || this.m_listMsQueries.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataMSQueriesMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            if (this.m_resultSet != null) {
                Long msiSearchId = this.m_resultSet.getMsiSearch() == null ? -1L : this.m_resultSet.getMsiSearch().getId();
                String query = "SELECT msq.id, msq.initialId, msq.charge, msq.moz FROM fr.proline.core.orm.msi.MsQuery msq, fr.proline.core.orm.msi.Spectrum s, fr.proline.core.orm.msi.Peaklist pl, fr.proline.core.orm.msi.MsiSearch msi WHERE msi.id =:msiSearchId AND msi.peaklist.id = pl.id AND pl.id = s.peaklistId AND s.id = msq.spectrum.id AND msq.msiSearch.id =:msiSearchId ";
                Query msQueryQ = entityManagerMSI.createQuery(query);
                msQueryQ.setParameter("msiSearchId", (Object)msiSearchId);
                List resultList = msQueryQ.getResultList();
                this.m_msQueriesIds = new ArrayList<Long>(resultList.size());
                this.m_msqQueryMap = new HashMap<Long, DMsQuery>();
                Iterator it = resultList.iterator();
                for (int i = 0; i < resultList.size(); ++i) {
                    Object[] res = (Object[])it.next();
                    Long msqId = (Long)res[0];
                    Integer msqInitialId = (Integer)res[1];
                    Integer charge = (Integer)res[2];
                    Double moz = (Double)res[3];
                    DMsQuery msQuery = new DMsQuery(-1L, msqId.longValue(), msqInitialId.intValue(), null);
                    msQuery.setCharge(charge.intValue());
                    msQuery.setMoz(moz.doubleValue());
                    this.m_listMsQueries.add(msQuery);
                    this.m_msQueriesIds.add(msqId);
                    this.m_msqQueryMap.put(msqId, msQuery);
                    this.m_nbPeptideMatchesByMsQueryIdMap.put(msqId, 0);
                }
                this.m_msiSearch = (MsiSearch)entityManagerMSI.find(MsiSearch.class, (Object)msiSearchId);
                if (this.m_listMsQueries.size() > 0) {
                    SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(0, this.m_listMsQueries.size(), 1000);
                    this.fetchMSQueriesData(subTask, entityManagerMSI);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataSubTaskFor() {
        SubTask slice = this.m_subTaskManager.getNextSubTask();
        if (slice == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (slice.getSubTaskId()) {
                case 0: {
                    this.fetchMSQueriesData(slice, entityManagerMSI);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private boolean fetchMSQueriesData(SubTask subTask, EntityManager entityManagerMSI) {
        List sliceOfMsQueriesIds = subTask.getSubList(this.m_msQueriesIds);
        return this.fetchMSQueriesData(entityManagerMSI, sliceOfMsQueriesIds);
    }

    private boolean fetchMSQueriesData(EntityManager entityManagerMSI, List<Long> listMSQueriesId) {
        String queryMSQ = "SELECT msq.id FROM fr.proline.core.orm.msi.MsQuery msq WHERE msq.id IN (:listId) ";
        Query queryMSQueries = entityManagerMSI.createQuery(queryMSQ);
        queryMSQueries.setParameter("listId", listMSQueriesId);
        List resultList = new ArrayList();
        if (listMSQueriesId != null && !listMSQueriesId.isEmpty()) {
            resultList = queryMSQueries.getResultList();
        }
        String querySp = "SELECT msq.id, sp.firstScan, sp.lastScan, sp.firstTime, sp.lastTime, sp.precursorIntensity, sp.title FROM fr.proline.core.orm.msi.Spectrum sp, fr.proline.core.orm.msi.MsQuery msq WHERE sp.id = msq.spectrum.id AND msq.id IN (:listId) ";
        Query querySpectrum = entityManagerMSI.createQuery(querySp);
        querySpectrum.setParameter("listId", listMSQueriesId);
        HashMap<Long, DSpectrum> spectrumMap = new HashMap<Long, DSpectrum>();
        if (listMSQueriesId != null && !listMSQueriesId.isEmpty()) {
            List rsSp = querySpectrum.getResultList();
            for (Object[] o : rsSp) {
                Integer firstScan = (Integer)o[1];
                Integer lastScan = (Integer)o[2];
                Float firstTime = (Float)o[3];
                Float lastTime = (Float)o[4];
                Float precursorIntensity = (Float)o[5];
                String title = (String)o[6];
                DSpectrum spectrum = new DSpectrum();
                spectrum.setFirstScan(firstScan);
                spectrum.setLastScan(lastScan);
                spectrum.setFirstTime(firstTime);
                spectrum.setLastTime(lastTime);
                spectrum.setPrecursorIntensity(precursorIntensity);
                spectrum.setTitle(title);
                spectrumMap.put((Long)o[0], spectrum);
            }
        }
        ArrayList<Long> rsIdList = new ArrayList<Long>();
        rsIdList.add(this.m_resultSet.getId());
        if (this.m_resultSet.getDecoyResultSet() != null) {
            rsIdList.add(this.m_resultSet.getDecoyResultSet().getId());
        }
        String queryCountPMS = "SELECT pm.msQuery.id, count(pm.id) FROM fr.proline.core.orm.msi.PeptideMatch pm WHERE pm.msQuery.id IN (:listId) AND pm.resultSet.id IN (:rsIdList) GROUP BY pm.msQuery.id";
        Query queryCountPM = entityManagerMSI.createQuery(queryCountPMS);
        queryCountPM.setParameter("listId", listMSQueriesId);
        queryCountPM.setParameter("rsIdList", rsIdList);
        if (listMSQueriesId != null && !listMSQueriesId.isEmpty()) {
            List rsCount = queryCountPM.getResultList();
            for (Object[] o : rsCount) {
                Long id = (Long)o[0];
                Long n = (Long)o[1];
                Integer nb = n.intValue();
                this.m_nbPeptideMatchesByMsQueryIdMap.put(id, nb);
            }
        }
        for (Long msqId : resultList) {
            DMsQuery msQuery = this.m_msqQueryMap.get(msqId);
            msQuery.setDSpectrum((DSpectrum)spectrumMap.get(msqId));
        }
        return true;
    }
}

