/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.ObjectTree;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.Map;
import javax.persistence.EntityManager;

public class DatabaseObjectTreeTask
extends AbstractDatabaseTask {
    private DPeptideMatch m_peptideMatch = null;
    private long m_projectId;
    private ObjectTree[] m_objectTreeResult;

    public DatabaseObjectTreeTask(AbstractDatabaseCallback callback, long projectId, DPeptideMatch peptideMatch, ObjectTree[] objectTreeResult) {
        super(callback, new TaskInfo("Load Fragmentation Data for Peptide Match " + DatabaseObjectTreeTask.getPeptideName(peptideMatch), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_peptideMatch = peptideMatch;
        this.m_objectTreeResult = objectTreeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchData() {
        boolean result = true;
        ObjectTree ot = null;
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            PeptideMatch pmORM = (PeptideMatch)entityManagerMSI.find(PeptideMatch.class, (Object)this.m_peptideMatch.getId());
            Map aw_Map = pmORM.getObjectTreeIdByName();
            if (aw_Map.size() > 1) {
                m_logger.warn("PeptideMatch {} has more than one object_tree ", (Object)pmORM.getId());
            }
            if (aw_Map.size() > 0) {
                Long objectTreeId = (Long)aw_Map.get("peptide_match.spectrum_match");
                if (objectTreeId != null) {
                    ot = (ObjectTree)entityManagerMSI.find(ObjectTree.class, (Object)objectTreeId);
                } else {
                    result = false;
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_objectTreeResult[0] = ot;
        return result;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    private static String getPeptideName(DPeptideMatch peptideMatch) {
        Peptide peptide = peptideMatch.getPeptide();
        String name = peptide != null ? peptide.getSequence() : String.valueOf(peptideMatch.getId());
        return name;
    }
}

