/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.performancetest.PerformanceTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabasePTMsTask
extends AbstractDatabaseSlicerTask {
    private long m_projectId = -1L;
    private List<PtmSpecificity> m_ptmsOutput = null;
    private List<Long> m_rsmIds = null;
    public static final int NO_SUB_TASK_COUNT = 0;
    private int m_action;
    private static final int FILL_ALL_PTM_INFO = 0;
    private static final int LOAD_IDENTIFIED_PTM_SPECIFICITIES = 1;

    public DatabasePTMsTask(AbstractDatabaseCallback callback) {
        super(callback);
    }

    public void initFillPTMInfo(Long projectId) {
        this.init(0, new TaskInfo("Load PTM Info", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_action = 0;
    }

    public void initLoadUsedPTMs(Long projectId, Long rsmId, List<PtmSpecificity> ptmsToFill) {
        this.init(0, new TaskInfo("Load used PTMs from RSM id" + rsmId, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsmIds = new ArrayList<Long>();
        this.m_rsmIds.add(rsmId);
        this.m_ptmsOutput = ptmsToFill;
        this.m_action = 1;
    }

    public void initLoadUsedPTMs(Long projectId, List<Long> rsmIds, List<PtmSpecificity> ptmsToFill) {
        this.init(0, new TaskInfo("Load used PTMs from RSM ids" + rsmIds, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsmIds = rsmIds;
        this.m_ptmsOutput = ptmsToFill;
        this.m_action = 1;
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 0: {
                return DInfoPTM.getInfoPTMMap().isEmpty();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean fetchData() {
        try {
            switch (this.m_action) {
                case 0: {
                    if (this.needToFetch()) {
                        boolean bl = this.fetchPTMInfo();
                        return bl;
                    }
                }
                case 1: {
                    if (!this.needToFetch()) return true;
                    boolean bl = this.fetchIdentifiedPTMs();
                    return bl;
                }
            }
            return true;
        }
        finally {
            PerformanceTest.displayTimeAllThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchIdentifiedPTMs() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            TypedQuery query = entityManagerMSI.createQuery("SELECT DISTINCT(pp.specificity) FROM PeptidePtm pp, PeptideInstance pi JOIN FETCH pp.specificity.ptm ptm WHERE pi.resultSummary.id in (:rsmIds) AND pi.peptide.id = pp.peptide.id", PtmSpecificity.class);
            query.setParameter("rsmIds", this.m_rsmIds);
            this.m_ptmsOutput.addAll(query.getResultList());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPTMInfo() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            DatabasePTMsTask.fetchGenericPTMData(entityManagerMSI);
        }
        return true;
    }

    protected static void fetchGenericPTMData(EntityManager entityManagerMSI) {
        PerformanceTest.startTime((String)"fetchGenericPTMData");
        HashMap infoPTMMAp = DInfoPTM.getInfoPTMMap();
        if (!infoPTMMAp.isEmpty()) {
            PerformanceTest.stopTime((String)"fetchGenericPTMData");
            return;
        }
        TypedQuery ptmInfoQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DInfoPTM(spec.id, ptm.id, spec.residue, spec.location, ptm.shortName, evidence.composition, evidence.monoMass) \nFROM fr.proline.core.orm.msi.PtmSpecificity as spec, fr.proline.core.orm.msi.Ptm as ptm, fr.proline.core.orm.msi.PtmEvidence as evidence \nWHERE spec.ptm=ptm AND ptm=evidence.ptm AND evidence.type='Precursor' ", DInfoPTM.class);
        List ptmInfoList = ptmInfoQuery.getResultList();
        for (DInfoPTM infoPTM : ptmInfoList) {
            DInfoPTM.addInfoPTM((DInfoPTM)infoPTM);
        }
        PerformanceTest.stopTime((String)"fetchGenericPTMData");
    }

    protected static HashMap<Long, ArrayList<DPeptidePTM>> fetchPeptidePTMForPeptides(EntityManager entityManagerMSI, ArrayList<Long> allPeptidesIds) {
        PerformanceTest.startTime((String)"fetchPeptidePTMForPeptides");
        HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = new HashMap<Long, ArrayList<DPeptidePTM>>();
        TypedQuery ptmQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptidePTM(pptm.peptide.id, pptm.specificity.id, pptm.seqPosition) \nFROM PeptidePtm as pptm  \nWHERE pptm.peptide.id IN (:peptideList) ", DPeptidePTM.class);
        ptmQuery.setParameter("peptideList", allPeptidesIds);
        List ptmList = ptmQuery.getResultList();
        for (DPeptidePTM ptm : ptmList) {
            Long peptideId = ptm.getIdPeptide();
            ArrayList list = ptmMap.computeIfAbsent(peptideId, k -> new ArrayList());
            list.add(ptm);
        }
        PerformanceTest.stopTime((String)"fetchPeptidePTMForPeptides");
        return ptmMap;
    }

    public static void fillReadablePTMDataForPeptides(EntityManager entityManagerMSI, Long rsetId, HashMap<Long, Peptide> peptideMap, List<Long> sliceOfPeptideMatchIds) {
        if (peptideMap == null || peptideMap.isEmpty()) {
            return;
        }
        if (sliceOfPeptideMatchIds == null) {
            sliceOfPeptideMatchIds = new ArrayList<Long>(peptideMap.keySet());
        }
        Query ptmStingQuery = entityManagerMSI.createQuery("SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString WHERE p.id IN (:listId) AND ptmString.peptide=p AND ptmString.resultSet.id=:rsetId");
        ptmStingQuery.setParameter("listId", sliceOfPeptideMatchIds);
        ptmStingQuery.setParameter("rsetId", (Object)rsetId);
        List ptmStrings = ptmStingQuery.getResultList();
        for (Object[] res : ptmStrings) {
            Long peptideId = (Long)res[0];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
            Peptide peptide = peptideMap.get(peptideId);
            peptide.getTransientData().setPeptideReadablePtmString(ptmString);
        }
    }

    public static void fillPeptidePTMForPeptides(EntityManager entityManagerMSI, HashMap<Long, Peptide> peptideMap, List<Long> sliceOfPeptideMatchIds) {
        if (!peptideMap.isEmpty()) {
            if (sliceOfPeptideMatchIds == null) {
                sliceOfPeptideMatchIds = new ArrayList<Long>(peptideMap.keySet());
            }
            TypedQuery ptmQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptidePTM(pptm.peptide.id, pptm.specificity.id, pptm.seqPosition) FROM fr.proline.core.orm.msi.PeptidePtm pptm WHERE pptm.peptide.id IN (:peptideIds)", DPeptidePTM.class);
            ptmQuery.setParameter("peptideIds", sliceOfPeptideMatchIds);
            List ptmList = ptmQuery.getResultList();
            for (DPeptidePTM ptm : ptmList) {
                Peptide p = peptideMap.get(ptm.getIdPeptide());
                HashMap<Integer, DPeptidePTM> map = p.getTransientData().getDPeptidePtmMap();
                if (map == null) {
                    map = new HashMap<Integer, DPeptidePTM>();
                    p.getTransientData().setDPeptidePtmMap(map);
                }
                map.put((int)ptm.getSeqPosition(), ptm);
            }
        }
    }
}

