/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.Peaklist;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabasePeaklistTask
extends AbstractDatabaseTask {
    private long m_rsetID = -1L;
    private long m_projectID = -1L;
    private Peaklist[] m_peaklist = null;
    private String m_rawFileIdentifier = null;
    private int m_action;
    private static final int LOAD_PEAKLIST_FOR_RS = 0;
    private static final int UPDATE_PEAKLIST = 1;

    public DatabasePeaklistTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initUpdatePeaklistIdentifier(long projectId, Long rsetId, String peaklistIdentifier) {
        this.setTaskInfo(new TaskInfo(" Updating Raw File Identifier ", false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW, true));
        this.m_projectID = projectId;
        this.m_rsetID = rsetId;
        this.m_rawFileIdentifier = peaklistIdentifier;
        this.m_action = 1;
    }

    public void initLoadPeaklistForRS(long rsetID, long projectID, Peaklist[] peaklist) {
        this.setTaskInfo(new TaskInfo(" Load Peaklist for rset ID " + rsetID, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW, true));
        this.m_rsetID = rsetID;
        this.m_projectID = projectID;
        this.m_peaklist = peaklist;
        this.m_action = 0;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 0: {
                return this.loadPeaklistForRS();
            }
            case 1: {
                return this.updatePeaklistRawFileIdentifier();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePeaklistRawFileIdentifier() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectID).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            Query rawFileUpdateQuery = entityManagerMSI.createQuery("UPDATE Peaklist as plist set plist.rawFileId = :identifier WHERE plist.id  IN (SELECT plist FROM Peaklist plist, MsiSearch search, ResultSet rset WHERE rset.id = :rsetId AND rset.msiSearch=search AND search.peaklist=plist)");
            rawFileUpdateQuery.setParameter("rsetId", (Object)this.m_rsetID);
            rawFileUpdateQuery.setParameter("identifier", (Object)this.m_rawFileIdentifier);
            rawFileUpdateQuery.executeUpdate();
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPeaklistForRS() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectID).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            TypedQuery peaklistQuery = entityManagerMSI.createQuery("SELECT plist FROM Peaklist plist, MsiSearch search, ResultSet rset WHERE rset.id = :rsetId AND rset.msiSearch=search AND search.peaklist=plist", Peaklist.class);
            peaklistQuery.setMaxResults(1);
            peaklistQuery.setParameter("rsetId", (Object)this.m_rsetID);
            List peaklistList = peaklistQuery.getResultList();
            if (!peaklistList.isEmpty()) {
                this.m_peaklist[0] = (Peaklist)peaklistList.get(0);
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }
}

