/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptidesInstancesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.SubTaskManager;
import fr.proline.studio.dam.tasks.data.AdjacencyMatrixData;
import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabaseProteinsAndPeptidesTask
extends AbstractDatabaseTask {
    private static final int LOAD_ALL_PROTEINS_AND_PEPTIDES = 0;
    private static final int LOAD_PROTEINS_AND_PEPTIDES_FROM_IDS = 1;
    private long m_projectId = -1L;
    private ResultSummary m_rsm = null;
    private AdjacencyMatrixData m_adjacencyMatrixData = null;
    ArrayList<Long> m_proteinMatchIdArray;
    ArrayList<Long> m_peptideMatchIdArray;
    HashMap<Long, DProteinMatch> m_proteinMatchMap;
    HashMap<Long, DPeptideMatch> m_peptideMatchMap;
    private final int m_action;

    public DatabaseProteinsAndPeptidesTask(AbstractDatabaseCallback callback, long projectId, ResultSummary rsm, AdjacencyMatrixData adjacencyMatrixData) {
        super(callback, new TaskInfo("Load All Proteins and Peptides for " + rsm.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsm = rsm;
        this.m_adjacencyMatrixData = adjacencyMatrixData;
        this.m_action = 0;
    }

    public DatabaseProteinsAndPeptidesTask(AbstractDatabaseCallback callback, long projectId, ResultSummary rsm, ArrayList<Long> proteinMatchIdArray, ArrayList<Long> peptideMatchIdArray, HashMap<Long, DProteinMatch> proteinMatchMap, HashMap<Long, DPeptideMatch> peptideMatchMap) {
        super(callback, new TaskInfo("Load Proteins and Peptides for an Adjacency Matrix", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsm = rsm;
        this.m_proteinMatchIdArray = proteinMatchIdArray;
        this.m_peptideMatchIdArray = peptideMatchIdArray;
        this.m_proteinMatchMap = proteinMatchMap;
        this.m_peptideMatchMap = peptideMatchMap;
        this.m_action = 1;
    }

    @Override
    public boolean needToFetch() {
        return true;
    }

    @Override
    public boolean fetchData() {
        if (this.m_action == 0) {
            if (this.needToFetch()) {
                return this.fetchAllProteinsAndPeptides();
            }
        } else if (this.m_action == 1 && this.needToFetch()) {
            return this.fetchProteinsAndPeptidesFromIds();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchProteinsAndPeptidesFromIds() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            TypedQuery proteinMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(protm.id, protm.accession, protm.score, protm.peptideCount, protm.resultSet.id, protm.description, protm.geneName, protm.serializedProperties)  FROM ProteinMatch protm WHERE protm.id IN (:listId) ", DProteinMatch.class);
            proteinMatchQuery.setParameter("listId", this.m_proteinMatchIdArray);
            List proteinMatchList = proteinMatchQuery.getResultList();
            for (DProteinMatch pm : proteinMatchList) {
                this.m_proteinMatchMap.put(pm.getId(), pm);
            }
            Query peptideSetQuery = entityManagerMSI.createQuery("SELECT ps_to_pm.id.proteinMatchId, ps.id, ps.score, ps.sequenceCount, ps.peptideCount, ps.peptideMatchCount, ps.resultSummaryId FROM PeptideSet ps, PeptideSetProteinMatchMap ps_to_pm WHERE ps_to_pm.id.proteinMatchId IN (:listId) AND ps_to_pm.id.peptideSetId=ps.id AND ps_to_pm.resultSummary.id=:rsmId");
            peptideSetQuery.setParameter("listId", this.m_proteinMatchIdArray);
            peptideSetQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
            List peptideSets = peptideSetQuery.getResultList();
            for (Object[] res : peptideSets) {
                Long proteinMatchId = (Long)res[0];
                Long psId = (Long)res[1];
                Float psScore = (Float)res[2];
                Integer psSequenceCount = (Integer)res[3];
                Integer psPeptideCount = (Integer)res[4];
                Integer psPeptideMatchCount = (Integer)res[5];
                Long psResultSummaryId = (Long)res[6];
                this.m_proteinMatchMap.get(proteinMatchId).setPeptideSet(Long.valueOf(this.m_rsm.getId()), new DPeptideSet(psId.longValue(), psScore.floatValue(), psSequenceCount.intValue(), psPeptideCount.intValue(), psPeptideMatchCount.intValue(), psResultSummaryId.longValue()));
            }
            TypedQuery peptideMatchQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.isDecoy, pm.serializedProperties) FROM fr.proline.core.orm.msi.PeptideMatch pm WHERE pm.id IN (:listId) ", DPeptideMatch.class);
            peptideMatchQuery.setParameter("listId", this.m_peptideMatchIdArray);
            List peptideMatchList = peptideMatchQuery.getResultList();
            for (int i = 0; i < peptideMatchList.size(); ++i) {
                DPeptideMatch p = (DPeptideMatch)peptideMatchList.get(i);
                this.m_peptideMatchMap.put(p.getId(), p);
            }
            Query peptideQuery = entityManagerMSI.createQuery("SELECT pm.id, p FROM PeptideMatch pm, fr.proline.core.orm.msi.Peptide p WHERE pm.id IN (:listId) AND pm.peptideId=p.id");
            peptideQuery.setParameter("listId", this.m_peptideMatchIdArray);
            List peptides = peptideQuery.getResultList();
            for (Object[] res : peptides) {
                Long peptideMatchId = (Long)res[0];
                Peptide peptide = (Peptide)res[1];
                this.m_peptideMatchMap.get(peptideMatchId).setPeptide(peptide);
            }
            HashMap<Long, Peptide> tmpMap = new HashMap<Long, Peptide>();
            Iterator itProt = proteinMatchList.iterator();
            while (itProt.hasNext()) {
                DatabaseLoadPeptidesInstancesTask.fetchPeptideDataForProteinMatch(entityManagerMSI, this.m_rsm, (DProteinMatch)itProt.next(), tmpMap);
                tmpMap.clear();
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchAllProteinsAndPeptides() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            Long peptideMatchId;
            entityManagerMSI.getTransaction().begin();
            HashMap<Long, LightProteinMatch> proteinMatchMap = new HashMap<Long, LightProteinMatch>();
            HashMap<Long, LightPeptideMatch> peptideMatchMap = new HashMap<Long, LightPeptideMatch>();
            HashMap<LightProteinMatch, ArrayList<LightPeptideMatch>> proteinToPeptideMap = new HashMap<LightProteinMatch, ArrayList<LightPeptideMatch>>();
            HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> peptideToProteinMap = new HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>>();
            ArrayList<LightProteinMatch> allProteins = new ArrayList<LightProteinMatch>();
            ArrayList<LightPeptideMatch> allPeptides = new ArrayList<LightPeptideMatch>();
            Query proteinMatchQuery = entityManagerMSI.createQuery("SELECT pm.id, pm.accession, pm.score, ps.id, ps.representativeProteinMatchId FROM ProteinMatch pm, ProteinSetProteinMatchItem ps_to_pm, ProteinSet ps WHERE ps_to_pm.proteinMatch.id=pm.id AND ps_to_pm.resultSummary.id=:rsmId AND ps_to_pm.id.proteinMatchId=pm.id AND ps_to_pm.id.proteinSetId=ps.id AND ps.isValidated=true");
            proteinMatchQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
            List proteinMatchList = proteinMatchQuery.getResultList();
            ArrayList<Long> proteinMatchIdList = new ArrayList<Long>(proteinMatchList.size());
            for (Object[] res : proteinMatchList) {
                Long proteinMatchId = (Long)res[0];
                proteinMatchIdList.add(proteinMatchId);
                String accession = (String)res[1];
                Float score = (Float)res[2];
                Long proteinSetId = (Long)res[3];
                Long representativeProteinMatchId = (Long)res[4];
                LightProteinMatch proteinMatch = new LightProteinMatch(proteinMatchId, accession, score, proteinSetId, representativeProteinMatchId);
                proteinMatchMap.put(proteinMatchId, proteinMatch);
            }
            HashMap<Long, ArrayList<Long>> proteinToPeptideIdMap = new HashMap<Long, ArrayList<Long>>();
            HashSet<Long> peptidesSet = new HashSet<Long>();
            int SLICE_SIZE = 1000;
            SubTaskManager subTaskManager = new SubTaskManager(1);
            SubTask subTask = subTaskManager.sliceATaskAndGetFirst(0, proteinMatchIdList.size(), 1000);
            while (subTask != null) {
                Query proteinMatch2PepMatchQuery = entityManagerMSI.createQuery("SELECT pm.id, pepm.id FROM ProteinMatch pm, PeptideSetProteinMatchMap pepset_to_pm, PeptideMatch pepm, PeptideSetPeptideInstanceItem ps_to_pi, PeptideInstance pi WHERE pm.id IN (:pmlist) AND pepset_to_pm.resultSummary.id=:rsmId   AND pepset_to_pm.id.proteinMatchId=pm.id AND pepset_to_pm.id.peptideSetId=ps_to_pi.id.peptideSetId AND ps_to_pi.id.peptideInstanceId = pi.id AND pi.bestPeptideMatchId=pepm.id ORDER BY pepm.id");
                proteinMatch2PepMatchQuery.setParameter("pmlist", (Object)subTask.getSubList(proteinMatchIdList));
                proteinMatch2PepMatchQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
                List resList = proteinMatch2PepMatchQuery.getResultList();
                for (Object[] res : resList) {
                    Long proteinMatchId = (Long)res[0];
                    peptideMatchId = (Long)res[1];
                    ArrayList<Long> peptideArray = (ArrayList<Long>)proteinToPeptideIdMap.get(proteinMatchId);
                    if (peptideArray == null) {
                        peptideArray = new ArrayList<Long>();
                        proteinToPeptideIdMap.put(proteinMatchId, peptideArray);
                    }
                    peptideArray.add(peptideMatchId);
                    peptidesSet.add(peptideMatchId);
                }
                subTask = subTaskManager.getNextSubTask();
            }
            ArrayList peptides = new ArrayList(peptidesSet);
            subTaskManager = new SubTaskManager(1);
            subTask = subTaskManager.sliceATaskAndGetFirst(0, peptides.size(), 1000);
            while (subTask != null) {
                Query peptideMatchQuery = entityManagerMSI.createQuery("SELECT pepm.id, pepm.score, pepm.cdPrettyRank, pep.sequence FROM PeptideMatch pepm, fr.proline.core.orm.msi.Peptide pep WHERE pepm.id IN (:pepList) AND pepm.peptideId=pep.id");
                peptideMatchQuery.setParameter("pepList", (Object)subTask.getSubList(peptides));
                List resList = peptideMatchQuery.getResultList();
                for (Object[] res : resList) {
                    peptideMatchId = (Long)res[0];
                    Float score = (Float)res[1];
                    Integer cdPrettyRank = (Integer)res[2];
                    String sequence = (String)res[3];
                    LightPeptideMatch peptideMatch = new LightPeptideMatch(peptideMatchId, score, cdPrettyRank, sequence);
                    peptideMatchMap.put(peptideMatchId, peptideMatch);
                    allPeptides.add(peptideMatch);
                }
                subTask = subTaskManager.getNextSubTask();
            }
            HashMap<Long, LightProteinMatch> proteinSetIdToTypical = new HashMap<Long, LightProteinMatch>();
            for (Long proteinId : proteinToPeptideIdMap.keySet()) {
                LightProteinMatch protein = (LightProteinMatch)proteinMatchMap.get(proteinId);
                long proteinSetId = protein.getProteinSetId();
                long typicalProteinId = protein.getRepresentativeProteinMatchId();
                if (typicalProteinId != proteinId) continue;
                proteinSetIdToTypical.put(proteinSetId, protein);
                allProteins.add(protein);
            }
            HashMap<LightProteinMatch, ArrayList<LightProteinMatch>> equivalentProteins = new HashMap<LightProteinMatch, ArrayList<LightProteinMatch>>();
            HashMap<LightProteinMatch, LightProteinMatch> equivalentToMainProtein = new HashMap<LightProteinMatch, LightProteinMatch>();
            HashMap proteinSetIdToSubsetsProteins = new HashMap();
            for (Long proteinId : proteinToPeptideIdMap.keySet()) {
                LightProteinMatch protein = (LightProteinMatch)proteinMatchMap.get(proteinId);
                long proteinSetId = protein.getProteinSetId();
                LightProteinMatch typicalProtein = (LightProteinMatch)proteinSetIdToTypical.get(proteinSetId);
                ArrayList typicalPeptideIdList = (ArrayList)proteinToPeptideIdMap.get(typicalProtein.getId());
                int nbPeptidesTypical = typicalPeptideIdList.size();
                ArrayList peptideIdList = (ArrayList)proteinToPeptideIdMap.get(protein.getId());
                int nbPeptides = peptideIdList.size();
                if (nbPeptides == nbPeptidesTypical) {
                    if (typicalProtein.equals(protein)) continue;
                    ArrayList<LightProteinMatch> equivalentProteinsArray = equivalentProteins.get(typicalProtein);
                    if (equivalentProteinsArray == null) {
                        equivalentProteinsArray = new ArrayList();
                        equivalentProteins.put(typicalProtein, equivalentProteinsArray);
                    }
                    equivalentProteinsArray.add(protein);
                    equivalentToMainProtein.put(protein, typicalProtein);
                    continue;
                }
                ArrayList<LightProteinMatch> subsetMainProteins = (ArrayList<LightProteinMatch>)proteinSetIdToSubsetsProteins.get(proteinSetId);
                if (subsetMainProteins == null) {
                    subsetMainProteins = new ArrayList<LightProteinMatch>();
                    subsetMainProteins.add(protein);
                    allProteins.add(protein);
                    proteinSetIdToSubsetsProteins.put(proteinSetId, subsetMainProteins);
                    continue;
                }
                boolean correspondingProtein = false;
                Iterator subsetMainProteinsIt = subsetMainProteins.iterator();
                LightProteinMatch proteinCur = null;
                while (subsetMainProteinsIt.hasNext()) {
                    proteinCur = (LightProteinMatch)subsetMainProteinsIt.next();
                    ArrayList petidesListCur = (ArrayList)proteinToPeptideIdMap.get(proteinCur.getId());
                    int nbPeptidesCur = petidesListCur.size();
                    if (nbPeptides != nbPeptidesCur) continue;
                    boolean peptidesCorrespond = true;
                    for (int i = 0; i < nbPeptides; ++i) {
                        long idCur;
                        long id1 = (Long)peptideIdList.get(i);
                        if (id1 == (idCur = ((Long)petidesListCur.get(i)).longValue())) continue;
                        peptidesCorrespond = false;
                        break;
                    }
                    if (!peptidesCorrespond) continue;
                    correspondingProtein = true;
                    break;
                }
                if (!correspondingProtein) {
                    subsetMainProteins.add(protein);
                    allProteins.add(protein);
                    continue;
                }
                ArrayList<LightProteinMatch> equivalentProteinsArray = equivalentProteins.get(proteinCur);
                if (equivalentProteinsArray == null) {
                    equivalentProteinsArray = new ArrayList();
                    equivalentProteins.put(proteinCur, equivalentProteinsArray);
                }
                equivalentProteinsArray.add(protein);
                equivalentToMainProtein.put(protein, proteinCur);
            }
            for (LightProteinMatch protein : allProteins) {
                ArrayList peptideIdList = (ArrayList)proteinToPeptideIdMap.get(protein.getId());
                ArrayList<LightPeptideMatch> peptideMatchList = new ArrayList<LightPeptideMatch>(peptideIdList.size());
                for (Long peptideId : peptideIdList) {
                    LightPeptideMatch peptide = (LightPeptideMatch)peptideMatchMap.get(peptideId);
                    peptideMatchList.add(peptide);
                    ArrayList<LightProteinMatch> proteinList = peptideToProteinMap.get(peptide);
                    if (proteinList == null) {
                        proteinList = new ArrayList();
                        peptideToProteinMap.put(peptide, proteinList);
                    }
                    proteinList.add(protein);
                }
                proteinToPeptideMap.put(protein, peptideMatchList);
            }
            this.m_adjacencyMatrixData.setData(allProteins, allPeptides, proteinToPeptideMap, peptideToProteinMap, equivalentProteins, equivalentToMainProtein);
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }
}

