/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.xic;

import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.MapTime;
import java.util.List;

public class MapAlignmentConverter {
    public static Double convertElutionTime(Double elutionTime, Long sourceMapId, Long targetMapId, List<MapAlignment> listMapAlignment, Long alnRefMapId) throws Exception {
        if (listMapAlignment == null || listMapAlignment.isEmpty()) {
            throw new Exception("can't convert elution time without a defined listMapAlignment");
        }
        if (elutionTime.isNaN()) {
            throw new Exception("can't convert undefined elution time");
        }
        if (sourceMapId == null || sourceMapId < 1L) {
            throw new Exception("sourceMapId  must be defined");
        }
        if (targetMapId == null || targetMapId < 1L) {
            throw new Exception("targetMapId  must be defined");
        }
        if (alnRefMapId == null || alnRefMapId < 1L) {
            throw new Exception("alnRefMapId  must be defined");
        }
        if (sourceMapId.equals(targetMapId)) {
            return elutionTime;
        }
        MapAlignment mapAln = MapAlignmentConverter.getMapAlgn(sourceMapId, targetMapId, listMapAlignment);
        if (mapAln != null) {
            return MapAlignmentConverter.calcTargetMapElutionTime(mapAln, elutionTime);
        }
        MapAlignment refMapAln = MapAlignmentConverter.getMapAlgn(sourceMapId, alnRefMapId, listMapAlignment);
        Double refTime = MapAlignmentConverter.calcTargetMapElutionTime(refMapAln, elutionTime);
        MapAlignment targetMapAln = MapAlignmentConverter.getMapAlgn(alnRefMapId, targetMapId, listMapAlignment);
        return MapAlignmentConverter.calcTargetMapElutionTime(targetMapAln, refTime);
    }

    public static MapAlignment getMapAlgn(Long sourceMapId, Long targetMapId, List<MapAlignment> listMapAlignment) {
        for (MapAlignment mapAlignment : listMapAlignment) {
            if (!mapAlignment.getSourceMap().getId().equals(sourceMapId) || !mapAlignment.getDestinationMap().getId().equals(targetMapId)) continue;
            return mapAlignment;
        }
        return null;
    }

    public static Double calcTargetMapElutionTime(MapAlignment mapAlignment, Double refTime) throws Exception {
        List mapTimeList = mapAlignment.getMapTimeList();
        int nb = mapTimeList.size();
        double[] times = new double[nb];
        double[] deltaTimes = new double[nb];
        int i = 0;
        for (MapTime mapTime : mapTimeList) {
            times[i] = mapTime.getTime();
            deltaTimes[i] = mapTime.getDeltaValue();
            ++i;
        }
        return refTime + MapAlignmentConverter.linearInterpolation(refTime, times, deltaTimes);
    }

    public static Double linearInterpolation(double refTime, double[] x, double[] y) throws Exception {
        int index = -1;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] >= refTime)) continue;
            index = i;
            break;
        }
        if (index == -1 && refTime < x[0]) {
            index = 0;
        }
        if (index == 0) {
            return y[0];
        }
        if (index == -1) {
            return y[y.length - 1];
        }
        double x1 = x[index - 1];
        double y1 = y[index - 1];
        double x2 = x[index];
        double y2 = y[index];
        if (x1 == x2) {
            return (y1 + y2) / 2.0;
        }
        double[] lineP = MapAlignmentConverter.calcLineParams(x1, y1, x2, y2);
        return lineP[0] * refTime + lineP[1];
    }

    private static double[] calcLineParams(double x1, double y1, double x2, double y2) throws Exception {
        double[] lineP = new double[2];
        double deltaX = x2 - x1;
        if (deltaX == 0.0) {
            throw new Exception("can't solve line parameters with two identical x values (" + x1 + ")");
        }
        double slope = (y2 - y1) / deltaX;
        double intercept = y1 - slope * x1;
        lineP[0] = slope;
        lineP[1] = intercept;
        return lineP;
    }
}

