/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.MergeMode;
import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.JsonSerializer;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.core.orm.util.TransientDataInterface;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="result_set")
public class ResultSet
implements Serializable,
TransientDataInterface {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="creation_log")
    private String creationLog;
    private String description;
    @Column(name="creation_timestamp")
    private Timestamp creationTimestamp = new Timestamp(new Date().getTime());
    private String name;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Basic
    @Enumerated(value=EnumType.STRING)
    private Type type;
    @ManyToOne
    @JoinColumn(name="decoy_result_set_id")
    private ResultSet decoyResultSet;
    @Column(name="merged_rsm_id")
    private Long mergedRsmId;
    @ManyToOne
    @JoinColumn(name="msi_search_id")
    private MsiSearch msiSearch;
    @OneToMany
    @JoinTable(name="result_set_relation", joinColumns={@JoinColumn(name="parent_result_set_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="child_result_set_id", referencedColumnName="id")})
    private Set<ResultSet> children;
    @ElementCollection
    @MapKeyColumn(name="schema_name")
    @Column(name="object_tree_id")
    @CollectionTable(name="result_set_object_tree_map", joinColumns={@JoinColumn(name="result_set_id", referencedColumnName="id")})
    private Map<String, Long> objectTreeIdByName;
    @Transient
    private TransientData transientData = null;
    @Transient
    private Map<String, Object> serializedPropertiesMap;
    @Transient
    private MergeMode mergeMode;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getCreationLog() {
        return this.creationLog;
    }

    public void setCreationLog(String creationLog) {
        this.creationLog = creationLog;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Timestamp getCreationTimestamp() {
        Timestamp result = null;
        if (this.creationTimestamp != null) {
            result = (Timestamp)this.creationTimestamp.clone();
        }
        return result;
    }

    public void setCreationTimestamp(Timestamp pCreationTimestamp) {
        if (pCreationTimestamp == null) {
            throw new IllegalArgumentException("PModificationTimestamp is null");
        }
        this.creationTimestamp = (Timestamp)pCreationTimestamp.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
        this.serializedPropertiesMap = null;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ResultSet getDecoyResultSet() {
        return this.decoyResultSet;
    }

    public void setDecoyResultSet(ResultSet decoyResultSet) {
        this.decoyResultSet = decoyResultSet;
    }

    public Long getMergedRsmId() {
        return this.mergedRsmId;
    }

    public void setMergedRsmId(Long pMergedRsmId) {
        this.mergedRsmId = pMergedRsmId;
    }

    public MsiSearch getMsiSearch() {
        return this.msiSearch;
    }

    public void setMsiSearch(MsiSearch msiSearch) {
        this.msiSearch = msiSearch;
    }

    public Set<ResultSet> getChildren() {
        return this.children;
    }

    public void setChildren(Set<ResultSet> children) {
        this.children = children;
    }

    void setObjectTreeIdByName(Map<String, Long> objectTree) {
        this.objectTreeIdByName = objectTree;
    }

    public Map<String, Long> getObjectTreeIdByName() {
        return this.objectTreeIdByName;
    }

    public Long putObject(String schemaName, long objectId) {
        if (StringUtils.isEmpty((String)schemaName)) {
            throw new IllegalArgumentException("Invalid schemaName");
        }
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree == null) {
            localObjectTree = new HashMap<String, Long>();
            this.setObjectTreeIdByName(localObjectTree);
        }
        return localObjectTree.put(schemaName, objectId);
    }

    public Long removeObject(String schemaName) {
        Long result = null;
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree != null) {
            result = localObjectTree.remove(schemaName);
        }
        return result;
    }

    public TransientData getTransientData(TransientDataAllocationListener listener) {
        if (this.transientData == null) {
            this.transientData = new TransientData();
            if (listener != null) {
                listener.memoryAllocated(this);
            }
        }
        return this.transientData;
    }

    public Map<String, Object> getSerializedPropertiesAsMap() throws Exception {
        if (this.serializedPropertiesMap == null && this.serializedProperties != null) {
            this.serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(this.getSerializedProperties(), Map.class);
        }
        return this.serializedPropertiesMap;
    }

    public void setSerializedPropertiesAsMap(Map<String, Object> serializedPropertiesMap) throws Exception {
        this.serializedPropertiesMap = serializedPropertiesMap;
        this.serializedProperties = JsonSerializer.getMapper().writeValueAsString(serializedPropertiesMap);
    }

    public MergeMode getMergeMode() throws Exception {
        if (this.mergeMode == null) {
            String mode = (String)this.getSerializedPropertiesAsMap().getOrDefault("merge_mode", MergeMode.NO_MERGE.name());
            this.mergeMode = MergeMode.valueOf(mode.toUpperCase());
        }
        return this.mergeMode;
    }

    public void setMergeMode(MergeMode mode) {
        this.mergeMode = mode;
    }

    @Override
    public void clearMemory() {
        this.transientData = null;
    }

    public String getMemoryName() {
        return "Search Result " + this.getName();
    }

    @Override
    public String getMemoryName(String additionalName) {
        String rSetName = this.getName();
        if (rSetName == null || rSetName.length() == 0) {
            return "Search Result " + additionalName;
        }
        return "Search Result " + rSetName;
    }

    public static class TransientData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long[] peptideMatchIds;
        private DPeptideMatch[] peptideMatches = null;
        private DProteinMatch[] proteinMatches = null;
        private Integer peptideMatchesCount = null;
        private Integer proteinMatchesCount = null;
        private Integer msQueriesCount = null;

        public long[] getPeptideMatchIds() {
            return this.peptideMatchIds;
        }

        public void setPeptideMatchIds(long[] peptideMatchIds) {
            this.peptideMatchIds = peptideMatchIds;
        }

        public Integer getPeptideMatchesCount() {
            return this.peptideMatchesCount;
        }

        public void setPeptideMatchesCount(Integer peptideMatchesCount) {
            this.peptideMatchesCount = peptideMatchesCount;
        }

        public Integer getProteinMatchesCount() {
            return this.proteinMatchesCount;
        }

        public void setProteinMatchesCount(Integer proteinMatchesCount) {
            this.proteinMatchesCount = proteinMatchesCount;
        }

        public Integer getMSQueriesCount() {
            return this.msQueriesCount;
        }

        public DPeptideMatch[] getPeptideMatches() {
            return this.peptideMatches;
        }

        public void setPeptideMatches(DPeptideMatch[] peptideMatches) {
            this.peptideMatches = peptideMatches;
            if (peptideMatches != null) {
                this.peptideMatchesCount = peptideMatches.length;
            }
        }

        public DProteinMatch[] getProteinMatches() {
            return this.proteinMatches;
        }

        public void setProteinMatches(DProteinMatch[] proteinMatches) {
            this.proteinMatches = proteinMatches;
            if (proteinMatches != null) {
                this.proteinMatchesCount = proteinMatches.length;
            }
        }
    }

    public static enum Type {
        SEARCH,
        DECOY_SEARCH,
        USER,
        DECOY_USER,
        QUANTITATION;

    }
}

