/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.proline.core.orm.msi.MasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DCluster;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DQuantPeptide;
import fr.proline.core.orm.msi.dto.MasterQuantPeptideProperties;
import fr.proline.core.orm.util.JsonSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMasterQuantPeptide {
    private static final Logger LOG = LoggerFactory.getLogger(DMasterQuantPeptide.class);
    private long m_id;
    private long m_peptideInstanceId;
    private int m_selectionLevel;
    private long m_objectTreeId;
    private String m_serializedProperties;
    private Long m_quantResultSummaryId;
    private MasterQuantPeptideProperties m_mqPeptideProperties;
    protected Map<Long, DQuantPeptide> m_quantPeptideByQchIds = new HashMap<Long, DQuantPeptide>();
    List<MasterQuantPeptideIon> m_masterQPepIons;
    DPeptideInstance m_dPeptideInstance;
    DPeptideMatch m_representativePepMatch;
    DCluster m_cluster;

    protected DMasterQuantPeptide() {
    }

    public DMasterQuantPeptide(long id, int selectionLevel, long objectTreeId, String serializedProperties, Long quantResultSummaryId) {
        this.m_id = id;
        this.m_selectionLevel = selectionLevel;
        this.m_objectTreeId = objectTreeId;
        this.m_serializedProperties = serializedProperties;
        this.m_quantResultSummaryId = quantResultSummaryId;
    }

    public Map<Long, DQuantPeptide> parseQuantPeptideFromProperties(String quantPeptideData) {
        try {
            ObjectMapper objectMapper = JsonSerializer.getMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            List quantPeptides = (List)objectMapper.readValue(quantPeptideData, (TypeReference)new TypeReference<List<DQuantPeptide>>(){});
            this.m_quantPeptideByQchIds = new HashMap<Long, DQuantPeptide>();
            for (int i = 0; i < quantPeptides.size(); ++i) {
                DQuantPeptide nextQuantPeptide = (DQuantPeptide)quantPeptides.get(i);
                if (nextQuantPeptide == null) continue;
                this.m_quantPeptideByQchIds.put(nextQuantPeptide.quantChannelId, nextQuantPeptide);
            }
        }
        catch (Exception e) {
            LOG.warn("Error Parsing DQuantPeptide ", (Throwable)e);
            this.m_quantPeptideByQchIds = null;
        }
        return this.m_quantPeptideByQchIds;
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long m_id) {
        this.m_id = m_id;
    }

    public long getPeptideInstanceId() {
        return this.m_peptideInstanceId;
    }

    public void setPeptideInstanceId(long peptideInstanceId) {
        this.m_peptideInstanceId = peptideInstanceId;
    }

    public int getSelectionLevel() {
        return this.m_selectionLevel;
    }

    public void setSelectionLevel(int selectionLevel) {
        this.m_selectionLevel = selectionLevel;
    }

    public long getObjectTreeId() {
        return this.m_objectTreeId;
    }

    public void setObjectTreeId(long objectTreeId) {
        this.m_objectTreeId = objectTreeId;
    }

    public String getSerializedProperties() {
        return this.m_serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.m_serializedProperties = serializedProperties;
        this.m_mqPeptideProperties = null;
    }

    public Long getQuantResultSummaryId() {
        return this.m_quantResultSummaryId;
    }

    public void setQuantResultSummaryId(Long quantResultSummaryId) {
        this.m_quantResultSummaryId = quantResultSummaryId;
    }

    public MasterQuantPeptideProperties getMasterQuantPeptideProperties() {
        if (this.m_mqPeptideProperties == null && this.m_serializedProperties != null) {
            try {
                ObjectMapper objectMapper = JsonSerializer.getMapper();
                this.m_mqPeptideProperties = (MasterQuantPeptideProperties)objectMapper.readValue(this.m_serializedProperties, MasterQuantPeptideProperties.class);
            }
            catch (Exception e) {
                LOG.warn(" Error parsiong MasterQuantPeptideProperties ", (Throwable)e);
            }
        }
        return this.m_mqPeptideProperties;
    }

    public void setMasterQuantPeptideProperties(MasterQuantPeptideProperties mqPeptideProperties) {
        this.m_mqPeptideProperties = mqPeptideProperties;
    }

    public Map<Long, DQuantPeptide> getQuantPeptideByQchIds() {
        return this.m_quantPeptideByQchIds;
    }

    public void setQuantPeptideByQchIds(Map<Long, DQuantPeptide> quantPeptideByQchIds) {
        this.m_quantPeptideByQchIds = quantPeptideByQchIds;
    }

    public List<MasterQuantPeptideIon> getMasterQPepIons() {
        return this.m_masterQPepIons;
    }

    public void setMasterQPepIons(List<MasterQuantPeptideIon> masterQPepIons) {
        this.m_masterQPepIons = masterQPepIons;
    }

    public DPeptideInstance getPeptideInstance() {
        return this.m_dPeptideInstance;
    }

    public void setPeptideInstance(DPeptideInstance peptideInstance) {
        this.m_dPeptideInstance = peptideInstance;
    }

    public DPeptideMatch getRepresentativePepMatch() {
        if (this.m_representativePepMatch == null && this.m_dPeptideInstance != null) {
            return this.m_dPeptideInstance.getBestPeptideMatch();
        }
        return this.m_representativePepMatch;
    }

    public void setRepresentativePepMatch(DPeptideMatch representativePepMatch) {
        this.m_representativePepMatch = representativePepMatch;
    }

    public DCluster getCluster() {
        return this.m_cluster;
    }

    public void setCluster(DCluster cluster) {
        this.m_cluster = cluster;
    }
}

