/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.msi.dto.DQuantProteinSet;
import fr.proline.core.orm.msi.dto.MasterQuantProteinSetProperties;
import fr.proline.core.orm.util.JsonSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMasterQuantProteinSet {
    private static final Logger LOG = LoggerFactory.getLogger(DMasterQuantProteinSet.class);
    public static final String MASTER_QUANT_PROTEINSET_WITH_PEPTIDE_MODIFIED = "selection_changed";
    private long m_id;
    private long m_proteinSetId;
    private int m_selectionLevel;
    private long m_objectTreeId;
    private String m_serializedProperties;
    private Long m_quantResultSummaryId;
    private DProteinSet m_dProteinSet;
    private MasterQuantProteinSetProperties mqProteinSetProperties;
    Map<Long, DQuantProteinSet> quantProteinSetByQchIds = new HashMap<Long, DQuantProteinSet>();
    private Map<Long, String> quantStatusByQchIds = new HashMap<Long, String>();
    private Map<Long, Integer> quantPeptideNumberByQchIds = new HashMap<Long, Integer>();
    private int nbPeptides;
    private int nbQuantifiedPeptides;
    private Map<String, Object> serializedPropertiesMap = null;

    public DMasterQuantProteinSet() {
    }

    public DMasterQuantProteinSet(long id, int selectionLevel, Long objectTreeId, String serializedProperties, Long quantResultSummaryId, long proteinSetId) {
        this.m_id = id;
        this.m_quantResultSummaryId = quantResultSummaryId;
        this.m_selectionLevel = selectionLevel;
        this.m_serializedProperties = serializedProperties;
        this.m_objectTreeId = objectTreeId;
        this.m_proteinSetId = proteinSetId;
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long id) {
        this.m_id = id;
    }

    public Long getQuantResultSummaryId() {
        return this.m_quantResultSummaryId;
    }

    public void setQuantResultSummaryId(Long quantResultSummaryId) {
        this.m_quantResultSummaryId = quantResultSummaryId;
    }

    public int getSelectionLevel() {
        return this.m_selectionLevel;
    }

    public void setSelectionLevel(int selectionLevel) {
        this.m_selectionLevel = selectionLevel;
    }

    public Map<Long, DQuantProteinSet> parseQuantProteinSetFromProperties(String quantProtSetdata) {
        try {
            ObjectMapper objectMapper = JsonSerializer.getMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            List quantProtSets = (List)objectMapper.readValue(quantProtSetdata, (TypeReference)new TypeReference<List<DQuantProteinSet>>(){});
            this.quantProteinSetByQchIds = new HashMap<Long, DQuantProteinSet>();
            for (int i = 0; i < quantProtSets.size(); ++i) {
                DQuantProteinSet nextQuantProtSet = (DQuantProteinSet)quantProtSets.get(i);
                if (nextQuantProtSet == null) continue;
                this.quantProteinSetByQchIds.put(nextQuantProtSet.quantChannelId, nextQuantProtSet);
            }
        }
        catch (Exception e) {
            LOG.warn("Error Parsing DQuantProteinSet ", (Throwable)e);
            this.quantProteinSetByQchIds = null;
        }
        return this.quantProteinSetByQchIds;
    }

    public Map<Long, DQuantProteinSet> getQuantProteinSetByQchIds() {
        return this.quantProteinSetByQchIds;
    }

    public void setQuantProteinSetByQchIds(Map<Long, DQuantProteinSet> quantProteinSetByQchIds) {
        this.quantProteinSetByQchIds = quantProteinSetByQchIds;
    }

    public long getObjectTreeId() {
        return this.m_objectTreeId;
    }

    public void setObjectTreeId(long objectTreeId) {
        this.m_objectTreeId = objectTreeId;
    }

    public long getProteinSetId() {
        return this.m_proteinSetId;
    }

    public void setProteinSetId(long m_proteinSetId) {
        this.m_proteinSetId = m_proteinSetId;
    }

    public String getSerializedProperties() {
        return this.m_serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.m_serializedProperties = serializedProperties;
        this.mqProteinSetProperties = null;
    }

    public Map<String, Object> getSerializedPropertiesAsMap() throws Exception {
        if (this.serializedPropertiesMap == null && this.m_serializedProperties != null) {
            this.serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(this.getSerializedProperties(), Map.class);
        }
        return this.serializedPropertiesMap;
    }

    public void setMasterQuantProtSetProperties(MasterQuantProteinSetProperties properties) {
        this.mqProteinSetProperties = properties;
    }

    public MasterQuantProteinSetProperties getMasterQuantProtSetProperties() {
        if (this.mqProteinSetProperties == null && this.m_serializedProperties != null) {
            try {
                this.mqProteinSetProperties = this.parseJsonProperties(this.m_serializedProperties);
            }
            catch (Exception e) {
                LOG.warn(" Error parsiong MasterQuantProteinSetProperties ", (Throwable)e);
            }
        }
        return this.mqProteinSetProperties;
    }

    private MasterQuantProteinSetProperties parseJsonProperties(String jsonProperties) throws Exception {
        MasterQuantProteinSetProperties mqProtSetProperties = (MasterQuantProteinSetProperties)JsonSerializer.getMapper().readValue(jsonProperties, MasterQuantProteinSetProperties.class);
        return mqProtSetProperties;
    }

    public DProteinSet getProteinSet() {
        return this.m_dProteinSet;
    }

    public void setProteinSet(DProteinSet proteinSet) {
        this.m_dProteinSet = proteinSet;
    }

    public int getNbPeptides() {
        return this.nbPeptides;
    }

    public void setNbPeptides(int nbPeptides) {
        this.nbPeptides = nbPeptides;
    }

    public int getNbQuantifiedPeptides() {
        return this.nbQuantifiedPeptides;
    }

    public void setNbQuantifiedPeptides(int nbQuantifiedPeptides) {
        this.nbQuantifiedPeptides = nbQuantifiedPeptides;
    }

    public Map<Long, String> getQuantStatusByQchIds() {
        return this.quantStatusByQchIds;
    }

    public void setQuantStatusByQchIds(Map<Long, String> quantStatusByQchIds) {
        this.quantStatusByQchIds = quantStatusByQchIds;
    }

    @Deprecated
    public Map<Long, Integer> getQuantPeptideNumberByQchIds() {
        return this.quantPeptideNumberByQchIds;
    }

    @Deprecated
    public void setQuantPeptideNumberByQchIds(Map<Long, Integer> quantPeptideNumberByQchIds) {
        this.quantPeptideNumberByQchIds = quantPeptideNumberByQchIds;
    }
}

