/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.InstrumentConfig;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class MsiInstrumentConfigRepository {
    private MsiInstrumentConfigRepository() {
    }

    public static InstrumentConfig findInstrumConfForNameAndMs1AndMsn(EntityManager msiEm, String name, String ms1Analyzer, String msnAnalyzer) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        if (StringUtils.isEmpty((String)ms1Analyzer)) {
            throw new IllegalArgumentException("Invalid ms1Analyzer");
        }
        InstrumentConfig result = null;
        TypedQuery query = null;
        if (msnAnalyzer == null) {
            query = msiEm.createNamedQuery("findMsiInstrumConfForNameAndMs1", InstrumentConfig.class);
        } else {
            query = msiEm.createNamedQuery("findMsiInstrumConfForNameAndMs1AndMsn", InstrumentConfig.class);
            query.setParameter("msnAnalyzer", (Object)msnAnalyzer.toUpperCase());
        }
        query.setParameter("name", (Object)name.toUpperCase());
        query.setParameter("ms1Analyzer", (Object)ms1Analyzer.toUpperCase());
        List instrumConfs = query.getResultList();
        if (instrumConfs != null && !instrumConfs.isEmpty()) {
            if (instrumConfs.size() == 1) {
                result = (InstrumentConfig)instrumConfs.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one InstrumentConfiguration for given name, ms1Analyzer and msnAnalyzer");
            }
        }
        return result;
    }
}

