/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.util.JPARepositoryUtils;
import fr.proline.repository.util.JPAUtils;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class MsiPeptideRepository {
    private MsiPeptideRepository() {
    }

    public static List<Peptide> findPeptidesForSequence(EntityManager msiEm, String seq) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)seq)) {
            throw new IllegalArgumentException("Invalid seq");
        }
        TypedQuery query = msiEm.createNamedQuery("findMsiPepsForSeq", Peptide.class);
        query.setParameter("seq", (Object)seq.toUpperCase());
        return query.getResultList();
    }

    public static List<Peptide> findPeptidesForIds(EntityManager msiEm, Collection<Long> ids) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        return JPARepositoryUtils.executeInQueryAsBatch(msiEm.createNamedQuery("findMsiPepsForIds", Peptide.class), "ids", ids);
    }

    public static Peptide findPeptideForSequenceAndPtmStr(EntityManager msiEm, String seq, String ptmStr) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)seq)) {
            throw new IllegalArgumentException("Invalid seq");
        }
        Peptide result = null;
        TypedQuery query = null;
        if (ptmStr == null) {
            query = msiEm.createNamedQuery("findMsiPepsForSeqWOPtm", Peptide.class);
        } else {
            query = msiEm.createNamedQuery("findMsiPeptForSeqAndPtmStr", Peptide.class);
            query.setParameter("ptmStr", (Object)ptmStr.toUpperCase());
        }
        query.setParameter("seq", (Object)seq.toUpperCase());
        List peptides = query.getResultList();
        if (peptides != null && !peptides.isEmpty()) {
            if (peptides.size() == 1) {
                result = (Peptide)peptides.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one Peptide for given sequence and ptmString");
            }
        }
        return result;
    }
}

