/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.Ptm;
import fr.proline.core.orm.msi.PtmClassification;
import fr.proline.core.orm.msi.PtmEvidence;
import fr.proline.core.orm.msi.PtmSpecificity;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class MsiPtmRepository {
    private MsiPtmRepository() {
    }

    public static Ptm findPtmForName(EntityManager msiEm, String name) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        Ptm result = null;
        TypedQuery query = msiEm.createNamedQuery("findMsiPtmForName", Ptm.class);
        query.setParameter("name", (Object)name.toUpperCase());
        List ptms = query.getResultList();
        if (ptms != null && !ptms.isEmpty()) {
            if (ptms.size() == 1) {
                result = (Ptm)ptms.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one Ptm for given name");
            }
        }
        return result;
    }

    public static Ptm findPtmForShortName(EntityManager msiEm, String shortName) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)shortName)) {
            throw new IllegalArgumentException("Invalid short name");
        }
        Ptm result = null;
        TypedQuery query = msiEm.createNamedQuery("findMsiPtmForShortName", Ptm.class);
        query.setParameter("name", (Object)shortName.toUpperCase());
        List ptms = query.getResultList();
        if (ptms != null && !ptms.isEmpty()) {
            if (ptms.size() == 1) {
                result = (Ptm)ptms.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one Ptm for given short name");
            }
        }
        return result;
    }

    public static PtmEvidence findPtmEvidenceByPtmAndType(EntityManager msiEm, long ptmId, PtmEvidence.Type type) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        PtmEvidence result = null;
        TypedQuery query = msiEm.createNamedQuery("findPtmEvidenceByPtmAndType", PtmEvidence.class);
        query.setParameter("ptm_id", (Object)ptmId);
        query.setParameter("type", (Object)type);
        List ptmEvids = query.getResultList();
        if (ptmEvids != null && !ptmEvids.isEmpty()) {
            if (ptmEvids.size() == 1) {
                result = (PtmEvidence)ptmEvids.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one PtmEvidence for given ptmId and type");
            }
        }
        return result;
    }

    public static PtmSpecificity findPtmSpecificityForNameLocResidue(EntityManager msiEm, String ptmShortName, String location, Character residue) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)ptmShortName)) {
            throw new IllegalArgumentException("Invalid ptmShortName");
        }
        if (StringUtils.isEmpty((String)location)) {
            throw new IllegalArgumentException("Invalid location");
        }
        PtmSpecificity result = null;
        TypedQuery query = null;
        if (residue == null) {
            query = msiEm.createNamedQuery("findMsiPtmSpecForNameAndLoc", PtmSpecificity.class);
        } else {
            query = msiEm.createNamedQuery("findMsiPtmSpecForNameLocResidue", PtmSpecificity.class);
            query.setParameter("residue", (Object)residue);
        }
        query.setParameter("location", (Object)location.toUpperCase());
        query.setParameter("ptmShortName", (Object)ptmShortName.toUpperCase());
        List ptms = query.getResultList();
        if (ptms != null && !ptms.isEmpty()) {
            if (ptms.size() == 1) {
                result = (PtmSpecificity)ptms.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one PtmSpecificity for given name, location and residue");
            }
        }
        return result;
    }

    public static PtmClassification findPtmClassificationForName(EntityManager msiEm, String name) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        PtmClassification result = null;
        TypedQuery query = msiEm.createNamedQuery("findPtmClassificationForName", PtmClassification.class);
        query.setParameter("name", (Object)name.toUpperCase());
        List classifications = query.getResultList();
        if (classifications != null && !classifications.isEmpty()) {
            if (classifications.size() == 1) {
                result = (PtmClassification)classifications.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one PtmClassification for given name");
            }
        }
        return result;
    }
}

