/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.proline.core.orm.uds.Document;
import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.core.orm.uds.ProjectUserAccountMap;
import fr.proline.core.orm.uds.ProjectUserAccountMapPK;
import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.UserAccount;
import fr.proline.core.orm.uds.VirtualFolder;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Transient;

@Entity
@NamedQueries(value={@NamedQuery(name="findProjectsByMembership", query="Select p from Project p, ProjectUserAccountMap p2u, UserAccount u where u.id=:id and p2u.userAccount=u and p2u member OF p.projectUserAccountMap"), @NamedQuery(name="findProjectsByOwner", query="Select p from Project p where p.owner.id=:id"), @NamedQuery(name="findAllProjectIds", query="select p.id from fr.proline.core.orm.uds.Project p order by p.id"), @NamedQuery(name="findAllActiveProjectIds", query="select p.id from fr.proline.core.orm.uds.Project p WHERE ( (p.serializedProperties is null) OR (p.serializedProperties is not null and p.serializedProperties NOT LIKE '%\"is_active\":false%'))")})
public class Project
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String name;
    private String description;
    @Column(name="creation_timestamp")
    private Timestamp creationTimestamp = new Timestamp(new Date().getTime());
    @Column(name="lock_expiration_timestamp")
    private Timestamp lockExpirationTStamp;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="lock_user_id")
    private Long lockUserID;
    @ManyToOne
    @JoinColumn(name="owner_id")
    private UserAccount owner;
    @OneToMany(mappedBy="project")
    private Set<Document> documents;
    @ManyToMany
    @JoinTable(name="project_db_map", joinColumns={@JoinColumn(name="project_id")}, inverseJoinColumns={@JoinColumn(name="external_db_id")})
    private Set<ExternalDb> externalDatabases;
    @OneToMany(mappedBy="project")
    private Set<VirtualFolder> folders;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    private Set<ProjectUserAccountMap> projectUserAccountMap;
    @ManyToMany
    @JoinTable(name="raw_file_project_map", joinColumns={@JoinColumn(name="project_id")}, inverseJoinColumns={@JoinColumn(name="raw_file_identifier")})
    private Set<RawFile> rawFiles;
    @Transient
    private TransientData transientData = null;

    protected Project() {
    }

    public Project(UserAccount owner) {
        this.setOwner(owner);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Timestamp getCreationTimestamp() {
        Timestamp result = null;
        if (this.creationTimestamp != null) {
            result = (Timestamp)this.creationTimestamp.clone();
        }
        return result;
    }

    public void setCreationTimestamp(Timestamp pCreationTimestamp) {
        if (pCreationTimestamp == null) {
            throw new IllegalArgumentException("PCreationTimestamp is null");
        }
        this.creationTimestamp = (Timestamp)pCreationTimestamp.clone();
    }

    public Timestamp getLockExpirationTimestamp() {
        return this.lockExpirationTStamp;
    }

    public void setLockExpirationTimestamp(Timestamp lockTimestamp) {
        this.lockExpirationTStamp = lockTimestamp;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public Long getLockUserID() {
        return this.lockUserID;
    }

    public void setLockUserID(Long userID) {
        this.lockUserID = userID;
    }

    public UserAccount getOwner() {
        return this.owner;
    }

    public void setOwner(UserAccount owner) {
        this.owner = owner;
        this.addMember(owner, true);
    }

    public Set<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Set<Document> documents) {
        this.documents = documents;
    }

    public void setExternalDatabases(Set<ExternalDb> externalDatabases) {
        this.externalDatabases = externalDatabases;
    }

    public Set<ExternalDb> getExternalDatabases() {
        return this.externalDatabases;
    }

    public void addExternalDatabase(ExternalDb externalDb) {
        if (externalDb != null) {
            Set<ExternalDb> externalDbs = this.getExternalDatabases();
            if (externalDbs == null) {
                externalDbs = new HashSet<ExternalDb>();
                this.setExternalDatabases(externalDbs);
            }
            externalDbs.add(externalDb);
        }
    }

    public void removeExternalDb(ExternalDb externalDb) {
        Set<ExternalDb> externalDbs = this.getExternalDatabases();
        if (externalDbs != null) {
            externalDbs.remove(externalDb);
        }
    }

    public Set<VirtualFolder> getFolders() {
        return this.folders;
    }

    public void setFolders(Set<VirtualFolder> folders) {
        this.folders = folders;
    }

    void setProjectUserAccountMap(Set<ProjectUserAccountMap> userAccountMap) {
        this.projectUserAccountMap = userAccountMap;
    }

    public Set<ProjectUserAccountMap> getProjectUserAccountMap() {
        return this.projectUserAccountMap;
    }

    public void addMember(UserAccount member, boolean writePermission) {
        if (member != null) {
            Set<ProjectUserAccountMap> localMembers = this.getProjectUserAccountMap();
            ProjectUserAccountMapPK mapKey = new ProjectUserAccountMapPK();
            mapKey.setProjectId(this.id);
            mapKey.setUserAccountId(member.getId());
            ProjectUserAccountMap newMember = new ProjectUserAccountMap();
            newMember.setId(mapKey);
            newMember.setProject(this);
            newMember.setUserAccount(member);
            newMember.setWritePermission(writePermission);
            if (localMembers == null) {
                localMembers = new HashSet<ProjectUserAccountMap>();
                this.setProjectUserAccountMap(localMembers);
            }
            localMembers.add(newMember);
        }
    }

    public void removeMember(UserAccount member) {
        Set<ProjectUserAccountMap> localMembers = this.getProjectUserAccountMap();
        ProjectUserAccountMap userMap2Rem = null;
        if (localMembers != null) {
            for (ProjectUserAccountMap nextMember : localMembers) {
                if (!nextMember.getUserAccount().equals(member)) continue;
                userMap2Rem = nextMember;
                break;
            }
            if (userMap2Rem != null) {
                localMembers.remove(userMap2Rem);
            }
        }
    }

    public boolean isProjectMember(UserAccount member) {
        Set<ProjectUserAccountMap> localMembers = this.getProjectUserAccountMap();
        if (localMembers != null) {
            for (ProjectUserAccountMap element : localMembers) {
                if (element.getUserAccount().getId() != member.getId()) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public boolean isMemberProject(UserAccount member) {
        return this.isProjectMember(member);
    }

    public void setRawFiles(Set<RawFile> rawFiles) {
        this.rawFiles = rawFiles;
    }

    public Set<RawFile> getRawFiles() {
        return this.rawFiles;
    }

    public void addRawFile(RawFile rawFile) {
        if (rawFile != null) {
            Set<RawFile> rawFiles = this.getRawFiles();
            if (rawFiles == null) {
                rawFiles = new HashSet<RawFile>();
                this.setRawFiles(rawFiles);
            }
            rawFiles.add(rawFile);
        }
    }

    public void removeRawFile(RawFile rawFile) {
        Set<RawFile> rawFiles = this.getRawFiles();
        if (rawFiles != null) {
            rawFiles.remove(rawFile);
        }
    }

    public TransientData getTransientData() {
        if (this.transientData == null) {
            this.transientData = new TransientData();
        }
        return this.transientData;
    }

    public static class TransientData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int childrenNumber = 0;

        protected TransientData() {
        }

        public int getChildrenNumber() {
            return this.childrenNumber;
        }

        public void setChildrenNumber(int childrenNumber) {
            this.childrenNumber = childrenNumber;
        }
    }
}

