/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.uds.InstrumentConfiguration;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class UdsInstrumentConfigurationRepository {
    private UdsInstrumentConfigurationRepository() {
    }

    public static InstrumentConfiguration findInstrumConfForNameAndMs1AndMsn(EntityManager udsEm, String name, String ms1Analyzer, String msnAnalyzer) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        if (StringUtils.isEmpty((String)ms1Analyzer)) {
            throw new IllegalArgumentException("Invalid ms1Analyzer");
        }
        InstrumentConfiguration result = null;
        TypedQuery query = null;
        if (msnAnalyzer == null) {
            query = udsEm.createNamedQuery("findUdsInstrumConfForNameAndMs1", InstrumentConfiguration.class);
        } else {
            query = udsEm.createNamedQuery("findUdsInstrumConfForNameAndMs1AndMsn", InstrumentConfiguration.class);
            query.setParameter("msnAnalyzer", (Object)msnAnalyzer.toUpperCase());
        }
        query.setParameter("name", (Object)name.toUpperCase());
        query.setParameter("ms1Analyzer", (Object)ms1Analyzer.toUpperCase());
        List instrumConfs = query.getResultList();
        if (instrumConfs != null && !instrumConfs.isEmpty()) {
            if (instrumConfs.size() == 1) {
                result = (InstrumentConfiguration)instrumConfs.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one InstrumentConfiguration for given name, ms1Analyzer and msnAnalyzer");
            }
        }
        return result;
    }
}

