/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.util;

import fr.profi.util.ThreadLogger;
import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.repository.ExternalDbRepository;
import fr.proline.core.orm.util.AbstractDSConnectorFactory;
import fr.proline.repository.ConnectionMode;
import fr.proline.repository.DatabaseConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.persistence.EntityManager;

public class DataStoreConnectorFactory
extends AbstractDSConnectorFactory {
    private static final DataStoreConnectorFactory UNIQUE_INSTANCE = new DataStoreConnectorFactory();
    private String m_applicationName;

    protected DataStoreConnectorFactory() {
    }

    public static DataStoreConnectorFactory getInstance() {
        return UNIQUE_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(IDatabaseConnector udsDbConnector, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("DataStoreConnectorFactory ALREADY initialized");
            }
            if (udsDbConnector == null) {
                throw new IllegalArgumentException("udsDbConnector is null");
            }
            Thread currentThread = Thread.currentThread();
            if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
                currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
            }
            this.m_udsDbConnector = udsDbConnector;
            this.m_applicationName = applicationName;
            EntityManager udsEm = null;
            try {
                udsEm = udsDbConnector.createEntityManager();
            }
            catch (Exception ex) {
                String message = "Error initializing DataStoreConnectorFactory";
                LOG.error("Error initializing DataStoreConnectorFactory", (Throwable)ex);
                this.closeAll();
                throw new RuntimeException("Error initializing DataStoreConnectorFactory", ex);
            }
            finally {
                if (udsEm != null) {
                    try {
                        udsEm.close();
                    }
                    catch (Exception exClose) {
                        LOG.error("Error closing UDS Db EntityManager", (Throwable)exClose);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(IDatabaseConnector udsDbConnector, String applicationName, boolean useManagedConnection) {
        if (!useManagedConnection) {
            this.initialize(udsDbConnector, applicationName);
            return;
        }
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("DataStoreConnectorFactory ALREADY initialized");
            }
            if (udsDbConnector == null) {
                throw new IllegalArgumentException("udsDbConnector is null");
            }
            Thread currentThread = Thread.currentThread();
            if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
                currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
            }
            this.m_udsDbConnector = udsDbConnector;
            this.m_applicationName = applicationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IDatabaseConnector createProjectDatabaseConnector(long projectId, ProlineDatabaseType prolineDbType, Map<Long, Map<Object, Object>> propertiesMaps) {
        IDatabaseConnector dbConnector = null;
        Object object = this.m_managerLock;
        synchronized (object) {
            this.checkInitialization();
            Long key = projectId;
            Map<Object, Object> propertiesMap = propertiesMaps.get(key);
            if (propertiesMap == null) {
                propertiesMap = this.retrieveExternalDbProperties(prolineDbType, projectId);
                propertiesMaps.put(key, propertiesMap);
            }
            dbConnector = DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)prolineDbType, propertiesMap);
        }
        return dbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Object, Object> retrieveExternalDbProperties(ProlineDatabaseType prolineDbType, long projectId) {
        Map<Object, Object> propertiesMap = null;
        IDatabaseConnector udsDbConnector = this.getUdsDbConnector();
        EntityManager udsEm = udsDbConnector.createEntityManager();
        try {
            Project project = (Project)udsEm.find(Project.class, (Object)projectId);
            if (project == null) {
                throw new IllegalArgumentException("Project #" + projectId + " NOT found in UDS Db");
            }
            ExternalDb externalDb = ExternalDbRepository.findExternalByTypeAndProject(udsEm, prolineDbType, project);
            if (externalDb == null) {
                LOG.warn("No ExternalDb for {} Db of project #{}", (Object)prolineDbType, (Object)projectId);
            } else {
                propertiesMap = externalDb.toPropertiesMap(udsDbConnector.getDriverType(), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.user"), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.password"));
                propertiesMap.put("ApplicationName", this.m_applicationName);
            }
        }
        finally {
            try {
                udsEm.close();
            }
            catch (Exception exClose) {
                LOG.error("Error closing UDS Db EntityManager", (Throwable)exClose);
            }
        }
        return propertiesMap;
    }

    protected ExternalDb loadExternalDbByType(Connection connection, ProlineDatabaseType dbType) throws SQLException {
        return this.loadExternalDb(connection, "SELECT * FROM external_db WHERE type = '" + dbType.toString() + "'", dbType);
    }

    protected ExternalDb loadExternalDbByTypeAndProjectId(Connection connection, ProlineDatabaseType dbType, long projectId) throws SQLException {
        String sqlQuery = "SELECT external_db.* FROM external_db, project_db_map WHERE project_db_map.external_db_id = external_db.id AND external_db.type = '" + dbType.toString() + "' AND project_db_map.project_id = " + projectId;
        return this.loadExternalDb(connection, sqlQuery, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalDb loadExternalDb(Connection connection, String sqlQuery, ProlineDatabaseType dbType) throws SQLException {
        ExternalDb udsExtDb = new ExternalDb();
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery(sqlQuery);
            if (rs.next()) {
                udsExtDb.setId(rs.getLong("id"));
                udsExtDb.setDbName(rs.getString("name"));
                udsExtDb.setConnectionMode(ConnectionMode.valueOf((String)rs.getString("connection_mode")));
                udsExtDb.setHost(rs.getString("host"));
                udsExtDb.setPort(rs.getInt("port"));
                udsExtDb.setType(dbType);
                udsExtDb.setDbVersion(rs.getString("version"));
                udsExtDb.setIsBusy(false);
                udsExtDb.setSerializedProperties(rs.getString("serialized_properties"));
            }
            rs.close();
        }
        return udsExtDb;
    }
}

