/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestClientException;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSInputable;
import uk.ac.ebi.pride.toolsuite.ols.dialog.message.ThrowableHandler;
import uk.ac.ebi.pride.toolsuite.ols.dialog.model.MassSearchModel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.renders.SearchTableCellRender;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl.GetMetadataTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl.GetOntologiesTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl.GetOntologyRootsTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl.GetPTMModificationsTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl.TermSearchTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.NotificationPanel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.StatusBar;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.TaskManager;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.TaskMonitorPanel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.BareBonesBrowserLaunch;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.HelpDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.MyComboBoxRenderer;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.SimpleNewtSelection;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.TreeBrowser;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.Util;
import uk.ac.ebi.pride.utilities.ols.web.service.client.OLSClient;
import uk.ac.ebi.pride.utilities.ols.web.service.config.AbstractOLSWsConfig;
import uk.ac.ebi.pride.utilities.ols.web.service.config.OLSWsConfigProd;
import uk.ac.ebi.pride.utilities.ols.web.service.model.ITerm;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Identifier;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Ontology;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;

public class OLSDialog
extends JDialog {
    public static final boolean debug = false;
    public static final String SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY = "-- Search in All Ontologies available in the OLS registry --";
    public static final String SEARCH_IN_THESE_PRESELECTED_ONTOLOGIES = "-- Search in these preselected Ontologies --";
    public static Logger logger = LoggerFactory.getLogger(OLSDialog.class);
    private String field;
    private String selectedOntology;
    private int modifiedRow = -1;
    private OLSInputable olsInputable;
    private String mappedTerm;
    private Map<String, List<Identifier>> preselectedOntologies;
    private boolean onlyListPreselectedOntologies = false;
    private Map<String, Identifier> preselectedNames2Ids;
    private int keyPressedCounter = 0;
    private int waitingTime = 1000;
    private final int MINIMUM_WORD_LENGTH = 3;
    public static String DEFAULT_OLS_CONNECTION_ERROR = "An error occured when trying to contact the OLS. Make sure that\nyou are online. Also check your firewall (and proxy) settings.\n\nSee the Troubleshooting section at the OLS Dialog home page\nfor reporting issues use GitHub: https://github.com/PRIDE-Toolsuite/ols-dialog/issues";
    public static final Integer OLS_DIALOG_TERM_NAME_SEARCH = 0;
    public static final Integer OLS_DIALOG_TERM_ID_SEARCH = 1;
    public static final Integer OLS_DIALOG_PSI_MOD_MASS_SEARCH = 2;
    public static final Integer OLS_DIALOG_BROWSE_ONTOLOGY = 3;
    private static OLSClient olsConnection = new OLSClient((AbstractOLSWsConfig)new OLSWsConfigProd());
    public TreeBrowser treeBrowser;
    public ITerm currentlySelectedBrowseOntologyAccessionNumber = null;
    public ITerm currentlySelectedTermNameSearchAccessionNumber = null;
    public ITerm currentlySelectedTermIdSearchAccessionNumber = null;
    public ITerm currentlySelectedMassSearchAccessionNumber = null;
    private String lastSelectedOntology = null;
    private final int MAX_TOOL_TIP_LENGTH = 40;
    private List<String> metadata;
    private String selectedRowHtmlTagFontColor = "#FFFFFF";
    private String notSelectedRowHtmlTagFontColor = "#0101DF";
    private MassSearchModel massSearchModel;
    private TaskManager taskManager = new TaskManager();
    private final ThrowableHandler throwableHandler = new ThrowableHandler();
    private JButton aboutJButton;
    private JPanel backgroundPanel;
    private JPanel browseJPanel;
    private JPanel browseOntologyJPanel;
    private JButton cancelJButton;
    private JTextPane definitionBrowseOntologyJTextPane;
    private JTextPane definitionMassSearchJTextPane;
    private JScrollPane definitionSelectedTermMassSearchScrollPane;
    private JTextPane definitionTermIdSearchJTextPane;
    private JScrollPane definitionTermNameIdSearchScrollPane;
    private JScrollPane definitionTermNameScrollPane;
    private JTextPane definitionTermNameSearchJTextPane;
    private JLabel dummyLabelJLabel;
    private JButton helpJButton;
    public JButton insertSelectedJButton;
    private JLabel massLabel;
    private JPanel massPanel;
    private JPanel massSearchJPanel;
    private JComboBox massTypeJComboBox;
    private JTextField modificationMassJTextField;
    private JButton modificationMassSearchJButton;
    private JButton termSearchJButoon;
    private JLabel newtSpeciesTipsTermIdSearchJLabel;
    private JLabel newtSpeciesTipsTermNameSearchJLabel;
    public JTextField numberOfTermsTermNameSearchJTextField;
    private JScrollPane olsResultsMassSearchJScrollPane;
    private JTable olsResultsMassSearchJTable;
    private JScrollPane olsResultsTermIdSearchJScrollPane;
    private JTable olsResultsTermIdSearchJTable;
    private JScrollPane olsResultsTermNameSearchJScrollPane;
    public JTable olsResultsTermNameSearchJTable;
    private JComboBox ontologyJComboBox;
    private JLabel ontologyJLabel;
    private JLabel plussMinusLabel;
    private JTextField precisionJTextField;
    private JPanel searchParametersJPanel;
    private JLabel searchResultsMassSearchLabel;
    private JLabel searchResultsTermIdLabel;
    private JLabel searchResultsTermNameJLabel;
    private JLabel searchTermMassSearchLabel;
    private JLabel searchTermTermIdLabel;
    private JTabbedPane searchTypeJTabbedPane;
    private JLabel selectedTermBrowseLabel;
    private JLabel selectedTermTermNameJLabel;
    private JScrollPane termDetailsBrowseOntologyJScrollPane;
    private JTable termDetailsBrowseOntologyJTable;
    private JScrollPane termDetailsMassSearchJScrollPane;
    private JTable termDetailsMassSearchJTable;
    private JScrollPane termDetailsTermIdSearchJScrollPane;
    private JTable termDetailsTermIdSearchJTable;
    private JScrollPane termDetailsTermNameSearchJScrollPane;
    private JTable termDetailsTermNameSearchJTable;
    private JLabel termIdLabel;
    private JPanel termIdPanel;
    private JButton termIdSearchJButton;
    private JPanel termIdSearchJPanel;
    private JTextField termIdSearchJTextField;
    private JLabel termNameJLabel;
    private JPanel termNameJPanel;
    private JPanel termNameSearchJPanel;
    public JTextField termNameSearchJTextField;
    private JScrollPane treeScrollPane;
    private JLabel typeLabel;
    private JLabel viewTermHierarchyBrowseOntologyJLabel;
    private JLabel viewTermHierarchyMassSearchJLabel;
    private JLabel viewTermHierarchyTermIdSearchJLabel;
    private JLabel viewTermHierarchyTermNameSearchJLabel;
    private StatusBar statusBar;
    public JTextPane currentDefinitionsJTextPane;
    public JTable currentTermDetailsJTable;
    public JScrollPane currentTermDetailsJScrollPane;

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term, boolean allowChangeUI) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null, false, allowChangeUI);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, term, true);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term, Map<String, List<Identifier>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term, Map<String, List<Identifier>> preselectedOntologies, boolean onlyListPreselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies, onlyListPreselectedOntologies);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, term, true);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term, boolean allowChangeUI) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null, allowChangeUI);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term, Map<String, List<Identifier>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Map<String, List<Identifier>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Map<String, List<Identifier>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType, Map<String, List<Identifier>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, modificationMass, modificationAccuracy, searchType, preselectedOntologies, false, true);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType, Map<String, List<Identifier>> preselectedOntologies, boolean onlyListPreselectedOntologies, boolean allowChangeUI) {
        super((Frame)parent, modal);
        this.olsInputable = olsInputable;
        this.onlyListPreselectedOntologies = onlyListPreselectedOntologies;
        this.field = field;
        this.selectedOntology = selectedOntology;
        this.modifiedRow = modifiedRow;
        this.mappedTerm = term;
        this.preselectedOntologies = preselectedOntologies == null ? new HashMap() : preselectedOntologies;
        this.setUpFrame(searchType);
        GetOntologiesTask ontologyTask = new GetOntologiesTask(this, olsConnection);
        this.taskManager.addTask(ontologyTask);
        this.insertValues(modificationMass, modificationAccuracy, searchType);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType, Map<String, List<Identifier>> preselectedOntologies, boolean onlyListPreselectedOntologies) {
        super((Frame)parent, modal);
        this.onlyListPreselectedOntologies = onlyListPreselectedOntologies;
        this.olsInputable = olsInputable;
        this.field = field;
        this.selectedOntology = selectedOntology;
        this.modifiedRow = modifiedRow;
        this.mappedTerm = term;
        this.preselectedOntologies = preselectedOntologies == null ? new HashMap() : preselectedOntologies;
        this.setUpFrame(searchType);
        GetOntologiesTask ontologyTask = new GetOntologiesTask(this, olsConnection);
        this.taskManager.addTask(ontologyTask);
        this.insertValues(modificationMass, modificationAccuracy, searchType);
        this.setLocationRelativeTo(parent);
        if (this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY) || this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_THESE_PRESELECTED_ONTOLOGIES)) {
            this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_BROWSE_ONTOLOGY, false);
            this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_TERM_ID_SEARCH, false);
        } else {
            this.termIdSearchJTextField.setText(this.getCurrentOntologyLabel() + ":");
        }
        if (!this.getCurrentOntologyLabel().equalsIgnoreCase("MOD")) {
            this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_PSI_MOD_MASS_SEARCH, false);
        } else {
            this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_PSI_MOD_MASS_SEARCH, true);
        }
        this.setVisible(true);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, modificationMass, modificationAccuracy, searchType, null);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType, Map<String, List<Identifier>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, modificationMass, modificationAccuracy, searchType, preselectedOntologies, true);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType, Map<String, List<Identifier>> preselectedOntologies, boolean allowUIChange) {
        super((Dialog)parent, modal);
        this.olsInputable = olsInputable;
        this.field = field;
        this.selectedOntology = selectedOntology;
        this.modifiedRow = modifiedRow;
        this.mappedTerm = term;
        this.preselectedOntologies = preselectedOntologies == null ? new HashMap<String, List<Identifier>>() : preselectedOntologies;
        this.setUpFrame(searchType, allowUIChange);
        GetOntologiesTask ontologyTask = new GetOntologiesTask(this, olsConnection);
        this.taskManager.addTask(ontologyTask);
        this.insertValues(modificationMass, modificationAccuracy, searchType);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, modificationMass, modificationAccuracy, searchType, null);
    }

    private void insertValues(Double modificationMass, Double modificationAccuracy, Integer searchType) {
        if (this.mappedTerm != null) {
            this.termNameSearchJTextField.setText(this.mappedTerm);
            this.termNameSearchJTextFieldKeyReleased(null);
        }
        if (modificationAccuracy != null) {
            this.precisionJTextField.setText(modificationAccuracy.toString());
        }
        if (modificationMass != null) {
            this.modificationMassJTextField.setText(modificationMass.toString());
            this.modificationMassSearchJButtonActionPerformed(null);
        }
        this.updateBrowseOntologyView();
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.termNameSearchJTextField.requestFocus();
        } else if (searchType != OLS_DIALOG_BROWSE_ONTOLOGY && searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.modificationMassJTextField.requestFocus();
        }
    }

    private void setUpFrame(Integer searchType) {
        this.setUpFrame(searchType, true);
    }

    private void setUpFrame(Integer searchType, boolean allowChangeUI) {
        if (allowChangeUI) {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                    UIDefaults defaults = lookAndFeel.getDefaults();
                    defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Failed to load nimbus look and feel for the application", (Throwable)e);
            }
        }
        this.initComponents();
        this.olsResultsTermNameSearchJTable.setDefaultRenderer(ITerm.class, new SearchTableCellRender());
        this.olsResultsTermIdSearchJTable.setDefaultRenderer(Term.class, new SearchTableCellRender());
        this.olsResultsMassSearchJTable.setDefaultRenderer(Term.class, new SearchTableCellRender());
        this.olsResultsTermNameSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsTermNameSearchJScrollPane.getViewport().setOpaque(false);
        this.olsResultsTermIdSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsTermIdSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsMassSearchJScrollPane.getViewport().setOpaque(false);
        this.olsResultsMassSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsBrowseOntologyJScrollPane.getViewport().setOpaque(false);
        this.setTitle("Ontology Lookup Service - (ols-dialog v" + this.getVersion() + ")");
        this.dummyLabelJLabel.setForeground(this.massSearchJPanel.getBackground());
        this.treeBrowser = new TreeBrowser(this);
        this.browseJPanel.add(this.treeBrowser);
        this.searchTypeJTabbedPane.setSelectedIndex(searchType);
        this.ontologyJComboBox.setRenderer(new MyComboBoxRenderer(null, 0));
        this.massTypeJComboBox.setRenderer(new MyComboBoxRenderer(null, 0));
        this.olsResultsTermNameSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.olsResultsMassSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.olsResultsTermIdSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsTermNameSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsMassSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsBrowseOntologyJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsTermIdSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.olsResultsTermNameSearchJTable.setSelectionMode(0);
        this.olsResultsMassSearchJTable.setSelectionMode(0);
        this.olsResultsTermIdSearchJTable.setSelectionMode(0);
    }

    private void mouseClickedBrowserReleased(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void mouseClickedBrowserExited(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void mouseClickedBrowser(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    public String getVersion() {
        Properties p = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("ols-dialog.properties");
            p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p.getProperty("ols-dialog.version");
    }

    public List<Term> getOntologyRoots(String ontology, Identifier parentTerm) {
        ArrayList<Term> retrievedValues = new ArrayList<Term>();
        try {
            List<Object> roots = parentTerm == null ? olsConnection.getRootTerms(ontology) : olsConnection.getTermChildren(parentTerm, ontology, 1);
            if (roots != null) {
                roots = Util.refineOntologyNullIds(roots);
                retrievedValues.addAll(roots);
            }
        }
        catch (RestClientException e) {
            JOptionPane.showMessageDialog(this, DEFAULT_OLS_CONNECTION_ERROR, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            e.printStackTrace();
        }
        return retrievedValues;
    }

    public void clearData(Integer searchType, boolean clearSearchResults, boolean clearMetaData) {
        JTextPane currentDefinitionsJTextPane = null;
        JTable currentTermDetailsJTable = null;
        JScrollPane currentTermDetailsJScrollPane = null;
        JTable currentSearchResultsJTable = null;
        JScrollPane currentSearchResultsJScrollPane = null;
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.currentlySelectedTermNameSearchAccessionNumber = null;
            currentSearchResultsJTable = this.olsResultsTermNameSearchJTable;
            currentSearchResultsJScrollPane = this.olsResultsTermNameSearchJScrollPane;
            currentDefinitionsJTextPane = this.definitionTermNameSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsTermNameSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsTermNameSearchJScrollPane;
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.currentlySelectedMassSearchAccessionNumber = null;
            currentSearchResultsJTable = this.olsResultsMassSearchJTable;
            currentSearchResultsJScrollPane = this.olsResultsMassSearchJScrollPane;
            currentDefinitionsJTextPane = this.definitionMassSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsMassSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsMassSearchJScrollPane;
            this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.currentlySelectedBrowseOntologyAccessionNumber = null;
            currentDefinitionsJTextPane = this.definitionBrowseOntologyJTextPane;
            currentTermDetailsJTable = this.termDetailsBrowseOntologyJTable;
            currentTermDetailsJScrollPane = this.termDetailsBrowseOntologyJScrollPane;
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.currentlySelectedTermIdSearchAccessionNumber = null;
            currentSearchResultsJTable = this.olsResultsTermIdSearchJTable;
            currentSearchResultsJScrollPane = this.olsResultsTermIdSearchJScrollPane;
            currentDefinitionsJTextPane = this.definitionTermIdSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsTermIdSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsTermIdSearchJScrollPane;
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
        }
        if (clearMetaData) {
            if (currentDefinitionsJTextPane != null) {
                currentDefinitionsJTextPane.setText("");
            }
            while (currentTermDetailsJTable.getRowCount() > 0) {
                ((DefaultTableModel)currentTermDetailsJTable.getModel()).removeRow(0);
            }
            if (currentTermDetailsJScrollPane != null) {
                currentTermDetailsJScrollPane.getVerticalScrollBar().setValue(0);
            }
        }
        if (clearSearchResults && searchType != OLS_DIALOG_BROWSE_ONTOLOGY) {
            while (currentSearchResultsJTable.getRowCount() > 0) {
                ((DefaultTableModel)currentSearchResultsJTable.getModel()).removeRow(0);
            }
            if (currentSearchResultsJScrollPane != null) {
                currentSearchResultsJScrollPane.getVerticalScrollBar().setValue(0);
            }
        }
    }

    public boolean loadChildren(TreeNode parent, ITerm termId) {
        if (termId == null) {
            return false;
        }
        boolean error = false;
        String ontology = this.getCurrentOntologyLabel();
        List childTerms = null;
        try {
            childTerms = olsConnection.getTermChildren(termId.getOboId(), ontology, 1);
        }
        catch (RestClientException ex) {
            JOptionPane.showMessageDialog(this, DEFAULT_OLS_CONNECTION_ERROR, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
            error = true;
        }
        if (!error && childTerms != null && !childTerms.isEmpty()) {
            for (Term tId : childTerms) {
                this.treeBrowser.addNode((ITerm)tId);
            }
            return true;
        }
        return false;
    }

    private String getOntologyLabelFromTermId(ITerm term) {
        String ontologyLabel = term != null && term.getOntologyName() != null ? term.getOntologyName() : (term == null ? null : "NEWT");
        return ontologyLabel;
    }

    public void loadMetaData(ITerm term, Integer searchType) {
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.currentDefinitionsJTextPane = this.definitionTermNameSearchJTextPane;
            this.currentTermDetailsJTable = this.termDetailsTermNameSearchJTable;
            this.currentTermDetailsJScrollPane = this.termDetailsTermNameSearchJScrollPane;
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.currentDefinitionsJTextPane = this.definitionMassSearchJTextPane;
            this.currentTermDetailsJTable = this.termDetailsMassSearchJTable;
            this.currentTermDetailsJScrollPane = this.termDetailsMassSearchJScrollPane;
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.currentDefinitionsJTextPane = this.definitionBrowseOntologyJTextPane;
            this.currentTermDetailsJTable = this.termDetailsBrowseOntologyJTable;
            this.currentTermDetailsJScrollPane = this.termDetailsBrowseOntologyJScrollPane;
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.currentDefinitionsJTextPane = this.definitionTermIdSearchJTextPane;
            this.currentTermDetailsJTable = this.termDetailsTermIdSearchJTable;
            this.currentTermDetailsJScrollPane = this.termDetailsTermIdSearchJScrollPane;
        }
        this.clearData(searchType, false, true);
        if (term == null) {
            return;
        }
        String ontology = this.getOntologyLabelFromTermId(term);
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.currentlySelectedTermNameSearchAccessionNumber = term;
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(true);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.currentlySelectedMassSearchAccessionNumber = term;
            this.viewTermHierarchyMassSearchJLabel.setEnabled(true);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.currentlySelectedBrowseOntologyAccessionNumber = term;
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(true);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.currentlySelectedTermIdSearchAccessionNumber = term;
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(true);
        }
        boolean error = false;
        if (ontology != null && ontology.equalsIgnoreCase("NEWT")) {
            this.currentDefinitionsJTextPane.setText("Retrieving 'Term Details' is disabled for NEWT.");
            this.currentDefinitionsJTextPane.setCaretPosition(0);
            this.currentTermDetailsJTable.setEnabled(false);
            error = true;
        } else {
            this.currentTermDetailsJTable.setEnabled(true);
        }
        if (!error) {
            GetMetadataTask metadataTask = new GetMetadataTask(this, olsConnection, term, ontology, searchType);
            this.taskManager.addTask(metadataTask);
        } else if (!error && term.getName() != null) {
            String descriptionText = "";
            this.currentDefinitionsJTextPane.setText("Definition: " + term.getName());
            this.currentDefinitionsJTextPane.setCaretPosition(0);
        } else if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
        }
        this.currentTermDetailsJScrollPane.getVerticalScrollBar().setValue(0);
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermNameSearchAccessionNumber != null);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedMassSearchAccessionNumber != null);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedBrowseOntologyAccessionNumber != null);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermIdSearchAccessionNumber != null);
        }
    }

    private void setTableToolTip(JTable table, Object value, int row, int column) {
        if (table != null) {
            if (table.getValueAt(row, column) != null) {
                if (column == 1 && table.getValueAt(row, column).toString().length() > 40) {
                    table.setToolTipText(this.buildToolTipText("" + value.toString(), 40));
                } else {
                    table.setToolTipText(null);
                }
            } else {
                table.setToolTipText(null);
            }
        }
    }

    private String buildToolTipText(String aToolTip, int maxToolTipLength) {
        StringBuilder currentToolTip = new StringBuilder("<html>");
        int indexOfLastSpace = 0;
        StringBuilder currentToolTipLine = new StringBuilder();
        int currentStartIndex = 0;
        for (int i = 0; i < aToolTip.length(); ++i) {
            currentToolTipLine.append(aToolTip.substring(i, i + 1));
            if (aToolTip.substring(i, i + 1).equalsIgnoreCase(" ")) {
                indexOfLastSpace = i;
            }
            if (currentToolTipLine.length() <= maxToolTipLength) continue;
            if (indexOfLastSpace == currentStartIndex) {
                currentToolTip.append(aToolTip.substring(currentStartIndex, i + 1)).append("-<br>");
                currentStartIndex = i + 1;
                indexOfLastSpace = i + 1;
                currentToolTipLine = new StringBuilder();
                continue;
            }
            currentToolTip.append(aToolTip.substring(currentStartIndex, indexOfLastSpace)).append("<br>");
            currentStartIndex = indexOfLastSpace;
            currentToolTipLine = new StringBuilder();
            i = currentStartIndex;
        }
        if (currentToolTipLine.length() > 0) {
            currentToolTip.append(aToolTip.substring(currentStartIndex));
        }
        currentToolTip.append("</html>");
        return currentToolTip.toString();
    }

    public void hideOrShowNewtLinks() {
        if (this.getCurrentOntologyLabel().equalsIgnoreCase("NEWT")) {
            this.newtSpeciesTipsTermNameSearchJLabel.setForeground(Color.BLUE);
            this.newtSpeciesTipsTermIdSearchJLabel.setForeground(Color.BLUE);
            this.newtSpeciesTipsTermNameSearchJLabel.setText("NEWT Species Tips");
            this.newtSpeciesTipsTermIdSearchJLabel.setText("NEWT Species Tips");
        } else {
            this.newtSpeciesTipsTermNameSearchJLabel.setText(" ");
            this.newtSpeciesTipsTermIdSearchJLabel.setText(" ");
        }
    }

    private void updateBrowseOntologyView() {
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
            this.setCursor(new Cursor(3));
            String ontology = this.getCurrentOntologyLabel();
            String parentTermName = this.getCurrentOntologyTermLabel();
            Identifier parentTermId = this.preselectedNames2Ids.get(parentTermName);
            if (parentTermName != null && parentTermId != null) {
                this.treeBrowser.initialize("[" + parentTermId + "] " + parentTermName);
            } else {
                this.treeBrowser.initialize(ontology);
            }
            GetOntologyRootsTask ontologyRootsTask = new GetOntologyRootsTask(this, olsConnection, ontology, parentTermId);
            this.taskManager.addTask(ontologyRootsTask);
        }
    }

    public boolean addSecondLevelOfNodes(ITerm termId, String ontology, DefaultMutableTreeNode parentNode) {
        boolean error = false;
        try {
            List secondLevelChildTerms = new ArrayList();
            if (termId != null && termId.getGlobalId() != null && !termId.getGlobalId().getIdentifier().equalsIgnoreCase("No Root Terms Defined!") && ((Term)termId).isHasChildren()) {
                secondLevelChildTerms = olsConnection.getTermChildren(termId.getGlobalId(), ontology, 1);
            }
            for (Term tId2 : secondLevelChildTerms) {
                this.treeBrowser.addNode(parentNode, (ITerm)tId2, false);
            }
        }
        catch (RestClientException ex) {
            JOptionPane.showMessageDialog(this, DEFAULT_OLS_CONNECTION_ERROR, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
            error = true;
        }
        return error;
    }

    public String getCurrentOntologyLabel() {
        String ontology = (String)this.ontologyJComboBox.getSelectedItem();
        if (ontology != null && ontology.lastIndexOf("[") != -1) {
            ontology = ontology.substring(ontology.lastIndexOf("[") + 1, ontology.length());
        }
        if (ontology != null && ontology.lastIndexOf("]") != -1) {
            ontology = ontology.substring(0, ontology.lastIndexOf("]"));
        }
        if (ontology == null) {
            ontology = SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY;
        }
        return ontology;
    }

    public String getCurrentOntologyTermLabel() {
        String ontologyTerm = (String)this.ontologyJComboBox.getSelectedItem();
        ontologyTerm = ontologyTerm.lastIndexOf("/ ") != -1 ? ontologyTerm.substring(ontologyTerm.lastIndexOf("/ ") + 2, ontologyTerm.length()) : null;
        return ontologyTerm;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.insertSelectedJButton = new JButton();
        this.cancelJButton = new JButton();
        this.helpJButton = new JButton();
        this.aboutJButton = new JButton();
        this.searchParametersJPanel = new JPanel();
        this.searchTypeJTabbedPane = new JTabbedPane();
        this.termNameSearchJPanel = new JPanel();
        this.definitionTermNameScrollPane = new JScrollPane();
        this.definitionTermNameSearchJTextPane = new JTextPane();
        this.termDetailsTermNameSearchJScrollPane = new JScrollPane();
        this.termDetailsTermNameSearchJTable = new JTable();
        this.termDetailsTermNameSearchJTable.setAutoCreateRowSorter(true);
        this.termDetailsTermNameSearchJTable.setDefaultRenderer(Object.class, new SearchTableCellRender());
        this.searchResultsTermNameJLabel = new JLabel();
        this.selectedTermTermNameJLabel = new JLabel();
        this.olsResultsTermNameSearchJScrollPane = new JScrollPane();
        this.olsResultsTermNameSearchJTable = new JTable();
        this.olsResultsTermNameSearchJTable.setAutoCreateRowSorter(true);
        this.olsResultsTermNameSearchJTable.setDefaultRenderer(Object.class, new SearchTableCellRender());
        this.viewTermHierarchyTermNameSearchJLabel = new JLabel();
        this.termNameJPanel = new JPanel();
        this.termNameJLabel = new JLabel();
        this.termNameSearchJTextField = new JTextField();
        this.newtSpeciesTipsTermNameSearchJLabel = new JLabel();
        this.numberOfTermsTermNameSearchJTextField = new JTextField();
        this.termIdSearchJPanel = new JPanel();
        this.definitionTermNameIdSearchScrollPane = new JScrollPane();
        this.definitionTermIdSearchJTextPane = new JTextPane();
        this.termDetailsTermIdSearchJScrollPane = new JScrollPane();
        this.termDetailsTermIdSearchJTable = new JTable();
        this.termDetailsTermIdSearchJTable.setAutoCreateRowSorter(true);
        this.termDetailsTermIdSearchJTable.setDefaultRenderer(Object.class, new SearchTableCellRender());
        this.searchResultsTermIdLabel = new JLabel();
        this.searchTermTermIdLabel = new JLabel();
        this.olsResultsTermIdSearchJScrollPane = new JScrollPane();
        this.olsResultsTermIdSearchJTable = new JTable();
        this.olsResultsTermIdSearchJTable.setAutoCreateRowSorter(true);
        this.olsResultsTermIdSearchJTable.setDefaultRenderer(Object.class, new SearchTableCellRender());
        this.viewTermHierarchyTermIdSearchJLabel = new JLabel();
        this.termIdPanel = new JPanel();
        this.termIdLabel = new JLabel();
        this.termIdSearchJTextField = new JTextField();
        this.newtSpeciesTipsTermIdSearchJLabel = new JLabel();
        this.termIdSearchJButton = new JButton();
        this.massSearchJPanel = new JPanel();
        this.searchResultsMassSearchLabel = new JLabel();
        this.searchTermMassSearchLabel = new JLabel();
        this.definitionSelectedTermMassSearchScrollPane = new JScrollPane();
        this.definitionMassSearchJTextPane = new JTextPane();
        this.termDetailsMassSearchJScrollPane = new JScrollPane();
        this.termDetailsMassSearchJScrollPane.getViewport().setBackground(Color.WHITE);
        this.termDetailsMassSearchJTable = new JTable();
        this.termDetailsMassSearchJTable.setAutoCreateRowSorter(true);
        this.termDetailsMassSearchJTable.setDefaultRenderer(Object.class, new SearchTableCellRender());
        this.olsResultsMassSearchJScrollPane = new JScrollPane();
        this.olsResultsMassSearchJTable = new JTable();
        this.olsResultsMassSearchJTable.setAutoCreateRowSorter(true);
        this.viewTermHierarchyMassSearchJLabel = new JLabel();
        this.massPanel = new JPanel();
        this.massLabel = new JLabel();
        this.modificationMassJTextField = new JTextField();
        this.plussMinusLabel = new JLabel();
        this.precisionJTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.massTypeJComboBox = new JComboBox();
        this.dummyLabelJLabel = new JLabel();
        this.modificationMassSearchJButton = new JButton();
        this.browseOntologyJPanel = new JPanel();
        this.selectedTermBrowseLabel = new JLabel();
        this.treeScrollPane = new JScrollPane();
        this.definitionBrowseOntologyJTextPane = new JTextPane();
        this.termDetailsBrowseOntologyJScrollPane = new JScrollPane();
        this.termDetailsBrowseOntologyJTable = new JTable();
        this.browseJPanel = new JPanel();
        this.viewTermHierarchyBrowseOntologyJLabel = new JLabel();
        this.ontologyJLabel = new JLabel();
        this.ontologyJComboBox = new JComboBox();
        this.termSearchJButoon = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(" Ontology Lookup Service - (ols-dialog v3.0)");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OLSDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.insertSelectedJButton.setText("Use Selected Term");
        this.insertSelectedJButton.setEnabled(false);
        this.insertSelectedJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.insertSelectedJButtonActionPerformed(evt);
            }
        });
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.setMaximumSize(new Dimension(121, 23));
        this.cancelJButton.setMinimumSize(new Dimension(121, 23));
        this.cancelJButton.setPreferredSize(new Dimension(121, 23));
        this.cancelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.cancelJButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.aboutJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ols_transparent_small.GIF")));
        this.aboutJButton.setToolTipText("About");
        this.aboutJButton.setBorderPainted(false);
        this.aboutJButton.setContentAreaFilled(false);
        this.aboutJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.aboutJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.aboutJButtonMouseExited(evt);
            }
        });
        this.aboutJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.aboutJButtonActionPerformed(evt);
            }
        });
        this.searchParametersJPanel.setBorder(BorderFactory.createTitledBorder("Search Parameters"));
        this.searchParametersJPanel.setOpaque(false);
        this.searchTypeJTabbedPane.setBackground(new Color(230, 230, 230));
        this.searchTypeJTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OLSDialog.this.searchTypeJTabbedPaneStateChanged(evt);
            }
        });
        this.termNameSearchJPanel.setBackground(new Color(230, 230, 230));
        this.definitionTermNameSearchJTextPane.setEditable(false);
        this.definitionTermNameScrollPane.setViewportView(this.definitionTermNameSearchJTextPane);
        this.termDetailsTermNameSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsTermNameSearchJTable.setOpaque(false);
        this.termDetailsTermNameSearchJScrollPane.setViewportView(this.termDetailsTermNameSearchJTable);
        this.searchResultsTermNameJLabel.setText("Search Results");
        this.selectedTermTermNameJLabel.setText("Selected Term");
        this.olsResultsTermNameSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Accession", "CV Term"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{ITerm.class, ITerm.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.olsResultsTermNameSearchJTable.setOpaque(false);
        this.olsResultsTermNameSearchJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseReleased(evt);
            }
        });
        this.olsResultsTermNameSearchJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseMoved(evt);
            }
        });
        this.olsResultsTermNameSearchJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableKeyReleased(evt);
            }
        });
        this.olsResultsTermNameSearchJScrollPane.setViewportView(this.olsResultsTermNameSearchJTable);
        this.viewTermHierarchyTermNameSearchJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyTermNameSearchJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
        this.viewTermHierarchyTermNameSearchJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermNameSearchJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermNameSearchJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermNameSearchJLabelMouseExited(evt);
            }
        });
        this.termNameJPanel.setOpaque(false);
        this.termNameJLabel.setText("Term Name");
        this.termNameSearchJTextField.setHorizontalAlignment(0);
        this.newtSpeciesTipsTermNameSearchJLabel.setFont(this.newtSpeciesTipsTermNameSearchJLabel.getFont().deriveFont((float)this.newtSpeciesTipsTermNameSearchJLabel.getFont().getSize() - 1.0f));
        this.newtSpeciesTipsTermNameSearchJLabel.setForeground(new Color(0, 0, 255));
        this.newtSpeciesTipsTermNameSearchJLabel.setText("NEWT Species Tips");
        this.newtSpeciesTipsTermNameSearchJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermNameSearchJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermNameSearchJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermNameSearchJLabelMouseExited(evt);
            }
        });
        this.numberOfTermsTermNameSearchJTextField.setEditable(false);
        this.numberOfTermsTermNameSearchJTextField.setHorizontalAlignment(0);
        this.numberOfTermsTermNameSearchJTextField.setToolTipText("Number of Matching Terms");
        TaskMonitorPanel taskMonitorPane = new TaskMonitorPanel(this);
        NotificationPanel notificationPane = new NotificationPanel(this);
        this.statusBar = new StatusBar(taskMonitorPane);
        this.termSearchJButoon.setText("Search");
        GroupLayout termNameJPanelLayout = new GroupLayout((Container)this.termNameJPanel);
        this.termNameJPanel.setLayout((LayoutManager)termNameJPanelLayout);
        termNameJPanelLayout.setHorizontalGroup((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termNameJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(2).add((Component)this.newtSpeciesTipsTermNameSearchJLabel).add(1, (GroupLayout.Group)termNameJPanelLayout.createSequentialGroup().add((Component)this.termNameJLabel, -2, 70, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.termNameSearchJTextField, -2, 500, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.numberOfTermsTermNameSearchJTextField, -2, 79, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.termSearchJButoon, -2, 80, -2))).addPreferredGap(1).addContainerGap()));
        termNameJPanelLayout.setVerticalGroup((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termNameJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(4).add((Component)this.termNameJLabel).add((Component)this.numberOfTermsTermNameSearchJTextField, -2, 20, -2).add((Component)this.termNameSearchJTextField, -2, -1, -2).add((Component)this.termSearchJButoon)).addPreferredGap(0).add((Component)this.newtSpeciesTipsTermNameSearchJLabel)));
        termNameJPanelLayout.linkSize(new Component[]{this.numberOfTermsTermNameSearchJTextField, this.termNameSearchJTextField, this.termSearchJButoon}, 2);
        GroupLayout termNameSearchJPanelLayout = new GroupLayout((Container)this.termNameSearchJPanel);
        this.termNameSearchJPanel.setLayout((LayoutManager)termNameSearchJPanelLayout);
        termNameSearchJPanelLayout.setHorizontalGroup((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(1).add(2, (Component)this.termNameJPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().add((Component)this.searchResultsTermNameJLabel).add(0, 0, Short.MAX_VALUE)).add(2, (Component)this.olsResultsTermNameSearchJScrollPane).add((Component)this.termDetailsTermNameSearchJScrollPane).add((GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().add((Component)this.selectedTermTermNameJLabel).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.viewTermHierarchyTermNameSearchJLabel)).add(2, (Component)this.definitionTermNameScrollPane, -1, 580, Short.MAX_VALUE)).addContainerGap()));
        termNameSearchJPanelLayout.setVerticalGroup((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.termNameJPanel, -2, -1, -2).add(1, 1, 1).add((Component)this.searchResultsTermNameJLabel).addPreferredGap(0).add((Component)this.olsResultsTermNameSearchJScrollPane, -1, 138, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(3).add((Component)this.selectedTermTermNameJLabel).add((Component)this.viewTermHierarchyTermNameSearchJLabel)).addPreferredGap(0).add((Component)this.definitionTermNameScrollPane, -1, 85, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsTermNameSearchJScrollPane, -1, 92, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("Term Name Search", this.termNameSearchJPanel);
        this.termIdSearchJPanel.setBackground(new Color(230, 230, 230));
        this.definitionTermIdSearchJTextPane.setEditable(false);
        this.definitionTermNameIdSearchScrollPane.setViewportView(this.definitionTermIdSearchJTextPane);
        this.termDetailsTermIdSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsTermIdSearchJTable.setOpaque(false);
        this.termDetailsTermIdSearchJScrollPane.setViewportView(this.termDetailsTermIdSearchJTable);
        this.searchResultsTermIdLabel.setText("Search Results");
        this.searchTermTermIdLabel.setText("Selected Term");
        this.olsResultsTermIdSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Accession", "CV Term"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Term.class, Term.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.olsResultsTermIdSearchJTable.setOpaque(false);
        this.olsResultsTermIdSearchJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseReleased(evt);
            }
        });
        this.olsResultsTermIdSearchJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseMoved(evt);
            }
        });
        this.olsResultsTermIdSearchJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableKeyReleased(evt);
            }
        });
        this.olsResultsTermIdSearchJScrollPane.setViewportView(this.olsResultsTermIdSearchJTable);
        this.viewTermHierarchyTermIdSearchJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyTermIdSearchJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
        this.viewTermHierarchyTermIdSearchJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermIdSearchJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermIdSearchJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermIdSearchJLabelMouseExited(evt);
            }
        });
        this.termIdPanel.setOpaque(false);
        this.termIdPanel.setPreferredSize(new Dimension(600, 50));
        this.termIdLabel.setText("Term ID");
        this.termIdLabel.setPreferredSize(new Dimension(58, 14));
        this.termIdSearchJTextField.setHorizontalAlignment(0);
        this.termIdSearchJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OLSDialog.this.termIdSearchJTextFieldKeyPressed(evt);
            }
        });
        this.newtSpeciesTipsTermIdSearchJLabel.setFont(this.newtSpeciesTipsTermIdSearchJLabel.getFont().deriveFont((float)this.newtSpeciesTipsTermIdSearchJLabel.getFont().getSize() - 1.0f));
        this.newtSpeciesTipsTermIdSearchJLabel.setForeground(new Color(0, 0, 255));
        this.newtSpeciesTipsTermIdSearchJLabel.setText("NEWT Species Tips");
        this.newtSpeciesTipsTermIdSearchJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermIdSearchJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermIdSearchJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermIdSearchJLabelMouseExited(evt);
            }
        });
        this.termIdSearchJButton.setText("Search");
        this.termIdSearchJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.termIdSearchJButtonActionPerformed(evt);
            }
        });
        GroupLayout termIdPanelLayout = new GroupLayout((Container)this.termIdPanel);
        this.termIdPanel.setLayout((LayoutManager)termIdPanelLayout);
        termIdPanelLayout.setHorizontalGroup((GroupLayout.Group)termIdPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)termIdPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termIdPanelLayout.createParallelGroup(2).add((GroupLayout.Group)termIdPanelLayout.createSequentialGroup().add((Component)this.dummyLabelJLabel).add(200, 200, 200)).add((GroupLayout.Group)termIdPanelLayout.createSequentialGroup().add((Component)this.termIdLabel, -2, 70, -2).addPreferredGap(1).add((Component)this.termIdSearchJTextField).addPreferredGap(0).add((Component)this.typeLabel).add(18, 18, 18).addPreferredGap(0))).add((Component)this.termIdSearchJButton, -2, 80, -2).addContainerGap()));
        termIdPanelLayout.setVerticalGroup((GroupLayout.Group)termIdPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)termIdPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)termIdPanelLayout.createParallelGroup(3).add((Component)this.termIdSearchJButton).add((Component)this.typeLabel).add((Component)this.termIdLabel).add((Component)this.termIdSearchJTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.dummyLabelJLabel)));
        GroupLayout termIdSearchJPanelLayout = new GroupLayout((Container)this.termIdSearchJPanel);
        this.termIdSearchJPanel.setLayout((LayoutManager)termIdSearchJPanelLayout);
        termIdSearchJPanelLayout.setHorizontalGroup((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(1).add(2, (Component)this.termIdPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().add((Component)this.searchResultsTermIdLabel).add(0, 509, Short.MAX_VALUE)).add(2, (Component)this.olsResultsTermIdSearchJScrollPane, -1, 580, Short.MAX_VALUE).add((Component)this.termDetailsTermIdSearchJScrollPane, -1, 580, Short.MAX_VALUE).add((Component)this.definitionTermNameIdSearchScrollPane, -1, 580, Short.MAX_VALUE).add((GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().add((Component)this.searchTermTermIdLabel).addPreferredGap(0, 414, Short.MAX_VALUE).add((Component)this.viewTermHierarchyTermIdSearchJLabel))).addContainerGap()));
        termIdSearchJPanelLayout.setVerticalGroup((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.termIdPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.searchResultsTermIdLabel).addPreferredGap(0).add((Component)this.olsResultsTermIdSearchJScrollPane, -1, 136, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(3).add((Component)this.searchTermTermIdLabel).add((Component)this.viewTermHierarchyTermIdSearchJLabel)).addPreferredGap(0).add((Component)this.definitionTermNameIdSearchScrollPane, -1, 84, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsTermIdSearchJScrollPane, -1, 90, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("Term ID Search", this.termIdSearchJPanel);
        this.massSearchJPanel.setBackground(new Color(230, 230, 230));
        this.searchResultsMassSearchLabel.setText("Search Results");
        this.searchTermMassSearchLabel.setText("Selected Term");
        this.definitionMassSearchJTextPane.setEditable(false);
        this.definitionSelectedTermMassSearchScrollPane.setViewportView(this.definitionMassSearchJTextPane);
        this.termDetailsMassSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsMassSearchJTable.setOpaque(false);
        this.termDetailsMassSearchJScrollPane.setViewportView(this.termDetailsMassSearchJTable);
        this.massSearchModel = new MassSearchModel();
        this.olsResultsMassSearchJTable.setModel(this.massSearchModel);
        this.olsResultsMassSearchJTable.setOpaque(false);
        this.olsResultsMassSearchJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseReleased(evt);
            }
        });
        this.olsResultsMassSearchJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseMoved(evt);
            }
        });
        this.olsResultsMassSearchJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableKeyReleased(evt);
            }
        });
        this.olsResultsMassSearchJScrollPane.setViewportView(this.olsResultsMassSearchJTable);
        this.viewTermHierarchyMassSearchJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyMassSearchJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        this.viewTermHierarchyMassSearchJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyMassSearchJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyMassSearchJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyMassSearchJLabelMouseExited(evt);
            }
        });
        this.massPanel.setOpaque(false);
        this.massPanel.setPreferredSize(new Dimension(444, 50));
        this.massLabel.setText("Mass");
        this.modificationMassJTextField.setHorizontalAlignment(0);
        this.modificationMassJTextField.setText("0.0");
        this.modificationMassJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OLSDialog.this.modificationMassJTextFieldKeyPressed(evt);
            }
        });
        this.plussMinusLabel.setText("+-");
        this.plussMinusLabel.setToolTipText("Mass Accuracy");
        this.precisionJTextField.setHorizontalAlignment(0);
        this.precisionJTextField.setText("0.1");
        this.precisionJTextField.setToolTipText("Mass Accuracy");
        this.precisionJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OLSDialog.this.precisionJTextFieldKeyPressed(evt);
            }
        });
        this.typeLabel.setText("Type");
        this.massTypeJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"- Select -", "DiffAvg", "DiffMono", "MassAvg", "MassMono"}));
        this.massTypeJComboBox.setSelectedIndex(2);
        this.massTypeJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.massTypeJComboBoxActionPerformed(evt);
            }
        });
        this.dummyLabelJLabel.setFont(this.dummyLabelJLabel.getFont().deriveFont((float)this.dummyLabelJLabel.getFont().getSize() - 1.0f));
        this.dummyLabelJLabel.setText(" ");
        this.modificationMassSearchJButton.setText("Search");
        this.modificationMassSearchJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.modificationMassSearchJButtonActionPerformed(evt);
            }
        });
        this.termSearchJButoon.setText("Search");
        this.termSearchJButoon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.termNameSearchJTextFieldKeyReleased(evt);
            }
        });
        GroupLayout massPanelLayout = new GroupLayout((Container)this.massPanel);
        this.massPanel.setLayout((LayoutManager)massPanelLayout);
        massPanelLayout.setHorizontalGroup((GroupLayout.Group)massPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)massPanelLayout.createParallelGroup(2).add((GroupLayout.Group)massPanelLayout.createSequentialGroup().add((Component)this.dummyLabelJLabel).add(200, 200, 200)).add((GroupLayout.Group)massPanelLayout.createSequentialGroup().add((Component)this.massLabel, -2, 70, -2).addPreferredGap(1).add((Component)this.modificationMassJTextField).addPreferredGap(0).add((Component)this.plussMinusLabel).addPreferredGap(0).add((Component)this.precisionJTextField, -2, 81, -2).add(18, 18, 18).add((Component)this.typeLabel).add(18, 18, 18).add((Component)this.massTypeJComboBox, -2, -1, -2).addPreferredGap(0))).add((Component)this.modificationMassSearchJButton, -2, 80, -2).addContainerGap()));
        massPanelLayout.setVerticalGroup((GroupLayout.Group)massPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)massPanelLayout.createParallelGroup(3).add((Component)this.modificationMassSearchJButton).add((Component)this.massTypeJComboBox, -2, -1, -2).add((Component)this.typeLabel).add((Component)this.precisionJTextField, -2, -1, -2).add((Component)this.plussMinusLabel).add((Component)this.massLabel).add((Component)this.modificationMassJTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.dummyLabelJLabel)));
        GroupLayout massSearchJPanelLayout = new GroupLayout((Container)this.massSearchJPanel);
        this.massSearchJPanel.setLayout((LayoutManager)massSearchJPanelLayout);
        massSearchJPanelLayout.setHorizontalGroup((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massSearchJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add(2, (Component)this.termDetailsMassSearchJScrollPane).add(2, (Component)this.definitionSelectedTermMassSearchScrollPane).add(2, (Component)this.olsResultsMassSearchJScrollPane).add((GroupLayout.Group)massSearchJPanelLayout.createSequentialGroup().add((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add((Component)this.searchResultsMassSearchLabel).add((Component)this.searchTermMassSearchLabel)).addPreferredGap(0, 411, Short.MAX_VALUE).add((Component)this.viewTermHierarchyMassSearchJLabel))).addContainerGap()).add((Component)this.massPanel, -1, 600, Short.MAX_VALUE));
        massSearchJPanelLayout.setVerticalGroup((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massSearchJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.massPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.searchResultsMassSearchLabel).addPreferredGap(0).add((Component)this.olsResultsMassSearchJScrollPane, -1, 136, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(3).add((Component)this.searchTermMassSearchLabel).add((Component)this.viewTermHierarchyMassSearchJLabel)).addPreferredGap(0).add((Component)this.definitionSelectedTermMassSearchScrollPane, -1, 84, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsMassSearchJScrollPane, -1, 90, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("PSI-MOD Mass Search", this.massSearchJPanel);
        this.browseOntologyJPanel.setBackground(new Color(230, 230, 230));
        this.selectedTermBrowseLabel.setText("Selected Term");
        this.definitionBrowseOntologyJTextPane.setEditable(false);
        this.treeScrollPane.setViewportView(this.definitionBrowseOntologyJTextPane);
        this.termDetailsBrowseOntologyJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsBrowseOntologyJTable.setOpaque(false);
        this.termDetailsBrowseOntologyJScrollPane.setViewportView(this.termDetailsBrowseOntologyJTable);
        this.browseJPanel.setOpaque(false);
        this.browseJPanel.setLayout(new BoxLayout(this.browseJPanel, 2));
        this.viewTermHierarchyBrowseOntologyJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyBrowseOntologyJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        this.viewTermHierarchyBrowseOntologyJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyBrowseOntologyJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierachyJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierachyJLabelMouseExited(evt);
            }
        });
        GroupLayout browseOntologyJPanelLayout = new GroupLayout((Container)this.browseOntologyJPanel);
        this.browseOntologyJPanel.setLayout((LayoutManager)browseOntologyJPanelLayout);
        browseOntologyJPanelLayout.setHorizontalGroup((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)browseOntologyJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(2).add(1, (Component)this.browseJPanel, -1, 580, Short.MAX_VALUE).add(1, (GroupLayout.Group)browseOntologyJPanelLayout.createSequentialGroup().add((Component)this.selectedTermBrowseLabel).addPreferredGap(0, 414, Short.MAX_VALUE).add((Component)this.viewTermHierarchyBrowseOntologyJLabel)).add((Component)this.treeScrollPane, -1, 580, Short.MAX_VALUE).add((Component)this.termDetailsBrowseOntologyJScrollPane, -1, 580, Short.MAX_VALUE)).addContainerGap()));
        browseOntologyJPanelLayout.setVerticalGroup((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)browseOntologyJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.browseJPanel, -1, 213, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(3).add((Component)this.selectedTermBrowseLabel).add((Component)this.viewTermHierarchyBrowseOntologyJLabel)).addPreferredGap(0).add((Component)this.treeScrollPane, -1, 84, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsBrowseOntologyJScrollPane, -1, 89, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("Browse Ontology", this.browseOntologyJPanel);
        this.ontologyJLabel.setText("Ontology");
        this.ontologyJComboBox.setMaximumRowCount(30);
        this.ontologyJComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OLSDialog.this.ontologyJComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout searchParametersJPanelLayout = new GroupLayout((Container)this.searchParametersJPanel);
        this.searchParametersJPanel.setLayout((LayoutManager)searchParametersJPanelLayout);
        searchParametersJPanelLayout.setHorizontalGroup((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchParametersJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(1).add((Component)this.searchTypeJTabbedPane).add((GroupLayout.Group)searchParametersJPanelLayout.createSequentialGroup().add((Component)this.ontologyJLabel).add(18, 18, 18).add((Component)this.ontologyJComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        searchParametersJPanelLayout.setVerticalGroup((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchParametersJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(4).add((Component)this.ontologyJLabel).add((Component)this.ontologyJComboBox, -2, -1, -2)).add(32, 32, 32).add((Component)this.searchTypeJTabbedPane).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout((Container)this.backgroundPanel);
        this.backgroundPanel.setLayout((LayoutManager)backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(2).add((Component)this.searchParametersJPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.helpJButton, -2, 23, -2).addPreferredGap(0).add((Component)this.aboutJButton, -2, 25, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.statusBar, -2, 360, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.insertSelectedJButton).addPreferredGap(0).add((Component)this.cancelJButton, -2, -1, -2))).addContainerGap()));
        backgroundPanelLayout.linkSize(new Component[]{this.cancelJButton, this.insertSelectedJButton}, 1);
        backgroundPanelLayout.setVerticalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.searchParametersJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().add(1, 1, 1).add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(3).add((Component)this.cancelJButton, -2, -1, -2).add((Component)this.insertSelectedJButton))).add((Component)this.aboutJButton, -2, 24, -2).add((Component)this.helpJButton, -2, 24, -2).add((Component)this.statusBar, -2, 20, -2)).addContainerGap()));
        backgroundPanelLayout.linkSize(new Component[]{this.cancelJButton, this.insertSelectedJButton}, 2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -2, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -2, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void ontologyJComboBoxItemStateChanged(ItemEvent evt) {
        String currentOntology;
        this.setCursor(new Cursor(3));
        if (!this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY) && !this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_THESE_PRESELECTED_ONTOLOGIES)) {
            this.termIdSearchJTextField.setText(this.getCurrentOntologyLabel() + ":");
        } else {
            this.termIdSearchJTextField.setText("");
        }
        if (this.searchTypeJTabbedPane.getSelectedIndex() != OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue() && !(currentOntology = (String)this.ontologyJComboBox.getSelectedItem()).equalsIgnoreCase(this.lastSelectedOntology)) {
            this.lastSelectedOntology = (String)this.ontologyJComboBox.getSelectedItem();
            this.currentlySelectedBrowseOntologyAccessionNumber = null;
            this.currentlySelectedTermNameSearchAccessionNumber = null;
            this.currentlySelectedTermIdSearchAccessionNumber = null;
            this.insertSelectedJButton.setEnabled(false);
            if (this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY) || this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_THESE_PRESELECTED_ONTOLOGIES)) {
                this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_BROWSE_ONTOLOGY, false);
                if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
                    this.searchTypeJTabbedPane.setSelectedIndex(OLS_DIALOG_TERM_NAME_SEARCH);
                    this.setCursor(new Cursor(0));
                    JOptionPane.showMessageDialog(this, "Browse Ontology is not available when searching several ontologies.", "Browse Ontology Disabled", 1);
                    this.setCursor(new Cursor(3));
                }
                this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_TERM_ID_SEARCH, false);
                if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
                    this.searchTypeJTabbedPane.setSelectedIndex(OLS_DIALOG_TERM_NAME_SEARCH);
                    this.setCursor(new Cursor(0));
                    JOptionPane.showMessageDialog(this, "Term ID Search is not available when searching several ontologies.", "Term ID Search Disabled", 1);
                    this.setCursor(new Cursor(3));
                }
            } else {
                this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_BROWSE_ONTOLOGY, true);
                if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
                    this.updateBrowseOntologyView();
                }
                this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_TERM_ID_SEARCH, true);
            }
            if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
                this.termNameSearchJTextField.requestFocus();
            } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
                this.termIdSearchJTextField.requestFocus();
            }
            this.hideOrShowNewtLinks();
            this.clearData(OLS_DIALOG_TERM_ID_SEARCH, true, true);
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        }
        if (!this.getCurrentOntologyLabel().equalsIgnoreCase("MOD")) {
            this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_PSI_MOD_MASS_SEARCH, false);
            if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
                this.searchTypeJTabbedPane.setSelectedIndex(OLS_DIALOG_TERM_NAME_SEARCH);
                this.setCursor(new Cursor(0));
                JOptionPane.showMessageDialog(this, "Modification mass search is not available when the MOD ontology has not been selected.", "Modification Mass Search Disabled", 1);
                this.setCursor(new Cursor(3));
            }
        } else {
            this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_PSI_MOD_MASS_SEARCH, true);
        }
        this.setCursor(new Cursor(0));
    }

    private void termNameSearchJTextFieldKeyReleased(ActionEvent evt) {
        ++this.keyPressedCounter;
        if (this.keyPressedCounter == 1) {
            this.setCursor(new Cursor(3));
            this.termNameSearchJTextField.setCursor(new Cursor(3));
            this.insertSelectedJButton.setEnabled(false);
            this.currentlySelectedTermNameSearchAccessionNumber = null;
            try {
                this.clearData(OLS_DIALOG_TERM_NAME_SEARCH, true, true);
                if (this.termNameSearchJTextField.getText().length() >= 3) {
                    String ontology;
                    String string = ontology = this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY) || this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_THESE_PRESELECTED_ONTOLOGIES) ? null : this.getCurrentOntologyLabel();
                    if (this.isPreselectedOption()) {
                        TermSearchTask termSearch = new TermSearchTask(this, olsConnection, "*" + this.termNameSearchJTextField.getText() + "*", false, this.preselectedOntologies);
                        this.taskManager.addTask(termSearch);
                    } else if (this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY)) {
                        TermSearchTask termSearch = new TermSearchTask(this, olsConnection, "*" + this.termNameSearchJTextField.getText() + "*", false);
                        this.taskManager.addTask(termSearch);
                    } else {
                        TermSearchTask termSearch = new TermSearchTask(this, olsConnection, "*" + this.termNameSearchJTextField.getText() + "*", false, ontology);
                        this.taskManager.addTask(termSearch);
                    }
                } else {
                    this.numberOfTermsTermNameSearchJTextField.setText("-");
                }
            }
            catch (RestClientException ex) {
                JOptionPane.showMessageDialog(null, DEFAULT_OLS_CONNECTION_ERROR, "OLS Connection Error", 0);
                Util.writeToErrorLog("Error when trying to access OLS: ");
                ex.printStackTrace();
            }
            this.setCursor(new Cursor(0));
            this.termNameSearchJTextField.setCursor(new Cursor(2));
            this.keyPressedCounter = 0;
        } else {
            --this.keyPressedCounter;
        }
    }

    private void insertSelectedJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        ITerm termId = null;
        ITerm ontologyName = null;
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            termId = (ITerm)this.olsResultsTermNameSearchJTable.getValueAt(this.olsResultsTermNameSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
            ontologyName = this.currentlySelectedBrowseOntologyAccessionNumber;
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
            termId = (Term)this.olsResultsMassSearchJTable.getValueAt(this.olsResultsMassSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            termId = (Term)this.olsResultsTermIdSearchJTable.getValueAt(this.olsResultsTermIdSearchJTable.getSelectedRow(), 0);
        }
        if (termId != null) {
            Term selectedValue = olsConnection.getTermById(termId.getGlobalId(), termId.getOntologyName());
            Ontology ontologyComplete = olsConnection.getOntology(termId.getOntologyName());
            String ontologyLong = ontologyComplete.getName() + "[" + ontologyComplete.getId() + "]";
            if (this.olsInputable != null) {
                this.olsInputable.insertOLSResult(this.field, selectedValue, selectedValue, ontologyComplete.getId(), ontologyLong, this.modifiedRow, this.mappedTerm, this.metadata);
                this.setVisible(false);
                this.dispose();
            }
        } else if (ontologyName != null && ontologyName.getGlobalId() != null) {
            Term selectedValue = olsConnection.getTermById(ontologyName.getGlobalId(), ontologyName.getOntologyName());
            Ontology ontologyComplete = olsConnection.getOntology(ontologyName.getOntologyName());
            String ontologyLong = ontologyComplete.getName() + "[" + ontologyComplete.getId() + "]";
            if (this.olsInputable != null) {
                this.olsInputable.insertOLSResult(this.field, selectedValue, selectedValue, ontologyComplete.getId(), ontologyLong, this.modifiedRow, this.mappedTerm, this.metadata);
                this.setVisible(false);
                this.dispose();
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void insertTermDetails(MouseEvent evt, JTable searchResultTable) {
        this.setCursor(new Cursor(3));
        int row = searchResultTable.getSelectedRow();
        if (row != -1) {
            this.insertSelectedJButton.setEnabled(true);
        } else {
            this.insertSelectedJButton.setEnabled(false);
        }
        boolean doSearch = true;
        if (evt != null && evt.getClickCount() == 2 && evt.getButton() == 1) {
            this.insertSelectedJButtonActionPerformed(null);
            doSearch = false;
        }
        if (doSearch && row != -1) {
            Integer searchType = null;
            if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
                this.currentlySelectedTermNameSearchAccessionNumber = (ITerm)searchResultTable.getValueAt(row, 0);
                searchType = OLS_DIALOG_TERM_NAME_SEARCH;
            } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
                this.currentlySelectedMassSearchAccessionNumber = (ITerm)searchResultTable.getValueAt(row, 0);
                searchType = OLS_DIALOG_PSI_MOD_MASS_SEARCH;
            } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
                this.currentlySelectedTermIdSearchAccessionNumber = (ITerm)searchResultTable.getValueAt(row, 0);
                searchType = OLS_DIALOG_TERM_ID_SEARCH;
            }
            ITerm termID = (ITerm)searchResultTable.getValueAt(row, 0);
            this.loadMetaData(termID, searchType);
        }
        this.setCursor(new Cursor(0));
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        if (this.olsInputable != null) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, true, this.getClass().getResource("/helpfiles/OLSDialog.html"));
        this.setCursor(new Cursor(0));
    }

    private void aboutJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, true, this.getClass().getResource("/helpfiles/AboutOLS.html"));
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelJButtonActionPerformed(null);
    }

    private void modificationMassSearchJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        this.insertSelectedJButton.setEnabled(false);
        this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        this.clearData(OLS_DIALOG_PSI_MOD_MASS_SEARCH, true, true);
        boolean error = false;
        double currentModificationMass = 0.0;
        double currentAccuracy = 0.1;
        try {
            currentModificationMass = new Double(this.modificationMassJTextField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "The mass is not a number!", "Modification Mass", 1);
            this.modificationMassJTextField.requestFocus();
            error = true;
        }
        if (!error) {
            try {
                currentAccuracy = new Double(this.precisionJTextField.getText());
                if (currentAccuracy < 0.0) {
                    JOptionPane.showMessageDialog(null, "The precision has to be a positive value.", "Mass Accuracy", 1);
                    this.precisionJTextField.requestFocus();
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "The precision is not a number!", "Mass Accuracy", 1);
                this.precisionJTextField.requestFocus();
                error = true;
            }
        }
        if (!error) {
            String massType = this.massTypeJComboBox.getSelectedItem().toString();
            GetPTMModificationsTask ptmSearchTask = new GetPTMModificationsTask(null, olsConnection, this.massSearchModel, massType, currentModificationMass - currentAccuracy, currentModificationMass + currentAccuracy);
            this.taskManager.addTask(ptmSearchTask);
            this.setCursor(new Cursor(0));
            if (this.olsResultsMassSearchJTable.getRowCount() > 0) {
                this.olsResultsMassSearchJTable.scrollRectToVisible(this.olsResultsTermNameSearchJTable.getCellRect(0, 0, false));
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void massTypeJComboBoxActionPerformed(ActionEvent evt) {
        this.modificationMassSearchJButton.setEnabled(this.massTypeJComboBox.getSelectedIndex() != 0);
    }

    private void searchTypeJTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedMassSearchAccessionNumber != null);
            this.lastSelectedOntology = (String)this.ontologyJComboBox.getSelectedItem();
            this.ontologyJComboBox.setSelectedItem("Protein Modifications (PSI-MOD) [MOD]");
            this.ontologyJComboBox.setEnabled(false);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedBrowseOntologyAccessionNumber != null);
            this.ontologyJComboBox.setSelectedItem(this.lastSelectedOntology);
            this.ontologyJComboBox.setEnabled(true);
            this.updateBrowseOntologyView();
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermNameSearchAccessionNumber != null);
            this.ontologyJComboBox.setSelectedItem(this.lastSelectedOntology);
            this.ontologyJComboBox.setEnabled(true);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermIdSearchAccessionNumber != null);
            this.ontologyJComboBox.setSelectedItem(this.lastSelectedOntology);
            this.ontologyJComboBox.setEnabled(true);
        }
    }

    private void olsResultsTermNameSearchJTableKeyReleased(KeyEvent evt) {
        this.olsResultsTermNameSearchJTableMouseClicked(null);
    }

    private void olsResultsTermNameSearchJTableMouseClicked(MouseEvent evt) {
        this.insertTermDetails(evt, this.olsResultsTermNameSearchJTable);
    }

    private void olsResultsMassSearchJTableKeyReleased(KeyEvent evt) {
        this.olsResultsMassSearchJTableMouseClicked(null);
    }

    private void olsResultsMassSearchJTableMouseClicked(MouseEvent evt) {
        this.insertTermDetails(evt, this.olsResultsMassSearchJTable);
    }

    private void viewTermHierachyJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierachyJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void viewTermHierarchyBrowseOntologyJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyMassSearchJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyMassSearchJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierarchyMassSearchJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void viewTermHierarchyTermNameSearchJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyTermNameSearchJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierarchyTermNameSearchJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermIdSearchJTableMouseClicked(MouseEvent evt) {
        this.insertTermDetails(evt, this.olsResultsTermIdSearchJTable);
    }

    private void olsResultsTermIdSearchJTableKeyReleased(KeyEvent evt) {
        this.olsResultsTermIdSearchJTableMouseClicked(null);
    }

    private void viewTermHierarchyTermIdSearchJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyTermIdSearchJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierarchyTermIdSearchJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void termIdSearchJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        this.termIdSearchJTextField.setCursor(new Cursor(3));
        this.insertSelectedJButton.setEnabled(false);
        this.currentlySelectedTermIdSearchAccessionNumber = null;
        try {
            Term currentTermName;
            this.clearData(OLS_DIALOG_TERM_ID_SEARCH, true, true);
            String ontology = ((String)this.ontologyJComboBox.getSelectedItem()).contains("[") ? this.getCurrentOntologyLabel() : "";
            Term term = currentTermName = !StringUtils.isEmpty((CharSequence)ontology) ? olsConnection.getTermById(new Identifier(this.termIdSearchJTextField.getText().trim(), Identifier.IdentifierType.OBO), ontology) : null;
            if (currentTermName == null || currentTermName == null) {
                JOptionPane.showMessageDialog(this, "No matching terms found.", "No Matching Terms", 1);
                this.termIdSearchJTextField.requestFocus();
            } else {
                ((DefaultTableModel)this.olsResultsTermIdSearchJTable.getModel()).addRow(new Object[]{currentTermName, currentTermName});
                Integer width = this.getPreferredColumnWidth(this.olsResultsTermIdSearchJTable, this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex(), 6);
                if (width != null) {
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMinWidth(width);
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMaxWidth(width);
                } else {
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMinWidth(15);
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
                }
            }
            this.setCursor(new Cursor(0));
            this.termIdSearchJTextField.setCursor(new Cursor(2));
            if (this.olsResultsTermIdSearchJTable.getRowCount() > 0) {
                this.olsResultsTermIdSearchJTable.scrollRectToVisible(this.olsResultsTermIdSearchJTable.getCellRect(0, 0, false));
            }
        }
        catch (RestClientException ex) {
            JOptionPane.showMessageDialog(this, DEFAULT_OLS_CONNECTION_ERROR, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
        }
        this.setCursor(new Cursor(0));
        this.termIdSearchJTextField.setCursor(new Cursor(2));
    }

    private void modificationMassJTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.modificationMassSearchJButton.isEnabled()) {
            this.modificationMassSearchJButtonActionPerformed(null);
        }
    }

    private void precisionJTextFieldKeyPressed(KeyEvent evt) {
        this.modificationMassJTextFieldKeyPressed(evt);
    }

    private void termIdSearchJTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.termIdSearchJButton.isEnabled()) {
                this.termIdSearchJButtonActionPerformed(null);
            }
        } else {
            this.termIdSearchJButton.setEnabled(this.termIdSearchJTextField.getText().length() > 0);
        }
    }

    private void newtSpeciesTipsTermNameSearchJLabelMouseClicked(MouseEvent evt) {
        if (this.newtSpeciesTipsTermNameSearchJLabel.getForeground() == Color.BLUE) {
            new SimpleNewtSelection(this, true);
        }
    }

    private void newtSpeciesTipsTermNameSearchJLabelMouseEntered(MouseEvent evt) {
        if (this.newtSpeciesTipsTermNameSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(12));
        }
    }

    private void newtSpeciesTipsTermNameSearchJLabelMouseExited(MouseEvent evt) {
        if (this.newtSpeciesTipsTermNameSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(0));
        }
    }

    private void newtSpeciesTipsTermIdSearchJLabelMouseClicked(MouseEvent evt) {
        if (this.newtSpeciesTipsTermIdSearchJLabel.getForeground() == Color.BLUE) {
            new SimpleNewtSelection(this, true);
        }
    }

    private void newtSpeciesTipsTermIdSearchJLabelMouseEntered(MouseEvent evt) {
        if (this.newtSpeciesTipsTermIdSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(12));
        }
    }

    private void newtSpeciesTipsTermIdSearchJLabelMouseExited(MouseEvent evt) {
        if (this.newtSpeciesTipsTermIdSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(0));
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void aboutJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void aboutJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermNameSearchJTableMouseMoved(MouseEvent evt) {
        int row = this.olsResultsTermNameSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermNameSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex() && this.olsResultsTermNameSearchJTable.getValueAt(row, column) != null) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void olsResultsTermIdSearchJTableMouseMoved(MouseEvent evt) {
        int row = this.olsResultsTermIdSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermIdSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex() && this.olsResultsTermIdSearchJTable.getValueAt(row, column) != null) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void olsResultsMassSearchJTableMouseMoved(MouseEvent evt) {
        int row = this.olsResultsMassSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsMassSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.olsResultsMassSearchJTable.getColumn("Accession").getModelIndex() && this.olsResultsMassSearchJTable.getValueAt(row, column) != null) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void olsResultsTermNameSearchJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermIdSearchJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsMassSearchJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermNameSearchJTableMouseReleased(MouseEvent evt) {
        int row = this.olsResultsTermNameSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermNameSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex() && column == this.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex() && evt.getButton() == 1) {
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(Util.getOlsTermLink((ITerm)this.olsResultsTermNameSearchJTable.getValueAt(row, column)));
            this.setCursor(new Cursor(0));
        }
    }

    private void olsResultsTermIdSearchJTableMouseReleased(MouseEvent evt) {
        int row = this.olsResultsTermIdSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermIdSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex() && column == this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex() && evt.getButton() == 1 && ((Term)this.olsResultsTermIdSearchJTable.getValueAt(row, column)).getIri() != null) {
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(Util.getOlsTermLink((ITerm)((Term)this.olsResultsTermIdSearchJTable.getValueAt(row, column))));
            this.setCursor(new Cursor(0));
        }
    }

    private void olsResultsMassSearchJTableMouseReleased(MouseEvent evt) {
        int row = this.olsResultsMassSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsMassSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.olsResultsMassSearchJTable.getColumn("Accession").getModelIndex() && column == this.olsResultsMassSearchJTable.getColumn("Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.olsResultsMassSearchJTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
            String link = (String)this.olsResultsMassSearchJTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void viewTermHierarchy() {
        this.setCursor(new Cursor(3));
        ITerm accession = null;
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            accession = (ITerm)this.olsResultsTermNameSearchJTable.getValueAt(this.olsResultsTermNameSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
            accession = this.currentlySelectedBrowseOntologyAccessionNumber;
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
            accession = (ITerm)this.olsResultsMassSearchJTable.getValueAt(this.olsResultsMassSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            accession = (ITerm)this.olsResultsTermIdSearchJTable.getValueAt(this.olsResultsTermIdSearchJTable.getSelectedRow(), 0);
        }
        if (accession != null) {
            BareBonesBrowserLaunch.openURL(Util.getOlsTermLink(accession));
        }
        if (!this.insertSelectedJButton.isEnabled() && accession.getIri() != null) {
            this.insertSelectedJButton.setEnabled(true);
        }
        this.setCursor(new Cursor(0));
    }

    public boolean isPreselectedOption() {
        return this.preselectedOntologies.size() > 1 && this.getCurrentOntologyLabel().equalsIgnoreCase(SEARCH_IN_THESE_PRESELECTED_ONTOLOGIES);
    }

    public void insertNewtSelection(String termName, String termId) {
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            this.termNameSearchJTextField.setText(termName);
            this.termNameSearchJTextFieldKeyReleased(null);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            this.termIdSearchJTextField.setText(termId);
            this.termIdSearchJButtonActionPerformed(null);
        }
    }

    public int getPreferredColumnWidth(JTable table, int colIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, colIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, colIndex), false, false, r, colIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        return width += 2 * margin;
    }

    public void loadMetaOntologyData(String ontologyName, Integer olsDialogBrowseOntology) {
        if (!SEARCH_IN_ALL_ONTOLOGIES_AVAILABLE_IN_THE_OLS_REGISTRY.equals(ontologyName)) {
            Ontology ontology = olsConnection.getOntology(ontologyName);
            JTextPane currentDefinitionsJTextPane = null;
            JTable currentTermDetailsJTable = null;
            if (olsDialogBrowseOntology == OLS_DIALOG_BROWSE_ONTOLOGY) {
                currentDefinitionsJTextPane = this.definitionBrowseOntologyJTextPane;
                currentTermDetailsJTable = this.termDetailsBrowseOntologyJTable;
            }
            try {
                if (ontology != null && ontology.getDescription() != null) {
                    currentDefinitionsJTextPane.setText("Definition: " + ontology.getDescription());
                    currentDefinitionsJTextPane.setCaretPosition(0);
                }
                if (ontology.getAnnotations() != null) {
                    JTable finalCurrentTermDetailsJTable = currentTermDetailsJTable;
                    if (finalCurrentTermDetailsJTable != null) {
                        for (String ontologyStr : ontology.getAnnotations().keySet()) {
                            ((DefaultTableModel)finalCurrentTermDetailsJTable.getModel()).addRow(new Object[]{ontologyStr, ontology.getAnnotations().get(ontologyStr)});
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, DEFAULT_OLS_CONNECTION_ERROR, "OLS Connection Error", 0);
                        Util.writeToErrorLog("Error when trying to access OLS: ");
                    }
                }
            }
            catch (RestClientException ex) {
                JOptionPane.showMessageDialog(this, DEFAULT_OLS_CONNECTION_ERROR, "OLS Connection Error", 0);
                Util.writeToErrorLog("Error when trying to access OLS: ");
                ex.printStackTrace();
            }
        }
    }

    public JComboBox getOntologyJComboBox() {
        return this.ontologyJComboBox;
    }

    public void setOntologyJComboBox(JComboBox ontologyJComboBox) {
        this.ontologyJComboBox = ontologyJComboBox;
    }

    public Map<String, List<Identifier>> getPreselectedOntologies() {
        return this.preselectedOntologies;
    }

    public void setPreselectedNames2Ids(Map<String, Identifier> preselectedNames2Ids) {
        this.preselectedNames2Ids = preselectedNames2Ids;
    }

    public String getSelectedOntology() {
        return this.selectedOntology;
    }

    public boolean isOnlyListPreselectedOntologies() {
        return this.onlyListPreselectedOntologies;
    }

    public void setLastSelectedOntology(String lastSelectedOntology) {
        this.lastSelectedOntology = lastSelectedOntology;
    }

    public final synchronized boolean cancelTask(AbstractTask task, boolean interrupt) {
        return this.taskManager.cancelTask(task, interrupt);
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public void removeAllThrowableEntries() {
    }

    public ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }
}

