/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.example;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyKrupp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSInputable;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Identifier;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;

public class OLS_Example
extends JFrame
implements OLSInputable {
    private JPanel backgroundPanel;
    private JButton closeJButton;
    private JLabel detectorLabel;
    private JButton instrumentDetectorJButton;
    private JTextField instrumentDetectorJTextField;
    private JButton instrumentSourceJButton;
    private JTextField instrumentSourceJTextField;
    private JSeparator jSeparator4;
    private JLabel massLabel;
    private JTextField modificationAccuracyJTextField;
    private JTextField modificationJTextField;
    private JButton modificationMassJButton;
    private JTextField modificationMassJTextField;
    private JTextField modificationNameJTextField;
    private JLabel nameLabel;
    private JLabel plusMinusLabel;
    private JMenuItem processingMethodsDeleteSelectedRowJMenuItem;
    private JMenuItem processingMethodsEditJMenuItem;
    private JButton processingMethodsJButton;
    private JScrollPane processingMethodsJScrollPane;
    private JTable processingMethodsJTable;
    private JPopupMenu processingMethodsPopupJMenu;
    private JPanel psiModExamplePanel;
    private JLabel psiModLabel;
    private JLabel sourceLabel;
    private JPanel tableExamplePanel;
    private JPanel textFieldExamplePanel;

    public OLS_Example() {
        UIManager.put("TitledBorder.titleColor", new Color(59, 59, 59));
        this.initComponents();
        this.processingMethodsJScrollPane.getViewport().setOpaque(false);
        this.processingMethodsJTable.getColumn(" ").setMaxWidth(40);
        this.processingMethodsJTable.getColumn(" ").setMinWidth(40);
        this.setLocationRelativeTo(null);
    }

    private static void setLookAndFeel() {
        boolean nimbusLookAndFeelFound = false;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                nimbusLookAndFeelFound = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!nimbusLookAndFeelFound) {
            try {
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new SkyKrupp());
                UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.processingMethodsPopupJMenu = new JPopupMenu();
        this.processingMethodsEditJMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.processingMethodsDeleteSelectedRowJMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.textFieldExamplePanel = new JPanel();
        this.sourceLabel = new JLabel();
        this.detectorLabel = new JLabel();
        this.instrumentDetectorJTextField = new JTextField();
        this.instrumentSourceJTextField = new JTextField();
        this.instrumentSourceJButton = new JButton();
        this.instrumentDetectorJButton = new JButton();
        this.tableExamplePanel = new JPanel();
        this.processingMethodsJScrollPane = new JScrollPane();
        this.processingMethodsJTable = new JTable();
        this.processingMethodsJButton = new JButton();
        this.closeJButton = new JButton();
        this.psiModExamplePanel = new JPanel();
        this.massLabel = new JLabel();
        this.modificationMassJTextField = new JTextField();
        this.modificationMassJButton = new JButton();
        this.plusMinusLabel = new JLabel();
        this.modificationAccuracyJTextField = new JTextField();
        this.psiModLabel = new JLabel();
        this.modificationJTextField = new JTextField();
        this.nameLabel = new JLabel();
        this.modificationNameJTextField = new JTextField();
        this.processingMethodsEditJMenuItem.setMnemonic('E');
        this.processingMethodsEditJMenuItem.setText("Edit");
        this.processingMethodsEditJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLS_Example.this.processingMethodsEditJMenuItemActionPerformed(evt);
            }
        });
        this.processingMethodsPopupJMenu.add(this.processingMethodsEditJMenuItem);
        this.processingMethodsPopupJMenu.add(this.jSeparator4);
        this.processingMethodsDeleteSelectedRowJMenuItem.setText("Delete");
        this.processingMethodsDeleteSelectedRowJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLS_Example.this.processingMethodsDeleteSelectedRowJMenuItemActionPerformed(evt);
            }
        });
        this.processingMethodsPopupJMenu.add(this.processingMethodsDeleteSelectedRowJMenuItem);
        this.setDefaultCloseOperation(3);
        this.setTitle("OLS Dialog - Usage Example");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/ols_transparent_small.GIF")));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.textFieldExamplePanel.setBorder(BorderFactory.createTitledBorder("Example Using Text Fields"));
        this.textFieldExamplePanel.setOpaque(false);
        this.sourceLabel.setText("Source");
        this.detectorLabel.setText("Detector");
        this.instrumentDetectorJTextField.setEditable(false);
        this.instrumentDetectorJTextField.setHorizontalAlignment(0);
        this.instrumentSourceJTextField.setEditable(false);
        this.instrumentSourceJTextField.setHorizontalAlignment(0);
        this.instrumentSourceJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ols_transparent.GIF")));
        this.instrumentSourceJButton.setToolTipText("Ontology Lookup Service");
        this.instrumentSourceJButton.setBorderPainted(false);
        this.instrumentSourceJButton.setPreferredSize(new Dimension(61, 23));
        this.instrumentSourceJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLS_Example.this.instrumentSourceJButtonActionPerformed(evt);
            }
        });
        this.instrumentDetectorJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ols_transparent.GIF")));
        this.instrumentDetectorJButton.setToolTipText("Ontology Lookup Service");
        this.instrumentDetectorJButton.setBorderPainted(false);
        this.instrumentDetectorJButton.setPreferredSize(new Dimension(61, 23));
        this.instrumentDetectorJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLS_Example.this.instrumentDetectorJButtonActionPerformed(evt);
            }
        });
        GroupLayout textFieldExamplePanelLayout = new GroupLayout((Container)this.textFieldExamplePanel);
        this.textFieldExamplePanel.setLayout((LayoutManager)textFieldExamplePanelLayout);
        textFieldExamplePanelLayout.setHorizontalGroup((GroupLayout.Group)textFieldExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)textFieldExamplePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)textFieldExamplePanelLayout.createParallelGroup(1).add((Component)this.sourceLabel).add((Component)this.detectorLabel)).add(18, 18, 18).add((GroupLayout.Group)textFieldExamplePanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)textFieldExamplePanelLayout.createSequentialGroup().add((Component)this.instrumentDetectorJTextField, -1, 421, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.instrumentDetectorJButton, -2, 36, -2)).add(2, (GroupLayout.Group)textFieldExamplePanelLayout.createSequentialGroup().add((Component)this.instrumentSourceJTextField).addPreferredGap(1).add((Component)this.instrumentSourceJButton, -2, 36, -2))).addContainerGap()));
        textFieldExamplePanelLayout.setVerticalGroup((GroupLayout.Group)textFieldExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)textFieldExamplePanelLayout.createSequentialGroup().add(2, 2, 2).add((GroupLayout.Group)textFieldExamplePanelLayout.createParallelGroup(4).add((Component)this.sourceLabel).add((Component)this.instrumentSourceJTextField, -2, -1, -2).add((Component)this.instrumentSourceJButton, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)textFieldExamplePanelLayout.createParallelGroup(4).add((Component)this.detectorLabel).add((Component)this.instrumentDetectorJTextField, -2, -1, -2).add((Component)this.instrumentDetectorJButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tableExamplePanel.setBorder(BorderFactory.createTitledBorder("Example Using Tables"));
        this.tableExamplePanel.setOpaque(false);
        this.processingMethodsJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "CV Terms", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.processingMethodsJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OLS_Example.this.processingMethodsJTableMouseClicked(evt);
            }
        });
        this.processingMethodsJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OLS_Example.this.processingMethodsJTableKeyReleased(evt);
            }
        });
        this.processingMethodsJScrollPane.setViewportView(this.processingMethodsJTable);
        this.processingMethodsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ols_transparent.GIF")));
        this.processingMethodsJButton.setText("Add Processing Method");
        this.processingMethodsJButton.setHorizontalTextPosition(10);
        this.processingMethodsJButton.setPreferredSize(new Dimension(177, 23));
        this.processingMethodsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLS_Example.this.processingMethodsJButtonActionPerformed(evt);
            }
        });
        GroupLayout tableExamplePanelLayout = new GroupLayout((Container)this.tableExamplePanel);
        this.tableExamplePanel.setLayout((LayoutManager)tableExamplePanelLayout);
        tableExamplePanelLayout.setHorizontalGroup((GroupLayout.Group)tableExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)tableExamplePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)tableExamplePanelLayout.createParallelGroup(2).add(1, (Component)this.processingMethodsJButton, -1, -1, Short.MAX_VALUE).add((Component)this.processingMethodsJScrollPane, -1, 535, Short.MAX_VALUE)).addContainerGap()));
        tableExamplePanelLayout.setVerticalGroup((GroupLayout.Group)tableExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)tableExamplePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.processingMethodsJScrollPane, -2, 85, -2).addPreferredGap(0).add((Component)this.processingMethodsJButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.closeJButton.setText("Close");
        this.closeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLS_Example.this.closeJButtonActionPerformed(evt);
            }
        });
        this.psiModExamplePanel.setBorder(BorderFactory.createTitledBorder("Example Using PSI-MOD"));
        this.psiModExamplePanel.setOpaque(false);
        this.massLabel.setText("Mass");
        this.modificationMassJTextField.setHorizontalAlignment(0);
        this.modificationMassJTextField.setText("15.994915");
        this.modificationMassJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ols_transparent.GIF")));
        this.modificationMassJButton.setToolTipText("Ontology Lookup Service");
        this.modificationMassJButton.setBorderPainted(false);
        this.modificationMassJButton.setPreferredSize(new Dimension(61, 23));
        this.modificationMassJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OLS_Example.this.modificationMassJButtonActionPerformed(evt);
            }
        });
        this.plusMinusLabel.setText("+-");
        this.modificationAccuracyJTextField.setHorizontalAlignment(0);
        this.modificationAccuracyJTextField.setText("0.1");
        this.psiModLabel.setText("PSI-MOD");
        this.modificationJTextField.setEditable(false);
        this.modificationJTextField.setHorizontalAlignment(0);
        this.nameLabel.setText("Name");
        this.modificationNameJTextField.setHorizontalAlignment(0);
        this.modificationNameJTextField.setText("Oxidation");
        GroupLayout psiModExamplePanelLayout = new GroupLayout((Container)this.psiModExamplePanel);
        this.psiModExamplePanel.setLayout((LayoutManager)psiModExamplePanelLayout);
        psiModExamplePanelLayout.setHorizontalGroup((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(1).add((Component)this.massLabel).add((Component)this.nameLabel)).add(30, 30, 30)).add(2, (GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().add((Component)this.psiModLabel).add(18, 18, 18))).add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().add((Component)this.modificationMassJTextField).addPreferredGap(1).add((Component)this.plusMinusLabel).addPreferredGap(1).add((Component)this.modificationAccuracyJTextField, -2, 68, -2)).add((Component)this.modificationNameJTextField)).addPreferredGap(1).add((Component)this.modificationMassJButton, -2, 36, -2)).add((Component)this.modificationJTextField)).addContainerGap()));
        psiModExamplePanelLayout.setVerticalGroup((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(3).add((Component)this.modificationMassJTextField, -2, -1, -2).add((Component)this.modificationAccuracyJTextField, -2, -1, -2).add((Component)this.plusMinusLabel).add((Component)this.massLabel)).addPreferredGap(0).add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(3).add((Component)this.modificationNameJTextField, -2, -1, -2).add((Component)this.nameLabel))).add((GroupLayout.Group)psiModExamplePanelLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.modificationMassJButton, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)psiModExamplePanelLayout.createParallelGroup(3).add((Component)this.psiModLabel).add((Component)this.modificationJTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout((Container)this.backgroundPanel);
        this.backgroundPanel.setLayout((LayoutManager)backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1, false).add((Component)this.psiModExamplePanel, -1, -1, Short.MAX_VALUE).add((Component)this.tableExamplePanel, -1, -1, Short.MAX_VALUE).add((Component)this.textFieldExamplePanel, -2, -1, -2).add(2, (Component)this.closeJButton, -2, 87, -2)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.textFieldExamplePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.tableExamplePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.psiModExamplePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.closeJButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -2, -1, -2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void instrumentSourceJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        String searchTerm = null;
        String ontology = "PSI Mass Spectrometry Ontology [MS] / source";
        if (this.instrumentSourceJTextField.getText().length() > 0) {
            searchTerm = this.instrumentSourceJTextField.getText();
            ontology = searchTerm.substring(searchTerm.lastIndexOf("[") + 1, searchTerm.lastIndexOf("]") - 1);
            ontology = OLS_Example.getOntologyFromCvTerm(ontology);
            searchTerm = this.instrumentSourceJTextField.getText().substring(0, this.instrumentSourceJTextField.getText().indexOf("[") - 1);
            searchTerm = searchTerm.replaceAll("-", " ");
            searchTerm = searchTerm.replaceAll(":", " ");
            searchTerm = searchTerm.replaceAll("\\(", " ");
            searchTerm = searchTerm.replaceAll("\\)", " ");
            searchTerm = searchTerm.replaceAll("&", " ");
            searchTerm = searchTerm.replaceAll("\\+", " ");
            searchTerm = searchTerm.replaceAll("\\[", " ");
            searchTerm = searchTerm.replaceAll("\\]", " ");
        }
        HashMap<String, List<Identifier>> preselectedOntologies = new HashMap<String, List<Identifier>>();
        ArrayList<String> msPreselectedParentTerms = new ArrayList<String>();
        msPreselectedParentTerms.add("MS:1000458");
        preselectedOntologies.put("pride", null);
        preselectedOntologies.put("mod", null);
        preselectedOntologies.put("efo", null);
        preselectedOntologies.put("ms", null);
        preselectedOntologies.put("ms", msPreselectedParentTerms);
        new OLSDialog((JFrame)this, (OLSInputable)this, true, "instrumentSource", ontology, searchTerm, preselectedOntologies, false);
        this.setCursor(new Cursor(0));
    }

    private void instrumentDetectorJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        String searchTerm = null;
        String ontology = "Mass Spectroscopy CV (PSI-MS) [PSI]";
        if (this.instrumentDetectorJTextField.getText().length() > 0) {
            searchTerm = this.instrumentDetectorJTextField.getText();
            ontology = searchTerm.substring(searchTerm.lastIndexOf("[") + 1, searchTerm.lastIndexOf("]") - 1);
            ontology = OLS_Example.getOntologyFromCvTerm(ontology);
            searchTerm = searchTerm.substring(0, searchTerm.indexOf("[") - 1);
            searchTerm = searchTerm.replaceAll("-", " ");
            searchTerm = searchTerm.replaceAll(":", " ");
            searchTerm = searchTerm.replaceAll("\\(", " ");
            searchTerm = searchTerm.replaceAll("\\)", " ");
            searchTerm = searchTerm.replaceAll("&", " ");
            searchTerm = searchTerm.replaceAll("\\+", " ");
            searchTerm = searchTerm.replaceAll("\\[", " ");
            searchTerm = searchTerm.replaceAll("\\]", " ");
        }
        new OLSDialog(this, (OLSInputable)this, true, "instrumentDetector", ontology, searchTerm);
        this.setCursor(new Cursor(0));
    }

    private void processingMethodsJTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            int row = this.processingMethodsJTable.rowAtPoint(evt.getPoint());
            int column = this.processingMethodsJTable.columnAtPoint(evt.getPoint());
            this.processingMethodsJTable.changeSelection(row, column, false, false);
            this.processingMethodsPopupJMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.processingMethodsEditJMenuItemActionPerformed(null);
        }
    }

    private void processingMethodsJTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.processingMethodsDeleteSelectedRowJMenuItemActionPerformed(null);
        }
    }

    private void processingMethodsJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new OLSDialog(this, (OLSInputable)this, true, "processingMethods", "Mass Spectroscopy CV (PSI-MS) [PSI]", null);
        this.setCursor(new Cursor(0));
    }

    private void closeJButtonActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void processingMethodsEditJMenuItemActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        int selectedRow = this.processingMethodsJTable.getSelectedRow();
        String searchTerm = (String)this.processingMethodsJTable.getValueAt(selectedRow, 1);
        String ontology = searchTerm.substring(searchTerm.lastIndexOf("[") + 1, searchTerm.lastIndexOf("]") - 1);
        ontology = OLS_Example.getOntologyFromCvTerm(ontology);
        searchTerm = searchTerm.substring(0, searchTerm.indexOf("[") - 1);
        searchTerm = searchTerm.replaceAll("-", " ");
        searchTerm = searchTerm.replaceAll(":", " ");
        searchTerm = searchTerm.replaceAll("\\(", " ");
        searchTerm = searchTerm.replaceAll("\\)", " ");
        searchTerm = searchTerm.replaceAll("&", " ");
        searchTerm = searchTerm.replaceAll("\\+", " ");
        searchTerm = searchTerm.replaceAll("\\[", " ");
        searchTerm = searchTerm.replaceAll("\\]", " ");
        new OLSDialog((JFrame)this, (OLSInputable)this, true, "processingMethods", ontology, selectedRow, searchTerm);
        this.setCursor(new Cursor(0));
    }

    private void processingMethodsDeleteSelectedRowJMenuItemActionPerformed(ActionEvent evt) {
        int selectedRow = this.processingMethodsJTable.getSelectedRow();
        if (selectedRow != -1) {
            ((DefaultTableModel)this.processingMethodsJTable.getModel()).removeRow(selectedRow);
            this.fixProcessingMethodsIndices();
        }
    }

    private void modificationMassJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        boolean error = false;
        Double currentModificationMass = 0.0;
        Double currentAccuracy = 0.1;
        try {
            currentModificationMass = new Double(this.modificationMassJTextField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "The mass is not a number!", "Modification Mass", 1);
            this.modificationMassJTextField.requestFocus();
            error = true;
        }
        if (!error) {
            try {
                currentAccuracy = new Double(this.modificationAccuracyJTextField.getText());
                if (currentAccuracy < 0.0) {
                    JOptionPane.showMessageDialog(null, "The accuracy has to be a positive value.", "Mass Accuracy", 1);
                    this.modificationAccuracyJTextField.requestFocus();
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "The accuracy is not a number!", "Mass Accuracy", 1);
                this.modificationAccuracyJTextField.requestFocus();
                error = true;
            }
        }
        if (!error) {
            new OLSDialog(this, (OLSInputable)this, true, "modificationMass", "Protein Modifications (PSI-MOD) [MOD]", -1, this.modificationNameJTextField.getText(), currentModificationMass, currentAccuracy, OLSDialog.OLS_DIALOG_PSI_MOD_MASS_SEARCH, null);
        }
        this.setCursor(new Cursor(0));
    }

    public static void main(String[] args) {
        OLS_Example.setLookAndFeel();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OLS_Example().setVisible(true);
            }
        });
    }

    private void fixProcessingMethodsIndices() {
        for (int row = 0; row < this.processingMethodsJTable.getModel().getRowCount(); ++row) {
            this.processingMethodsJTable.getModel().setValueAt(new Integer(row + 1), row, 0);
        }
    }

    public void setModification(Term name, Term accession, String ontology) {
        this.modificationJTextField.setText(name.getLabel() + " [" + accession.getGlobalId().getIdentifier() + "]");
        this.modificationJTextField.setCaretPosition(0);
    }

    public void setInstrumentSource(Term name, Term accession, String ontology) {
        this.instrumentSourceJTextField.setText(name.getLabel() + " [" + accession.getGlobalId().getIdentifier() + "]");
        this.instrumentSourceJTextField.setCaretPosition(0);
    }

    public void setInstrumentDetector(Term name, Term accession, String ontology) {
        this.instrumentDetectorJTextField.setText(name.getLabel() + " [" + accession.getGlobalId().getIdentifier() + "]");
        this.instrumentDetectorJTextField.setCaretPosition(0);
    }

    public void addProcessingMethod(Term name, Term accession, String ontology, int modifiedRow) {
        this.addProcessingMethod(name, accession, ontology, null, modifiedRow);
    }

    public void addProcessingMethod(Term name, Term accession, String ontology, String value, int modifiedRow) {
        if (value != null && value.equalsIgnoreCase("null")) {
            value = null;
        }
        if (modifiedRow == -1) {
            ((DefaultTableModel)this.processingMethodsJTable.getModel()).addRow(new Object[]{new Integer(this.processingMethodsJTable.getRowCount() + 1), name.getLabel() + " [" + accession.getGlobalId().getIdentifier() + "]", value});
        } else {
            this.processingMethodsJTable.setValueAt(name.getLabel() + " [" + accession.getGlobalId().getIdentifier() + "]", modifiedRow, 1);
            this.processingMethodsJTable.setValueAt(null, modifiedRow, 2);
        }
    }

    @Override
    public void insertOLSResult(String field, Term selectedValue, Term accession, String ontologyShort, String ontologyLong, int modifiedRow, String mappedTerm, List<String> metadata) {
        if (field.equalsIgnoreCase("instrumentSource")) {
            this.setInstrumentSource(selectedValue, accession, ontologyShort);
        } else if (field.equalsIgnoreCase("instrumentDetector")) {
            this.setInstrumentDetector(selectedValue, accession, ontologyShort);
        } else if (field.equalsIgnoreCase("processingMethods")) {
            this.addProcessingMethod(selectedValue, accession, ontologyShort, modifiedRow);
        } else if (field.equalsIgnoreCase("modificationMass")) {
            this.setModification(selectedValue, accession, ontologyShort);
        }
    }

    @Override
    public Window getWindow() {
        return this;
    }

    public static String getOntologyFromCvTerm(String cvTerm) {
        String ontology = cvTerm.lastIndexOf(":") != -1 ? cvTerm.substring(0, cvTerm.lastIndexOf(":")) : (cvTerm.lastIndexOf("_") != -1 ? cvTerm.substring(0, cvTerm.lastIndexOf("_")) : "NEWT");
        return ontology;
    }
}

