/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.prop;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import uk.ac.ebi.pride.toolsuite.ols.dialog.prop.PropertyChangeHandler;

public class PropertyChangeHelper
implements PropertyChangeHandler {
    private final PropertyChangeSupport supporter;

    public PropertyChangeHelper() {
        this.supporter = new ImprovedPropertyChangerSupport(this);
    }

    public PropertyChangeHelper(Object source) {
        this.supporter = new ImprovedPropertyChangerSupport(source);
    }

    public boolean hasPropertyChangeListener(PropertyChangeListener listener) {
        for (PropertyChangeListener propertyChangeListener : this.supporter.getPropertyChangeListeners()) {
            if (!propertyChangeListener.equals(listener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.supporter.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.supporter.addPropertyChangeListener(propName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.supporter.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.supporter.removePropertyChangeListener(propName, listener);
    }

    @Override
    public void removeAllPropertyChangeListeners() {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = this.supporter.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(listener);
        }
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.supporter.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propName) {
        return this.supporter.getPropertyChangeListeners(propName);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent event) {
        this.supporter.firePropertyChange(event);
    }

    @Override
    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.supporter.firePropertyChange(propName, oldValue, newValue);
    }

    private class ImprovedPropertyChangerSupport
    extends PropertyChangeSupport {
        public ImprovedPropertyChangerSupport(Object o) {
            super(o);
        }

        @Override
        public void firePropertyChange(final PropertyChangeEvent event) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(event);
            } else {
                Runnable eventDispatcher = new Runnable(){

                    @Override
                    public void run() {
                        ImprovedPropertyChangerSupport.this.firePropertyChange(event);
                    }
                };
                EventQueue.invokeLater(eventDispatcher);
            }
        }
    }
}

