/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.client.RestClientException;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.Util;
import uk.ac.ebi.pride.utilities.ols.web.service.client.OLSClient;
import uk.ac.ebi.pride.utilities.ols.web.service.model.ITerm;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Identifier;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;

public class GetOntologyRootsTask
extends AbstractTask {
    String ontologyName;
    Identifier parentTermId;
    private static String TASK_NAME = "Get Ontology Roots Task";
    private static Term notDefinedNode = new Term(null, "No Root Terms Defined!", null, null, null, null, null, null, true, null);

    public GetOntologyRootsTask(OLSDialog olsDialog, OLSClient olsClient, String ontologyName, Identifier parentTermId) {
        super(TASK_NAME, olsDialog, olsClient);
        this.ontologyName = ontologyName;
        this.parentTermId = parentTermId;
    }

    @Override
    protected void cancelled() {
    }

    protected void succeed(Object results) {
    }

    @Override
    protected void finished() {
    }

    @Override
    protected void interrupted(InterruptedException iex) {
    }

    @Override
    protected Object doInBackground() throws Exception {
        List<ITerm> rootTerms = null;
        if (!this.ontologyName.equalsIgnoreCase("-- Search in All Ontologies available in the OLS registry --")) {
            if (!this.ontologyName.equalsIgnoreCase("-- Search in these preselected Ontologies --")) {
                rootTerms = this.getOntologyRoots(this.ontologyName, this.parentTermId);
            }
        }
        if (rootTerms != null) {
            if (rootTerms.isEmpty()) {
                this.olsDialog.treeBrowser.addNode((ITerm)notDefinedNode);
            } else {
                for (ITerm term : rootTerms) {
                    this.olsDialog.treeBrowser.addNode(term);
                }
            }
        }
        return null;
    }

    public List<ITerm> getOntologyRoots(String ontologyName, Identifier parentTermId) {
        ArrayList<ITerm> retrievedValues = new ArrayList<ITerm>();
        try {
            List<Object> roots = parentTermId == null ? this.olsClient.getRootTerms(ontologyName) : this.olsClient.getTermChildren(parentTermId, ontologyName, 1);
            if (roots != null) {
                roots = Util.refineOntologyNullIds(roots);
                retrievedValues.addAll(roots);
            }
        }
        catch (RestClientException e) {
            logger.error("Error when trying to access OLS: ");
            e.printStackTrace();
        }
        return retrievedValues;
    }

    @Override
    protected void done() {
        this.olsDialog.treeBrowser.updateTree();
        this.olsDialog.treeBrowser.scrollToTop();
        this.olsDialog.currentlySelectedBrowseOntologyAccessionNumber = null;
        this.olsDialog.clearData(OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY, true, true);
        this.olsDialog.setCursor(new Cursor(0));
    }
}

