/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.reader.bb;

import com.github.mzdb4s.io.reader.bb.AbstractBlobReader;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.ISpectrumData;
import com.github.mzdb4s.msdata.SpectrumData;
import com.github.mzdb4s.msdata.SpectrumHeader;
import com.github.mzdb4s.msdata.SpectrumSlice;
import com.github.mzdb4s.util.primitive.BytesUtils$;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import scala.collection.mutable.LongMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001=\u0011Ab\u0015;sK\u0006l'+Z1eKJT!a\u0001\u0003\u0002\u0005\t\u0014'BA\u0003\u0007\u0003\u0019\u0011X-\u00193fe*\u0011q\u0001C\u0001\u0003S>T!!\u0003\u0006\u0002\r5THM\u0019\u001bt\u0015\tYA\"\u0001\u0004hSRDWO\u0019\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011!#\u00112tiJ\f7\r\u001e\"m_\n\u0014V-\u00193fe\"AQ\u0003\u0001BA\u0002\u0013%a#A\u0004`gR\u0014X-Y7\u0016\u0003]\u0001\"\u0001\u0007\u000f\u000e\u0003eQ!a\u0002\u000e\u000b\u0003m\tAA[1wC&\u0011Q$\u0007\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005 \u0001\t\u0005\r\u0011\"\u0003!\u0003-y6\u000f\u001e:fC6|F%Z9\u0015\u0005\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#\u0001B+oSRDq\u0001\u000b\u0010\u0002\u0002\u0003\u0007q#A\u0002yIEB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006KaF\u0001\t?N$(/Z1nA!AA\u0006\u0001BC\u0002\u0013\u0005Q&A\bgSJ\u001cHo\u00159fGR\u0014X/\\%e+\u0005q\u0003C\u0001\u00120\u0013\t\u00014E\u0001\u0003M_:<\u0007\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002!\u0019L'o\u001d;Ta\u0016\u001cGO];n\u0013\u0012\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u0017\u0002\u001d1\f7\u000f^*qK\u000e$(/^7JI\"Aa\u0007\u0001B\u0001B\u0003%a&A\bmCN$8\u000b]3diJ,X.\u00133!\u0011!A\u0004A!b\u0001\n\u0003I\u0014AE:qK\u000e$(/^7IK\u0006$WM\u001d\"z\u0013\u0012,\u0012A\u000f\t\u0004w\u0001\u0013U\"\u0001\u001f\u000b\u0005ur\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003\u007f\r\n!bY8mY\u0016\u001cG/[8o\u0013\t\tEHA\u0004M_:<W*\u00199\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0011AB7tI\u0006$\u0018-\u0003\u0002H\t\nq1\u000b]3diJ,X\u000eS3bI\u0016\u0014\b\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002'M\u0004Xm\u0019;sk6DU-\u00193fe\nK\u0018\n\u001a\u0011\t\u0011-\u0003!Q1A\u0005\u00021\u000b\u0001\u0004Z1uC\u0016s7m\u001c3j]\u001e\u0014\u0015p\u00159fGR\u0014X/\\%e+\u0005i\u0005cA\u001eA\u001dB\u00111iT\u0005\u0003!\u0012\u0013A\u0002R1uC\u0016s7m\u001c3j]\u001eD\u0001B\u0015\u0001\u0003\u0002\u0003\u0006I!T\u0001\u001aI\u0006$\u0018-\u00128d_\u0012Lgn\u001a\"z'B,7\r\u001e:v[&#\u0007\u0005C\u0003U\u0001\u0011\u0005Q+\u0001\u0004=S:LGO\u0010\u000b\u0007-^C\u0016LW.\u0011\u0005E\u0001\u0001\"B\u000bT\u0001\u00049\u0002\"\u0002\u0017T\u0001\u0004q\u0003\"\u0002\u001bT\u0001\u0004q\u0003\"\u0002\u001dT\u0001\u0004Q\u0004\"B&T\u0001\u0004i\u0005\"B/\u0001\t\u0003r\u0016a\u00033jgB|7/\u001a\"m_\n$\u0012!\t\u0005\u0006A\u0002!\t%Y\u0001\u0010O\u0016$8\u000b]3diJ\f7i\\;oiR\t!\r\u0005\u0002#G&\u0011Am\t\u0002\u0004\u0013:$\b\"\u00024\u0001\t\u0003:\u0017aD4fiN\u0003Xm\u0019;sk6LE-\u0011;\u0015\u00059B\u0007\"B5f\u0001\u0004\u0011\u0017aA5eq\")1\u000e\u0001C!Y\u0006\u0019\"/Z1e'B,7\r\u001e:v[Nc\u0017nY3BiR\u0011Q\u000e\u001d\t\u0003\u0007:L!a\u001c#\u0003\u001bM\u0003Xm\u0019;sk6\u001cF.[2f\u0011\u0015I'\u000e1\u0001c\u0011\u0015\u0011\b\u0001\"\u0003t\u0003Qy&/Z1e'B,7\r\u001e:v[Nc\u0017nY3BiR!Q\u000e^;{\u0011\u0015I\u0017\u000f1\u0001c\u0011\u00151\u0018\u000f1\u0001x\u0003\u0015i\u0017N\\'{!\t\u0011\u00030\u0003\u0002zG\t1Ai\\;cY\u0016DQa_9A\u0002]\fQ!\\1y\u001bjDQ! \u0001\u0005By\fqC]3bIN\u0003Xm\u0019;sk6\u001cF.[2f\t\u0006$\u0018-\u0011;\u0015\u0007}\f)\u0001E\u0002D\u0003\u0003I1!a\u0001E\u00055I5\u000b]3diJ,X\u000eR1uC\")\u0011\u000e a\u0001E\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011a\b:fC\u00124\u0015\u000e\u001c;fe\u0016$7\u000b]3diJ,Xn\u00157jG\u0016$\u0015\r^1BiR9q0!\u0004\u0002\u0010\u0005E\u0001BB5\u0002\b\u0001\u0007!\r\u0003\u0004w\u0003\u000f\u0001\ra\u001e\u0005\u0007w\u0006\u001d\u0001\u0019A<")
public class StreamReader
extends AbstractBlobReader {
    private InputStream _stream;
    private final long firstSpectrumId;
    private final long lastSpectrumId;
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<DataEncoding> dataEncodingBySpectrumId;

    private InputStream _stream() {
        return this._stream;
    }

    private void _stream_$eq(InputStream x$1) {
        this._stream = x$1;
    }

    @Override
    public long firstSpectrumId() {
        return this.firstSpectrumId;
    }

    @Override
    public long lastSpectrumId() {
        return this.lastSpectrumId;
    }

    @Override
    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    @Override
    public LongMap<DataEncoding> dataEncodingBySpectrumId() {
        return this.dataEncodingBySpectrumId;
    }

    @Override
    public void disposeBlob() {
        try {
            this._stream().close();
            return;
        }
        catch (IOException iOException) {
            throw new Exception("IOException has been caught while closing stream", iOException);
        }
    }

    @Override
    public int getSpectraCount() {
        throw new Exception("NYI");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getSpectrumIdAt(int idx) {
        void var2_2;
        long lastSpectrumId = 0L;
        for (int j = 0; j <= idx; ++j) {
            byte[] spectrumIdBytes = new byte[4];
            this._stream().read(spectrumIdBytes);
            lastSpectrumId = BytesUtils$.MODULE$.bytesToInt(spectrumIdBytes, 0);
            byte[] peaksCountBytes = new byte[4];
            this._stream().read(peaksCountBytes);
            int peaksCount = BytesUtils$.MODULE$.bytesToInt(peaksCountBytes, 0);
            DataEncoding de = (DataEncoding)this.dataEncodingBySpectrumId().apply(lastSpectrumId);
            this.checkDataEncodingIsNotNull(de, lastSpectrumId);
            this._stream().skip(peaksCount * de.getPeakStructSize());
        }
        return (long)var2_2;
    }

    @Override
    public SpectrumSlice readSpectrumSliceAt(int idx) {
        return this._readSpectrumSliceAt(idx, -1.0, -1.0);
    }

    private SpectrumSlice _readSpectrumSliceAt(int idx, double minMz, double maxMz) {
        byte[] peaksBytes = null;
        long spectrumId = 0L;
        int peaksCount = 0;
        DataEncoding de = null;
        for (int j = 0; j <= idx; ++j) {
            Long l;
            byte[] spectrumIdBytes = new byte[4];
            this._stream().read(spectrumIdBytes);
            spectrumId = BytesUtils$.MODULE$.bytesToInt(spectrumIdBytes, 0);
            de = (DataEncoding)this.dataEncodingBySpectrumId().apply(spectrumId);
            byte[] peaksCountBytes = new byte[4];
            this._stream().read(peaksCountBytes);
            peaksCount = BytesUtils$.MODULE$.bytesToInt(peaksCountBytes, 0);
            int peaksBytesSize = peaksCount * de.getPeakStructSize();
            if (j < idx) {
                l = BoxesRunTime.boxToLong((long)this._stream().skip(peaksBytesSize));
                continue;
            }
            byte[] pb = new byte[peaksBytesSize];
            this._stream().read(pb);
            peaksBytes = pb;
            l = BoxedUnit.UNIT;
        }
        if (peaksBytes == null) {
            return null;
        }
        SpectrumData spectrumSliceData = this.readSpectrumSliceData(ByteBuffer.wrap(peaksBytes), 0, peaksBytes.length, de, minMz, maxMz);
        return new SpectrumSlice((SpectrumHeader)this.spectrumHeaderById().apply(spectrumId), spectrumSliceData);
    }

    @Override
    public ISpectrumData readSpectrumSliceDataAt(int idx) {
        return this.readSpectrumSliceAt(idx).getData();
    }

    @Override
    public ISpectrumData readFilteredSpectrumSliceDataAt(int idx, double minMz, double maxMz) {
        return this._readSpectrumSliceAt(idx, minMz, maxMz).getData();
    }

    public StreamReader(InputStream _stream, long firstSpectrumId, long lastSpectrumId, LongMap<SpectrumHeader> spectrumHeaderById, LongMap<DataEncoding> dataEncodingBySpectrumId) {
        this._stream = _stream;
        this.firstSpectrumId = firstSpectrumId;
        this.lastSpectrumId = lastSpectrumId;
        this.spectrumHeaderById = spectrumHeaderById;
        this.dataEncodingBySpectrumId = dataEncodingBySpectrumId;
    }
}

