/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.algo.IIsotopicPatternScorer$class;
import fr.profi.mzdb.model.SpectrumData;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

public final class DotProductPatternScorerV1$
implements IIsotopicPatternScorer {
    public static final DotProductPatternScorerV1$ MODULE$;
    private final int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DotProductPatternScorerV1$();
    }

    @Override
    public int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE() {
        return this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    }

    @Override
    public void fr$profi$mzdb$algo$IIsotopicPatternScorer$_setter_$fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE_$eq(int x$1) {
        this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE = x$1;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        return IIsotopicPatternScorer$class.calcIsotopicPatternHypotheses(this, spectrum, mz, ppmTol);
    }

    private Logger logger$lzycompute() {
        DotProductPatternScorerV1$ dotProductPatternScorerV1$ = this;
        synchronized (dotProductPatternScorerV1$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(mz, charge);
        double scale = (double)spectrum.getIntensityList()[spectrum.getNearestPeakIndex(initialMz)] / (double)BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[isotopicShift]._2());
        DoubleRef ipMoz = DoubleRef.create((double)mz);
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)new Serializable(spectrum, charge, ppmTol, pattern, scale, ipMoz, observed, expected){
            public static final long serialVersionUID = 0L;
            private final SpectrumData spectrum$3;
            private final int charge$3;
            private final double ppmTol$3;
            private final TheoreticalIsotopePattern pattern$3;
            private final double scale$2;
            private final DoubleRef ipMoz$3;
            private final double[] observed$2;
            private final double[] expected$2;

            public final void apply(int rank) {
                this.apply$mcVI$sp(rank);
            }

            public void apply$mcVI$sp(int rank) {
                this.ipMoz$3.elem = rank == 0 ? this.ipMoz$3.elem : this.ipMoz$3.elem + 1.0027 / (double)this.charge$3;
                int nearestPeakIdx = this.spectrum$3.getNearestPeakIndex(this.ipMoz$3.elem);
                this.observed$2[rank] = 1000000.0 * Math.abs(this.spectrum$3.getMzList()[nearestPeakIdx] - this.ipMoz$3.elem) / this.ipMoz$3.elem < this.ppmTol$3 ? (double)this.spectrum$3.getIntensityList()[nearestPeakIdx] : (double)(-BoxesRunTime.unboxToFloat((Object)this.pattern$3.mzAbundancePairs()[rank]._2())) * this.scale$2;
                this.expected$2[rank] = BoxesRunTime.unboxToFloat((Object)this.pattern$3.mzAbundancePairs()[rank]._2());
            }
            {
                this.spectrum$3 = spectrum$3;
                this.charge$3 = charge$3;
                this.ppmTol$3 = ppmTol$3;
                this.pattern$3 = pattern$3;
                this.scale$2 = scale$2;
                this.ipMoz$3 = ipMoz$3;
                this.observed$2 = observed$2;
                this.expected$2 = expected$2;
            }
        });
        score = this.dotProduct(observed, expected);
        score = 1.0 - score;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)pattern);
    }

    public double dotProduct(double[] observed, double[] expected) {
        double sumObserved = 0.0;
        double sumExpected = 0.0;
        double product = 0.0;
        double[] weights = new double[]{0.25, 0.25, 0.25, 0.08, 0.06, 0.05, 0.04, 0.02};
        for (int k = 0; k < observed.length && expected[k] > 0.1; ++k) {
            double weight = k < Predef$.MODULE$.doubleArrayOps(weights).size() ? weights[k] : 0.0;
            product += weight * observed[k] * expected[k];
            sumExpected += weight * expected[k] * expected[k];
            sumObserved += weight * observed[k] * observed[k];
        }
        return sumExpected == 0.0 || sumObserved == 0.0 ? 0.0 : product / (Math.sqrt(sumExpected) * Math.sqrt(sumObserved));
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> selectBestPatternHypothese(Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns, double deltaScore) {
        double refScore = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])putativePatterns).head())._1$mcD$sp();
        Tuple2[] patterns = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])putativePatterns).filter((Function1)new Serializable(deltaScore, refScore){
            public static final long serialVersionUID = 0L;
            private final double deltaScore$2;
            private final double refScore$2;

            public final boolean apply(Tuple2<Object, TheoreticalIsotopePattern> p) {
                return package$.MODULE$.abs(p._1$mcD$sp() - this.refScore$2) < this.deltaScore$2;
            }
            {
                this.deltaScore$2 = deltaScore$2;
                this.refScore$2 = refScore$2;
            }
        });
        return (Tuple2)Predef$.MODULE$.refArrayOps((Object[])patterns).maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, TheoreticalIsotopePattern> p) {
                return ((TheoreticalIsotopePattern)p._2()).charge();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    @Override
    public double selectBestPatternHypothese$default$2() {
        return 0.1;
    }

    private DotProductPatternScorerV1$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        IIsotopicPatternScorer$class.$init$(this);
    }
}

