/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.Settings$;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor$class;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelCursor;
import fr.profi.mzdb.model.SpectrumData;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class PeakelsPatternPredictor$
implements IIsotopicPatternPredictor {
    public static final PeakelsPatternPredictor$ MODULE$;
    private final IIsotopicPatternScorer isotopicPatternScorer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PeakelsPatternPredictor$();
    }

    @Override
    public IIsotopicPatternScorer isotopicPatternScorer() {
        return this.isotopicPatternScorer;
    }

    @Override
    public void fr$profi$mzdb$algo$IIsotopicPatternPredictor$_setter_$isotopicPatternScorer_$eq(IIsotopicPatternScorer x$1) {
        this.isotopicPatternScorer = x$1;
    }

    @Override
    public boolean isMatchReliable(SpectrumData spectrumData, double ppm, double moz, int charge, double mozTolInDa) {
        return IIsotopicPatternPredictor$class.isMatchReliable(this, spectrumData, ppm, moz, charge, mozTolInDa);
    }

    private Logger logger$lzycompute() {
        PeakelsPatternPredictor$ peakelsPatternPredictor$ = this;
        synchronized (peakelsPatternPredictor$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Tuple2<Object, TheoreticalIsotopePattern> getBestExplanation(float mozTolPPM, Seq<Peakel> coelutingPeakels, Peakel peakel) {
        SpectrumData spectrumData = this.buildSpectrumFromPeakels(coelutingPeakels, peakel);
        Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = this.isotopicPatternScorer().calcIsotopicPatternHypotheses(spectrumData, peakel.getApexMz(), mozTolPPM);
        return this.isotopicPatternScorer().selectBestPatternHypothese(putativePatterns, this.isotopicPatternScorer().selectBestPatternHypothese$default$2());
    }

    public ArrayBuffer<Tuple2<Peakel, Object>> assessReliability(float mozTolPPM, Seq<Peakel> coelutingPeakels, Seq<Peakel> matchingPeakels, int charge, double mozTolInDa) {
        ArrayBuffer filteredPeakels = new ArrayBuffer(matchingPeakels.length());
        matchingPeakels.foreach((Function1)new Serializable(mozTolPPM, coelutingPeakels, charge, mozTolInDa, filteredPeakels){
            public static final long serialVersionUID = 0L;
            private final float mozTolPPM$1;
            private final Seq coelutingPeakels$1;
            private final int charge$2;
            private final double mozTolInDa$2;
            private final ArrayBuffer filteredPeakels$2;

            public final ArrayBuffer<Tuple2<Peakel, Object>> apply(Peakel matchingPeakel) {
                SpectrumData spectrumData = PeakelsPatternPredictor$.MODULE$.buildSpectrumFromPeakels((Seq<Peakel>)this.coelutingPeakels$1, matchingPeakel);
                boolean isReliable = PeakelsPatternPredictor$.MODULE$.isMatchReliable(spectrumData, this.mozTolPPM$1, matchingPeakel.getApexMz(), this.charge$2, this.mozTolInDa$2);
                return this.filteredPeakels$2.$plus$eq((Object)new Tuple2((Object)matchingPeakel, (Object)BoxesRunTime.boxToBoolean((boolean)isReliable)));
            }
            {
                this.mozTolPPM$1 = mozTolPPM$1;
                this.coelutingPeakels$1 = coelutingPeakels$1;
                this.charge$2 = charge$2;
                this.mozTolInDa$2 = mozTolInDa$2;
                this.filteredPeakels$2 = filteredPeakels$2;
            }
        });
        return filteredPeakels;
    }

    public SpectrumData buildSpectrumFromPeakels(Seq<Peakel> coelutingPeakels, Peakel peakel) {
        Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> tuple2 = this.slicePeakels(coelutingPeakels, peakel.getApexSpectrumId(), Settings$.MODULE$.peakelsSlicingSpan());
        if (tuple2 != null) {
            Tuple2 tuple22;
            ArrayBuffer mzList = (ArrayBuffer)tuple2._1();
            ArrayBuffer intensityList = (ArrayBuffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)mzList, (Object)intensityList);
            ArrayBuffer mzList2 = (ArrayBuffer)tuple23._1();
            ArrayBuffer intensityList2 = (ArrayBuffer)tuple23._2();
            SpectrumData spectrumData = new SpectrumData((double[])mzList2.toArray(ClassTag$.MODULE$.Double()), (float[])intensityList2.toArray(ClassTag$.MODULE$.Float()));
            return spectrumData;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> slicePeakels(Seq<Peakel> coelutingPeakels, long matchingSpectrumId, int span) {
        int coelutingPeakelsCount = coelutingPeakels.length();
        ArrayBuffer mzList = new ArrayBuffer(coelutingPeakelsCount);
        ArrayBuffer intensityList = new ArrayBuffer(coelutingPeakelsCount);
        ((TraversableLike)coelutingPeakels.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Peakel x$4) {
                return x$4.getApexMz();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(matchingSpectrumId, span, mzList, intensityList){
            public static final long serialVersionUID = 0L;
            private final long matchingSpectrumId$1;
            private final int span$1;
            private final ArrayBuffer mzList$1;
            private final ArrayBuffer intensityList$1;

            public final Object apply(Peakel peakel) {
                BoxedUnit boxedUnit;
                boolean foundPeak;
                int index = Arrays.binarySearch(peakel.getSpectrumIds(), this.matchingSpectrumId$1);
                boolean bl = foundPeak = index >= 0 && index < peakel.peaksCount();
                if (!foundPeak) {
                    foundPeak = (index ^= 0xFFFFFFFF) > 0 && index < peakel.peaksCount();
                }
                FloatRef intensitySum = FloatRef.create((float)0.0f);
                DoubleRef mzSum = DoubleRef.create((double)0.0);
                IntRef count = IntRef.create((int)0);
                if (foundPeak) {
                    int minBound = Math.max(0, index - this.span$1);
                    int maxBound = Math.min(index + this.span$1, peakel.getPeaksCount() - 1);
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(minBound), maxBound).foreach$mVc$sp((Function1)new Serializable(this, intensitySum, mzSum, count, peakel){
                        public static final long serialVersionUID = 0L;
                        private final FloatRef intensitySum$1;
                        private final DoubleRef mzSum$1;
                        private final IntRef count$1;
                        private final Peakel peakel$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.intensitySum$1.elem += this.peakel$2.intensityValues()[i];
                            this.mzSum$1.elem += this.peakel$2.mzValues()[i];
                            ++this.count$1.elem;
                        }
                        {
                            this.intensitySum$1 = intensitySum$1;
                            this.mzSum$1 = mzSum$1;
                            this.count$1 = count$1;
                            this.peakel$2 = peakel$2;
                        }
                    });
                    this.mzList$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(mzSum.elem / (double)count.elem)));
                    boxedUnit = this.intensityList$1.$plus$eq((Object)BoxesRunTime.boxToFloat((float)(intensitySum.elem / (float)count.elem)));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.matchingSpectrumId$1 = matchingSpectrumId$1;
                this.span$1 = span$1;
                this.mzList$1 = mzList$1;
                this.intensityList$1 = intensityList$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)mzList, (Object)intensityList);
    }

    public int slicePeakels$default$3() {
        return 1;
    }

    public Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> slicePeakelsV1(Seq<Peakel> coelutingPeakels, long matchingSpectrumId) {
        int coelutingPeakelsCount = coelutingPeakels.length();
        ArrayBuffer mzList = new ArrayBuffer(coelutingPeakelsCount);
        ArrayBuffer intensityList = new ArrayBuffer(coelutingPeakelsCount);
        ((TraversableLike)coelutingPeakels.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Peakel x$5) {
                return x$5.getApexMz();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(matchingSpectrumId, mzList, intensityList){
            public static final long serialVersionUID = 0L;
            private final long matchingSpectrumId$2;
            private final ArrayBuffer mzList$2;
            private final ArrayBuffer intensityList$2;

            public final void apply(Peakel peakel) {
                PeakelCursor peakelCursor = peakel.getNewCursor();
                boolean foundPeak = false;
                while (peakelCursor.next() && !foundPeak) {
                    if (peakelCursor.getSpectrumId() != this.matchingSpectrumId$2) continue;
                    this.mzList$2.$plus$eq((Object)BoxesRunTime.boxToDouble((double)peakelCursor.getMz()));
                    this.intensityList$2.$plus$eq((Object)BoxesRunTime.boxToFloat((float)peakelCursor.getIntensity()));
                    foundPeak = true;
                }
            }
            {
                this.matchingSpectrumId$2 = matchingSpectrumId$2;
                this.mzList$2 = mzList$2;
                this.intensityList$2 = intensityList$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)mzList, (Object)intensityList);
    }

    private PeakelsPatternPredictor$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        IIsotopicPatternPredictor$class.$init$(this);
    }
}

