/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.exporter;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.algo.signal.detection.SmartPeakelFinder;
import fr.profi.mzdb.algo.signal.detection.SmartPeakelFinder$;
import fr.profi.mzdb.algo.signal.filtering.BaselineRemover;
import fr.profi.mzdb.algo.signal.filtering.BaselineRemover$;
import fr.profi.mzdb.algo.signal.filtering.PartialSavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig$;
import fr.profi.mzdb.algo.signal.filtering.XicBinner;
import fr.profi.mzdb.algo.signal.filtering.XicBinnerConfig;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.util.math.DerivativeAnalysis;
import fr.profi.mzdb.util.math.DerivativeAnalysis$;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SQLitePeakelStorer$ {
    public static final SQLitePeakelStorer$ MODULE$;
    private final SavitzkyGolaySmoother sgSmoother;
    private final PartialSavitzkyGolaySmoother psgSmoother;
    private final XicBinner xicBinner;
    private final SmartPeakelFinder peakelFinder;

    static {
        new SQLitePeakelStorer$();
    }

    public SavitzkyGolaySmoother sgSmoother() {
        return this.sgSmoother;
    }

    public PartialSavitzkyGolaySmoother psgSmoother() {
        return this.psgSmoother;
    }

    public XicBinner xicBinner() {
        return this.xicBinner;
    }

    public SmartPeakelFinder peakelFinder() {
        return this.peakelFinder;
    }

    public void storePeakels(Seq<Peakel> peakels, File dbLocation) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"nb peakels:").append((Object)BoxesRunTime.boxToInteger((int)peakels.length())).toString());
        SQLiteConnection connection = new SQLiteConnection(dbLocation);
        connection.open(true);
        connection.exec("PRAGMA temp_store=2;");
        connection.exec("PRAGMA cache_size=8000;");
        connection.exec("CREATE TABLE peakel ( id INTEGER,\n mz REAL,\n time REAL,\n apex REAL,\n ms1_count INTEGER,\n factor REAL,\n xic BLOB,\n smoothed_xic BLOB,\n noise_free_xic BLOB,\n found_peakels BLOB,\n mini_maxi TEXT\n)");
        connection.exec("BEGIN TRANSACTION");
        SQLiteStatement stmt = connection.prepare("INSERT INTO peakel VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", true);
        peakels.foreach((Function1)new Serializable(stmt){
            public static final long serialVersionUID = 0L;
            private final SQLiteStatement stmt$2;

            public final SQLiteStatement apply(Peakel peakel) {
                Tuple2[] tuple2Array;
                Tuple2[] xic = (Tuple2[])Predef$.MODULE$.floatArrayOps(peakel.elutionTimes()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray((double[])Predef$.MODULE$.floatArrayOps(peakel.intensityValues()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(float x$1) {
                        return this.apply$mcDF$sp(x$1);
                    }

                    public double apply$mcDF$sp(float x$1) {
                        return x$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                byte[] chartBytes = SQLitePeakelStorer$.MODULE$.createXicChart(xic, SQLitePeakelStorer$.MODULE$.createXicChart$default$2());
                double oscillationFactor = SQLitePeakelStorer$.MODULE$.peakelFinder().calcOscillationFactor(xic);
                Tuple2<Object, Object>[] smoothedXic = SQLitePeakelStorer$.MODULE$.psgSmoother().smoothTimeIntensityPairs(xic);
                byte[] smoothedChartBytes = SQLitePeakelStorer$.MODULE$.createXicChart(smoothedXic, SQLitePeakelStorer$.MODULE$.createXicChart$default$2());
                Tuple2<Object, Object>[] baselineAnalysis = new BaselineRemover(BaselineRemover$.MODULE$.$lessinit$greater$default$1(), BaselineRemover$.MODULE$.$lessinit$greater$default$2()).removeBaseLine(xic);
                byte[] baselineAnalysisChartBytes = SQLitePeakelStorer$.MODULE$.createXicChart(baselineAnalysis, SQLitePeakelStorer$.MODULE$.createXicChart$default$2());
                Tuple2<Object, Object>[] peakelsIndices = SQLitePeakelStorer$.MODULE$.peakelFinder().findPeakelsIndices(xic);
                if (Predef$.MODULE$.refArrayOps((Object[])peakelsIndices).isEmpty()) {
                    tuple2Array = xic;
                } else {
                    ArrayBuffer mergedXicBuffer = new ArrayBuffer(xic.length);
                    Predef$.MODULE$.refArrayOps((Object[])peakelsIndices).foreach((Function1)new Serializable(this, xic, mergedXicBuffer){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2[] xic$1;
                        private final ArrayBuffer mergedXicBuffer$1;

                        public final ArrayBuffer<Tuple2<Object, Object>> apply(Tuple2<Object, Object> peakelIndices) {
                            Tuple2[] peaks = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.xic$1).slice(peakelIndices._1$mcI$sp(), peakelIndices._2$mcI$sp() + 1);
                            this.mergedXicBuffer$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)((Tuple2)Predef$.MODULE$.refArrayOps((Object[])peaks).head())._1()) - 0.1f))), (Object)BoxesRunTime.boxToDouble((double)0.0)));
                            this.mergedXicBuffer$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])peaks));
                            return this.mergedXicBuffer$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)((Tuple2)Predef$.MODULE$.refArrayOps((Object[])peaks).last())._1()) + 0.1f))), (Object)BoxesRunTime.boxToDouble((double)0.0)));
                        }
                        {
                            this.xic$1 = xic$1;
                            this.mergedXicBuffer$1 = mergedXicBuffer$1;
                        }
                    });
                    tuple2Array = (Tuple2[])mergedXicBuffer.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                }
                Tuple2[] mergedXic = tuple2Array;
                byte[] mergedXicChartBytes = SQLitePeakelStorer$.MODULE$.createXicChart(mergedXic, SQLitePeakelStorer$.MODULE$.createXicChart$default$2());
                DerivativeAnalysis.ILocalDerivativeChange[] miniMaxi = DerivativeAnalysis$.MODULE$.findSignificantMiniMaxi((double[])Predef$.MODULE$.refArrayOps((Object[])smoothedXic).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$2) {
                        return x$2._2$mcD$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), 3, 0.66f);
                int j = 0;
                this.stmt$2.bind(++j, peakel.getId());
                this.stmt$2.bind(++j, peakel.getMz());
                this.stmt$2.bind(++j, (double)peakel.getApexElutionTime());
                this.stmt$2.bind(++j, (double)peakel.getApexIntensity());
                this.stmt$2.bind(++j, peakel.getSpectrumIds().length);
                this.stmt$2.bind(++j, oscillationFactor);
                this.stmt$2.bind(++j, chartBytes);
                this.stmt$2.bind(++j, smoothedChartBytes);
                this.stmt$2.bind(++j, baselineAnalysisChartBytes);
                this.stmt$2.bind(++j, mergedXicChartBytes);
                this.stmt$2.bind(++j, Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])miniMaxi).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(DerivativeAnalysis.ILocalDerivativeChange m) {
                        return new StringBuilder().append(m.value()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)m.isMaximum())}))).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\t"));
                this.stmt$2.step();
                return this.stmt$2.reset();
            }
            {
                this.stmt$2 = stmt$2;
            }
        });
        connection.exec("COMMIT TRANSACTION");
        connection.dispose();
    }

    public byte[] createXicChart(Tuple2<Object, Object>[] xic, float scaling) {
        XYSeries series = new XYSeries((Comparable)((Object)"XIC"));
        Predef$.MODULE$.refArrayOps((Object[])xic).foreach((Function1)new Serializable(scaling, series){
            public static final long serialVersionUID = 0L;
            private final float scaling$1;
            private final XYSeries series$2;

            public final void apply(Tuple2<Object, Object> dataPoint) {
                this.series$2.add((double)(BoxesRunTime.unboxToFloat((Object)dataPoint._1()) * this.scaling$1), dataPoint._2$mcD$sp());
            }
            {
                this.scaling$1 = scaling$1;
                this.series$2 = series$2;
            }
        });
        XYSeriesCollection xyDataset = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"XIC", (String)"Time", (String)"Intensity", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        BufferedImage bi = this.chartToImage(chart, 400, 300);
        return ChartUtilities.encodeAsPNG((BufferedImage)bi);
    }

    public float createXicChart$default$2() {
        return 0.016666668f;
    }

    public BufferedImage chartToImage(JFreeChart chart, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = img.createGraphics();
        chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.dispose();
        return img;
    }

    private SQLitePeakelStorer$() {
        MODULE$ = this;
        this.sgSmoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$1(), SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$2(), SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$3()));
        int x$4 = 1;
        int x$5 = SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$1();
        int x$6 = SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$2();
        this.psgSmoother = new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(x$5, x$6, x$4));
        this.xicBinner = new XicBinner(new XicBinnerConfig(5));
        this.peakelFinder = new SmartPeakelFinder(SmartPeakelFinder$.MODULE$.$lessinit$greater$default$1(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$2(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$3(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$4(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$5(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$6(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$7(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$8());
    }
}

