/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.math;

import fr.profi.mzdb.util.math.DerivativeAnalysis;
import fr.profi.mzdb.util.math.DerivativeAnalysis$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.LongMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

public final class DerivativeAnalysis$ {
    public static final DerivativeAnalysis$ MODULE$;

    static {
        new DerivativeAnalysis$();
    }

    public double[] calcTernarySlopes(double[] values, int derivativeLevel) {
        while (true) {
            double[] signums = (double[])Predef$.MODULE$.doubleArrayOps(values).sliding(2).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(double[] buffer) {
                    double diff = buffer[1] - buffer[0];
                    return diff == 0.0 ? 0.0 : (double)RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(diff));
                }
            }).toArray(ClassTag$.MODULE$.Double());
            if (derivativeLevel == 1) {
                return signums;
            }
            --derivativeLevel;
            values = signums;
        }
    }

    public DerivativeAnalysis.ILocalDerivativeChange[] findMiniMaxi(double[] values) {
        Object object;
        Object object2;
        int valuesCount = values.length;
        int prevSlope = 0;
        double prevMaxValue = 0.0;
        boolean hasSeenAscendingSlope = false;
        boolean afterMinimum = true;
        boolean afterMaximum = false;
        ListBuffer changes = new ListBuffer();
        int maxPrevIdx = valuesCount - 2;
        for (int prevIdx = 0; prevIdx <= maxPrevIdx; ++prevIdx) {
            int curSlope;
            double curValue = values[prevIdx + 1];
            double prevValue = values[prevIdx];
            double curDiff = curValue - prevValue;
            int n = curSlope = curDiff == 0.0 ? 0 : RichDouble$.MODULE$.signum$extension(Predef$.MODULE$.doubleWrapper(curDiff));
            if (!hasSeenAscendingSlope && curSlope == 1) {
                hasSeenAscendingSlope = true;
            }
            if (hasSeenAscendingSlope) {
                if (afterMaximum && curValue > prevMaxValue) {
                    prevMaxValue = curValue;
                }
                if (curSlope != prevSlope) {
                    if (prevSlope == 1 && afterMinimum) {
                        changes.$plus$eq((Object)new DerivativeAnalysis.LocalMaximum(values[prevIdx], prevIdx));
                        prevMaxValue = prevValue;
                        afterMaximum = true;
                        afterMinimum = false;
                    } else if (prevSlope == -1 && afterMaximum) {
                        changes.$plus$eq((Object)new DerivativeAnalysis.LocalMinimum(values[prevIdx], prevIdx));
                        afterMaximum = false;
                        afterMinimum = true;
                    }
                }
            }
            prevSlope = curSlope;
        }
        if (changes.isEmpty()) {
            return (DerivativeAnalysis.ILocalDerivativeChange[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(DerivativeAnalysis.ILocalDerivativeChange.class));
        }
        DerivativeAnalysis.ILocalDerivativeChange firstChange = (DerivativeAnalysis.ILocalDerivativeChange)changes.apply(0);
        if (firstChange.isMaximum()) {
            int firstChangeIdx = firstChange.index();
            if (firstChangeIdx == 0) {
                object2 = changes.remove(0);
            } else {
                double prevMinValue = Double.MAX_VALUE;
                int prevMinIndex = -1;
                for (int idx = 0; idx <= firstChangeIdx; ++idx) {
                    double value2 = values[idx];
                    if (!(value2 < prevMinValue)) continue;
                    prevMinValue = value2;
                    prevMinIndex = idx;
                }
                if (prevMinValue != firstChange.value()) {
                    changes.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(prevMinValue, prevMinIndex)}));
                } else {
                    changes.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(values[0], 0)}));
                }
                object2 = BoxedUnit.UNIT;
            }
        } else {
            object2 = BoxedUnit.UNIT;
        }
        DerivativeAnalysis.ILocalDerivativeChange lastChange = (DerivativeAnalysis.ILocalDerivativeChange)changes.last();
        if (lastChange.isMaximum()) {
            int lastValueIndex;
            int lastChangeIndex = lastChange.index();
            if (lastChangeIndex == (lastValueIndex = valuesCount - 1)) {
                object = changes.remove(lastChangeIndex);
            } else {
                double nextMinValue = Double.MAX_VALUE;
                int nextMinIndex = -1;
                for (int idx = lastChange.index(); idx <= lastValueIndex; ++idx) {
                    double value3 = values[idx];
                    if (!(value3 < nextMinValue)) continue;
                    nextMinValue = value3;
                    nextMinIndex = idx;
                }
                if (nextMinValue != lastChange.value()) {
                    changes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(nextMinValue, nextMinIndex)}));
                } else {
                    changes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DerivativeAnalysis.ILocalDerivativeChange[]{new DerivativeAnalysis.LocalMinimum(values[lastValueIndex], lastValueIndex)}));
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return (DerivativeAnalysis.ILocalDerivativeChange[])changes.toArray(ClassTag$.MODULE$.apply(DerivativeAnalysis.ILocalDerivativeChange.class));
    }

    public DerivativeAnalysis.ILocalDerivativeChange[] findSignificantMiniMaxi(double[] values, int miniMaxiDistanceThresh, float maxIntensityRelThresh) {
        DerivativeAnalysis.ILocalDerivativeChange[] miniMaxi = this.findMiniMaxi(values);
        int miniMaxiCount = miniMaxi.length;
        if (miniMaxiCount <= 3) {
            return miniMaxi;
        }
        List indexedMiniMaxi = (List)Predef$.MODULE$.refArrayOps((Object[])miniMaxi).toList().zipWithIndex(List$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = indexedMiniMaxi.partition((Function1)new anonfun.2());
        if (tuple2 != null) {
            Tuple2 tuple22;
            List indexedMaxima = (List)tuple2._1();
            List indexedMinima = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)indexedMaxima, (Object)indexedMinima);
            List indexedMaxima2 = (List)tuple23._1();
            List indexedMinima2 = (List)tuple23._2();
            LongMap validatedMinimaIndexMap = new LongMap(indexedMinima2.length());
            indexedMinima2.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> check$ifrefutable$1) {
                    Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(validatedMinimaIndexMap){
                public static final long serialVersionUID = 0L;
                private final LongMap validatedMinimaIndexMap$1;

                public final Option<Object> apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> x$3) {
                    Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> tuple2 = x$3;
                    if (tuple2 != null) {
                        int v = tuple2._2$mcI$sp();
                        Option option = this.validatedMinimaIndexMap$1.put((long)v, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        return option;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.validatedMinimaIndexMap$1 = validatedMinimaIndexMap$1;
                }
            });
            LongMap validatedMaximaIndexMap = new LongMap(indexedMaxima2.length());
            indexedMaxima2.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> check$ifrefutable$2) {
                    Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(validatedMaximaIndexMap){
                public static final long serialVersionUID = 0L;
                private final LongMap validatedMaximaIndexMap$1;

                public final Option<Object> apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> x$4) {
                    Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        int v = tuple2._2$mcI$sp();
                        Option option = this.validatedMaximaIndexMap$1.put((long)v, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        return option;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.validatedMaximaIndexMap$1 = validatedMaximaIndexMap$1;
                }
            });
            List sortedIndexedMaxima = (List)indexedMaxima2.sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> x$5) {
                    return -((DerivativeAnalysis.ILocalDerivativeChange)x$5._1()).value();
                }
            }, (Ordering)Ordering.Double$.MODULE$);
            sortedIndexedMaxima.withFilter((Function1)new Serializable(validatedMaximaIndexMap){
                public static final long serialVersionUID = 0L;
                private final LongMap validatedMaximaIndexMap$1;

                public final boolean apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> indexedMaximum) {
                    return BoxesRunTime.unboxToBoolean((Object)this.validatedMaximaIndexMap$1.apply((long)indexedMaximum._2$mcI$sp()));
                }
                {
                    this.validatedMaximaIndexMap$1 = validatedMaximaIndexMap$1;
                }
            }).foreach((Function1)new Serializable(miniMaxiDistanceThresh, maxIntensityRelThresh, miniMaxi, miniMaxiCount, indexedMiniMaxi, validatedMinimaIndexMap, validatedMaximaIndexMap){
                public static final long serialVersionUID = 0L;
                private final int miniMaxiDistanceThresh$1;
                private final float maxIntensityRelThresh$1;
                private final DerivativeAnalysis.ILocalDerivativeChange[] miniMaxi$1;
                private final int miniMaxiCount$1;
                private final List indexedMiniMaxi$1;
                private final LongMap validatedMinimaIndexMap$1;
                private final LongMap validatedMaximaIndexMap$1;

                public final void apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> indexedMaximum) {
                    Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> tuple2 = indexedMaximum;
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        DerivativeAnalysis.ILocalDerivativeChange maximum = (DerivativeAnalysis.ILocalDerivativeChange)tuple2._1();
                        int maxIdx = tuple2._2$mcI$sp();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)maximum, (Object)BoxesRunTime.boxToInteger((int)maxIdx));
                        DerivativeAnalysis.ILocalDerivativeChange maximum2 = (DerivativeAnalysis.ILocalDerivativeChange)tuple23._1();
                        int maxIdx2 = tuple23._2$mcI$sp();
                        this.lookForSignificantMinimum$1(1, maximum2, maxIdx2);
                        this.lookForSignificantMinimum$1(-1, maximum2, maxIdx2);
                        return;
                    }
                    throw new MatchError(tuple2);
                }

                private final void lookForSignificantMinimum$1(int direction, DerivativeAnalysis.ILocalDerivativeChange maximum$1, int maxIdx$1) {
                    boolean minimumAlreadyValidated = false;
                    boolean isMinimumOK = false;
                    int minIdx = maxIdx$1 + direction;
                    while (!isMinimumOK && !minimumAlreadyValidated) {
                        Tuple2 indexedMinimum = (Tuple2)this.indexedMiniMaxi$1.apply(minIdx);
                        Tuple2 tuple2 = indexedMinimum;
                        if (tuple2 != null) {
                            boolean isMinSignificant;
                            boolean bl;
                            boolean isBoundary;
                            Tuple2 tuple22;
                            DerivativeAnalysis.ILocalDerivativeChange minimum = (DerivativeAnalysis.ILocalDerivativeChange)tuple2._1();
                            int minValueIdx = tuple2._2$mcI$sp();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)minimum, (Object)BoxesRunTime.boxToInteger((int)minValueIdx));
                            DerivativeAnalysis.ILocalDerivativeChange minimum2 = (DerivativeAnalysis.ILocalDerivativeChange)tuple23._1();
                            int minValueIdx2 = tuple23._2$mcI$sp();
                            boolean bl2 = isBoundary = minValueIdx2 == 0 || minValueIdx2 == this.miniMaxiCount$1 - 1;
                            if (isBoundary) {
                                bl = true;
                            } else {
                                DerivativeAnalysis.ILocalDerivativeChange nextValidMax = null;
                                for (int maxIdx = minIdx + direction; nextValidMax == null && maxIdx > 0 && maxIdx < this.miniMaxiCount$1; maxIdx += 2 * direction) {
                                    if (!BoxesRunTime.unboxToBoolean((Object)this.validatedMaximaIndexMap$1.apply((long)maxIdx))) continue;
                                    DerivativeAnalysis.ILocalDerivativeChange nextMax = this.miniMaxi$1[maxIdx];
                                    boolean isUnderThresholdFromCurrentMax = minimum2.value() / maximum$1.value() <= (double)this.maxIntensityRelThresh$1;
                                    boolean isUnderThresholdFromOtherMax = minimum2.value() / nextMax.value() <= (double)this.maxIntensityRelThresh$1;
                                    int distFromCurrentMax = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(minimum2.index() - maximum$1.index()));
                                    int distFromOtherMax = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(minimum2.index() - nextMax.index()));
                                    if (!isUnderThresholdFromCurrentMax || !isUnderThresholdFromOtherMax || distFromCurrentMax < this.miniMaxiDistanceThresh$1 || distFromOtherMax < this.miniMaxiDistanceThresh$1) continue;
                                    nextValidMax = nextMax;
                                }
                                bl = isMinSignificant = nextValidMax != null;
                            }
                            if (isMinSignificant) {
                                isMinimumOK = true;
                                this.validatedMinimaIndexMap$1.update((long)minIdx, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                                continue;
                            }
                            if (BoxesRunTime.unboxToBoolean((Object)this.validatedMinimaIndexMap$1.apply((long)minIdx))) {
                                this.validatedMinimaIndexMap$1.update((long)minIdx, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                                this.validatedMaximaIndexMap$1.update((long)maxIdx$1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                                minimumAlreadyValidated = true;
                                continue;
                            }
                            this.validatedMaximaIndexMap$1.update((long)(minIdx + direction), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            minIdx += 2 * direction;
                            continue;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }
                {
                    this.miniMaxiDistanceThresh$1 = miniMaxiDistanceThresh$1;
                    this.maxIntensityRelThresh$1 = maxIntensityRelThresh$1;
                    this.miniMaxi$1 = miniMaxi$1;
                    this.miniMaxiCount$1 = miniMaxiCount$1;
                    this.indexedMiniMaxi$1 = indexedMiniMaxi$1;
                    this.validatedMinimaIndexMap$1 = validatedMinimaIndexMap$1;
                    this.validatedMaximaIndexMap$1 = validatedMaximaIndexMap$1;
                }
            });
            ArrayBuffer filteredIndexedChanges = new ArrayBuffer();
            validatedMinimaIndexMap.$plus$plus((GenTraversableOnce)validatedMaximaIndexMap).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$3) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x$8) {
                    Tuple2<Object, Object> tuple2 = x$8;
                    if (tuple2 != null) {
                        boolean isValidated;
                        boolean bl = isValidated = tuple2._2$mcZ$sp();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            }).foreach((Function1)new Serializable(indexedMiniMaxi, filteredIndexedChanges){
                public static final long serialVersionUID = 0L;
                private final List indexedMiniMaxi$1;
                private final ArrayBuffer filteredIndexedChanges$1;

                public final ArrayBuffer<Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object>> apply(Tuple2<Object, Object> x$9) {
                    Tuple2<Object, Object> tuple2 = x$9;
                    if (tuple2 != null) {
                        long minIdx = tuple2._1$mcJ$sp();
                        ArrayBuffer arrayBuffer = this.filteredIndexedChanges$1.$plus$eq(this.indexedMiniMaxi$1.apply((int)minIdx));
                        return arrayBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.indexedMiniMaxi$1 = indexedMiniMaxi$1;
                    this.filteredIndexedChanges$1 = filteredIndexedChanges$1;
                }
            });
            ArrayBuffer filteredAndSortedChanges = (ArrayBuffer)((SeqLike)filteredIndexedChanges.distinct()).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> x$10) {
                    return x$10._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$);
            ArrayBuffer significantChanges = new ArrayBuffer();
            ObjectRef prevMin = ObjectRef.create(null);
            ObjectRef prevMax = ObjectRef.create(null);
            IntRef sigChangeIdx = IntRef.create((int)0);
            filteredAndSortedChanges.foreach((Function1)new Serializable(indexedMiniMaxi, significantChanges, prevMin, prevMax, sigChangeIdx){
                public static final long serialVersionUID = 0L;
                private final List indexedMiniMaxi$1;
                private final ArrayBuffer significantChanges$1;
                private final ObjectRef prevMin$1;
                private final ObjectRef prevMax$1;
                private final IntRef sigChangeIdx$1;

                public final void apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> indexedDerivativeChange) {
                    Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> tuple2 = indexedDerivativeChange;
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        DerivativeAnalysis.ILocalDerivativeChange derivativeChange = (DerivativeAnalysis.ILocalDerivativeChange)tuple2._1();
                        int derivativeChangeIdx = tuple2._2$mcI$sp();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)derivativeChange, (Object)BoxesRunTime.boxToInteger((int)derivativeChangeIdx));
                        DerivativeAnalysis.ILocalDerivativeChange derivativeChange2 = (DerivativeAnalysis.ILocalDerivativeChange)tuple23._1();
                        int derivativeChangeIdx2 = tuple23._2$mcI$sp();
                        if (derivativeChange2.isMaximum()) {
                            BoxedUnit boxedUnit;
                            if ((Tuple2)this.prevMax$1.elem == null) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                int firstIdx = ((Tuple2)this.prevMax$1.elem)._2$mcI$sp();
                                int lastIdx = derivativeChangeIdx2;
                                boxedUnit = this.significantChanges$1.$plus$eq(((Tuple2)this.indexedMiniMaxi$1.slice(firstIdx, lastIdx + 1).minBy((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(Tuple2<DerivativeAnalysis.ILocalDerivativeChange, Object> x$12) {
                                        return ((DerivativeAnalysis.ILocalDerivativeChange)x$12._1()).value();
                                    }
                                }, (Ordering)Ordering.Double$.MODULE$))._1());
                            }
                            this.significantChanges$1.$plus$eq((Object)derivativeChange2);
                            this.prevMin$1.elem = null;
                            this.prevMax$1.elem = indexedDerivativeChange;
                            ++this.sigChangeIdx$1.elem;
                        } else {
                            if ((Tuple2)this.prevMin$1.elem == null) {
                                this.significantChanges$1.$plus$eq((Object)derivativeChange2);
                                ++this.sigChangeIdx$1.elem;
                            } else if (derivativeChange2.value() < ((DerivativeAnalysis.ILocalDerivativeChange)((Tuple2)this.prevMin$1.elem)._1()).value()) {
                                this.significantChanges$1.update(this.sigChangeIdx$1.elem - 1, (Object)derivativeChange2);
                            }
                            this.prevMin$1.elem = indexedDerivativeChange;
                            this.prevMax$1.elem = null;
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.indexedMiniMaxi$1 = indexedMiniMaxi$1;
                    this.significantChanges$1 = significantChanges$1;
                    this.prevMin$1 = prevMin$1;
                    this.prevMax$1 = prevMax$1;
                    this.sigChangeIdx$1 = sigChangeIdx$1;
                }
            });
            return (DerivativeAnalysis.ILocalDerivativeChange[])significantChanges.toArray(ClassTag$.MODULE$.apply(DerivativeAnalysis.ILocalDerivativeChange.class));
        }
        throw new MatchError((Object)tuple2);
    }

    private DerivativeAnalysis$() {
        MODULE$ = this;
    }
}

