/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.rtree.geometry.Circle;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.awt.geom.Line2D;

public final class Line
implements Geometry {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    private Line(float x1, float y1, float x2, float y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    static Line create(float x1, float y1, float x2, float y2) {
        return new Line(x1, y1, x2, y2);
    }

    static Line create(double x1, double y1, double x2, double y2) {
        return new Line((float)x1, (float)y1, (float)x2, (float)y2);
    }

    @Override
    public double distance(Rectangle r) {
        if (r.contains(this.x1, this.y1) || r.contains(this.x2, this.y2)) {
            return 0.0;
        }
        double d1 = this.distance(r.x1(), r.y1(), r.x1(), r.y2());
        if (d1 == 0.0) {
            return 0.0;
        }
        double d2 = this.distance(r.x1(), r.y2(), r.x2(), r.y2());
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.distance(r.x2(), r.y2(), r.x2(), r.y1());
        double d4 = this.distance(r.x2(), r.y1(), r.x1(), r.y1());
        return Math.min(d1, Math.min(d2, Math.min(d3, d4)));
    }

    private double distance(float x1, float y1, float x2, float y2) {
        Line2D.Float line = new Line2D.Float(x1, y1, x2, y2);
        double d1 = line.ptSegDist(this.x1, this.y1);
        double d2 = line.ptSegDist(this.x2, this.y2);
        Line2D.Float line2 = new Line2D.Float(this.x1, this.y1, this.x2, this.y2);
        double d3 = line2.ptSegDist(x1, y1);
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = line2.ptSegDist(x2, y2);
        if (d4 == 0.0) {
            return 0.0;
        }
        return Math.min(d1, Math.min(d2, Math.min(d3, d4)));
    }

    @Override
    public Rectangle mbr() {
        return Geometries.rectangle(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.max(this.x1, this.x2), Math.max(this.y1, this.y2));
    }

    @Override
    public boolean intersects(Rectangle r) {
        GeometryFactory gf = new GeometryFactory();
        GeometricShapeFactory f = new GeometricShapeFactory(gf);
        f.setBase(new Coordinate((double)r.x1(), (double)r.y1()));
        f.setWidth((double)(r.x2() - r.x1()));
        f.setHeight((double)(r.y2() - r.y1()));
        Polygon rect = f.createRectangle();
        LineSegment line = new LineSegment((double)this.x1, (double)this.y1, (double)this.x2, (double)this.y2);
        return RectangleIntersects.intersects((Polygon)rect, (com.vividsolutions.jts.geom.Geometry)line.toGeometry(gf));
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float x2() {
        return this.x2;
    }

    public float y2() {
        return this.y2;
    }

    public boolean intersects(Line b) {
        Line2D.Float line1 = new Line2D.Float(this.x1, this.y1, this.x2, this.y2);
        Line2D.Float line2 = new Line2D.Float(b.x1(), b.y1(), b.x2(), b.y2());
        return line2.intersectsLine(line1);
    }

    public boolean intersects(Point point) {
        return this.intersects(point.mbr());
    }

    public boolean intersects(Circle circle) {
        Vector c = Vector.create(circle.x(), circle.y());
        Vector a = Vector.create(this.x1, this.y1);
        Vector cMinusA = c.minus(a);
        float radiusSquared = circle.radius() * circle.radius();
        if (this.x1 == this.x2 && this.y1 == this.y2) {
            return cMinusA.modulusSquared() <= radiusSquared;
        }
        Vector b = Vector.create(this.x2, this.y2);
        Vector bMinusA = b.minus(a);
        float bMinusAModulus = bMinusA.modulus();
        float lambda = cMinusA.dot(bMinusA) / bMinusAModulus;
        if (lambda >= 0.0f && lambda <= bMinusAModulus) {
            Vector dMinusA = bMinusA.times(lambda / bMinusAModulus);
            return cMinusA.modulusSquared() - dMinusA.modulusSquared() <= radiusSquared;
        }
        return cMinusA.modulusSquared() <= radiusSquared || c.minus(b).modulusSquared() <= radiusSquared;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2)});
    }

    public boolean equals(Object obj) {
        Optional<Line> other = ObjectsHelper.asClass(obj, Line.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x1), (Object)Float.valueOf(((Line)other.get()).x1)) && Objects.equal((Object)Float.valueOf(this.x2), (Object)Float.valueOf(((Line)other.get()).x2)) && Objects.equal((Object)Float.valueOf(this.y1), (Object)Float.valueOf(((Line)other.get()).y1)) && Objects.equal((Object)Float.valueOf(this.y2), (Object)Float.valueOf(((Line)other.get()).y2));
        }
        return false;
    }

    private static final class Vector {
        final float x;
        final float y;

        static Vector create(float x, float y) {
            return new Vector(x, y);
        }

        Vector(float x, float y) {
            this.x = x;
            this.y = y;
        }

        float dot(Vector v) {
            return this.x * v.x + this.y * v.y;
        }

        Vector times(float value) {
            return Vector.create(value * this.x, value * this.y);
        }

        Vector minus(Vector v) {
            return Vector.create(this.x - v.x, this.y - v.y);
        }

        float modulus() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y);
        }

        float modulusSquared() {
            return this.x * this.x + this.y * this.y;
        }
    }
}

