/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.model;

import com.google.gson.internal.LinkedTreeMap;
import fr.proline.logparser.model.TaskInJsonCtrl;
import fr.proline.logparser.model.Utility;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTask {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)LogTask.class.getName());
    static final String ERROR_LOG = "ERROR";
    static final String WARN_LOG = "WARN ";
    private String m_messageId;
    private int m_taskOrder;
    private String m_projectId;
    private String m_threadName;
    private STATUS m_status;
    private Date m_startTime;
    private Date m_stopTime;
    private String m_callService;
    private LogLine m_startLine;
    private LogLine m_stopLine;
    private LinkedTreeMap m_paramObject;
    private ArrayList<LogLine> m_trace;
    private int m_otherTasksInRun;
    private String m_dataSet;
    private int m_nbLine;
    private boolean m_firstTraceWrite;
    private boolean m_useJSONFiles;
    private ArrayList<Long> m_timeStamp;
    private ArrayList<Integer> m_nbOtherTaskMoment;

    public void updateNbTask(long instant, int nbTask) {
        long from = instant - this.m_startTime.getTime();
        int index = this.m_nbOtherTaskMoment.size() - 1;
        if (index >= 0 && nbTask == this.m_nbOtherTaskMoment.get(index)) {
            this.m_timeStamp.remove(index);
            this.m_nbOtherTaskMoment.remove(index);
        }
        this.m_timeStamp.add(from);
        this.m_nbOtherTaskMoment.add(nbTask);
        if (this.m_otherTasksInRun < nbTask) {
            this.m_otherTasksInRun = nbTask;
        }
    }

    public int getTaskOrder() {
        return this.m_taskOrder;
    }

    public LogTask(int fileIndex, String messageId, boolean useJSONFiles) {
        this.m_messageId = messageId;
        this.m_useJSONFiles = useJSONFiles;
        this.m_trace = new ArrayList();
        this.m_otherTasksInRun = 0;
        this.m_dataSet = "";
        this.m_startLine = new LogLine(fileIndex, -1L, "");
        this.m_stopLine = new LogLine(fileIndex, -1L, "");
        this.m_taskOrder = -1;
        this.m_projectId = "";
        this.m_timeStamp = new ArrayList();
        this.m_nbOtherTaskMoment = new ArrayList();
        this.m_startTime = Calendar.getInstance().getTime();
        this.m_nbLine = 0;
        this.m_firstTraceWrite = true;
    }

    public void setTaskOrder(int order) {
        this.m_taskOrder = order;
    }

    public String getDataSet() {
        return this.m_dataSet;
    }

    public void setDataSet(String dataSet) {
        this.m_dataSet = dataSet;
    }

    public String getProjectId() {
        return this.m_projectId;
    }

    public void setProjectId(String projectId) {
        this.m_projectId = projectId;
    }

    public void addLine(int fileIndex, long index, String line, Date date, STATUS status) {
        if (status == null) {
            if (line.contains(ERROR_LOG)) {
                this.setStatus(STATUS.FAILED);
            } else if (line.contains(WARN_LOG)) {
                this.setStatus(STATUS.WARNING);
            }
        } else {
            this.setStatus(status);
        }
        if (this.m_taskOrder > 0 && date != null && !line.contains(this.m_threadName) && !line.contains("Calling")) {
            m_logger.error("XXX thread name different {}, index = {}", (Object)this, (Object)index);
        }
        LogLine ll = new LogLine(fileIndex, index, line);
        this.m_trace.add(ll);
        ++this.m_nbLine;
        if (this.m_useJSONFiles) {
            TaskInJsonCtrl.getInstance().writeTaskTrace(this, this.m_firstTraceWrite, false);
            this.m_trace = new ArrayList();
            this.m_firstTraceWrite = false;
        }
        if (date != null) {
            this.m_stopTime = date;
            this.m_stopLine = ll;
        }
    }

    public boolean isFirstWrite() {
        return this.m_firstTraceWrite;
    }

    public void emptyTrace() {
        this.m_trace = null;
    }

    LogLine removeLastLine() {
        if (this.m_trace.size() > 0) {
            --this.m_nbLine;
            return this.m_trace.remove(this.m_trace.size() - 1);
        }
        return null;
    }

    public void setStopLine(int fileIndex, long index, String line) {
        LogLine ll;
        this.m_stopLine = ll = new LogLine(fileIndex, index, line);
    }

    public ArrayList<LogLine> getTrace() {
        return this.m_trace;
    }

    public void setTrace(ArrayList<LogLine> trace) {
        this.m_trace = trace;
    }

    public int getNbLine() {
        return this.m_nbLine;
    }

    public void setStatus(STATUS status) {
        if (this.m_status == null) {
            this.m_status = status;
        } else if (status.compareTo(this.m_status) > 0) {
            this.m_status = status;
        }
    }

    public void setStartLine(int fileIndex, long index, String startLine, Date date) {
        this.m_startLine = new LogLine(fileIndex, index, startLine);
        this.m_startTime = date;
    }

    public void setThreadName(String threadName) {
        this.m_threadName = threadName;
    }

    public void setCallService(String callService) {
        this.m_callService = callService;
    }

    public void setRequestParam(LinkedTreeMap paramMap) {
        this.m_paramObject = paramMap;
    }

    public String getMessageId() {
        return this.m_messageId;
    }

    public String getThreadName() {
        return this.m_threadName;
    }

    public STATUS getStatus() {
        return this.m_status;
    }

    public Date getStopTime() {
        return this.m_stopTime;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public long getDuration() {
        return this.m_stopTime.getTime() - this.m_startTime.getTime();
    }

    public String getCallService() {
        return this.m_callService;
    }

    public JTree getParamTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.m_messageId);
        this.createParameterTree(this.m_paramObject, top, 0);
        JTree tree = new JTree(top);
        return tree;
    }

    private int createParameterTree(LinkedTreeMap params, DefaultMutableTreeNode parent, int childIndex) {
        int PARMETER_STEP_LIMIT = 9000;
        if (childIndex > 9000) {
            return childIndex;
        }
        if (params == null) {
            return childIndex;
        }
        int index = childIndex;
        DefaultMutableTreeNode root = parent;
        for (Object key : params.keySet()) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(key);
            Object value = params.get(key);
            if (value instanceof LinkedTreeMap) {
                root.add(child);
                index = this.createParameterTree((LinkedTreeMap)value, child, index++);
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList valueList = (ArrayList)value;
                if (!valueList.isEmpty() && valueList.get(0) instanceof LinkedTreeMap) {
                    root.add(child);
                    for (Object item : valueList) {
                        index = this.createParameterTree((LinkedTreeMap)item, child, index++);
                    }
                    continue;
                }
                String node = child + ":  " + value;
                root.add(new DefaultMutableTreeNode(node));
                continue;
            }
            String node = child + ":  " + value;
            root.add(new DefaultMutableTreeNode(node));
        }
        return index;
    }

    public int getNbParallelTask() {
        return this.m_otherTasksInRun;
    }

    public void setNbOtherTasksInRun(int nb) {
        this.m_otherTasksInRun = nb;
    }

    public ArrayList<Long> getTimeStamp() {
        return this.m_timeStamp;
    }

    public ArrayList<Integer> getNbOtherTaskMoment() {
        return this.m_nbOtherTaskMoment;
    }

    public LogLine getStartLine() {
        return this.m_startLine;
    }

    public LogLine getStopLine() {
        return this.m_stopLine;
    }

    public String getStartInfo() {
        String time = Utility.formatTime(this.m_startTime);
        String projectId = this.m_projectId.length() > 0 ? "project_id:" + this.m_projectId + ", " : "";
        String result = time + "[" + this.m_taskOrder + "]" + this.m_callService + " start (" + projectId + this.m_dataSet + " ID:" + this.m_messageId + ")";
        return result;
    }

    public String getStopInfo() {
        String time = Utility.formatTime(this.m_stopTime);
        String projectId = this.m_projectId.length() > 1 ? "project_id:" + this.m_projectId + " " : "";
        String result = time + "[" + this.m_taskOrder + "]" + this.m_callService + " end (ID:" + this.m_messageId + ")";
        return result;
    }

    public String toString() {
        return "LogTask{m_messageId=" + this.m_messageId + ", m_threadName=" + this.m_threadName + ", m_status=" + (Object)((Object)this.m_status) + ", m_taskOrder=" + this.m_taskOrder + ", m_nbLine=" + this.m_nbLine + '}';
    }

    public class LogLine {
        public long index;
        public String line;
        public int fileIndex;

        public LogLine(int fIndex, long index, String line) {
            this.fileIndex = fIndex;
            this.index = index;
            this.line = line;
        }

        public String toString() {
            if (this.fileIndex == -1) {
                return "[" + this.index + "]" + this.line;
            }
            return "[" + this.fileIndex + "." + this.index + "]" + this.line;
        }
    }

    public static enum STATUS {
        RUNNING(0, "RUNNING"),
        FINISHED(1, "FINISHED"),
        WARNING(2, "<html><font color=\"orange\">WARNING</font></html>"),
        FINISHED_WARN(3, "<html><font color=\"orange\">WARNING</font></html>"),
        FAILED(4, "<html><font color=\"red\">FAILED</font></html>");

        private String _labelTxt;
        private int _index;

        private STATUS(int index, String txt) {
            this._index = index;
            this._labelTxt = txt;
        }

        public String getLabelTxt() {
            return this._labelTxt;
        }

        public int getIndex() {
            return this._index;
        }
    }
}

