/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.model;

import fr.proline.logparser.model.TaskInJsonCtrl;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utility {
    static SimpleDateFormat sf = new SimpleDateFormat("HH:mm:ss.SSS");
    static SimpleDateFormat m_timestampFormat = new SimpleDateFormat("HH:mm:ss.SSS - dd MMM yyyy ");
    static final DecimalFormat m_decimalFormat = new DecimalFormat("####0.000");
    public static final File WORKING_DIRECTORY = new File(".").getAbsoluteFile();
    public static final File WORKING_DATA_DIRECTORY = new File(WORKING_DIRECTORY + "/parseServerLogData");

    public static void init() {
        if (!WORKING_DATA_DIRECTORY.isDirectory()) {
            boolean b = WORKING_DATA_DIRECTORY.mkdir();
            TaskInJsonCtrl.m_logger.info("create folder {} successful ={}", (Object)WORKING_DATA_DIRECTORY.getAbsolutePath(), (Object)b);
        }
    }

    public static String formatTime(Date timestamp) {
        if (timestamp == null) {
            return "N/A";
        }
        return m_timestampFormat.format(timestamp);
    }

    public static Date parseTime(String time) {
        if (time.equals("N/A")) {
            return null;
        }
        try {
            return m_timestampFormat.parse(time);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static String formatDeltaTime(long delta) {
        if (delta == -1L) {
            return "";
        }
        double deltaSeconds = (double)delta / 1000.0;
        return "+" + m_decimalFormat.format(deltaSeconds) + " s";
    }

    public static String formatDurationInHour(long duration) {
        int second = 1000;
        int minute = 60000;
        int hour = 3600000;
        String time = String.format("%d:%02d:%02d.%03d", duration / (long)hour, duration % (long)hour / (long)minute, duration % (long)minute / (long)second, duration % (long)second);
        return time;
    }

    public static String getMemory() {
        long MEGABYTE = 0x100000L;
        MemoryUsage heapUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long maxMemory = heapUsage.getMax() / MEGABYTE;
        long usedMemory = heapUsage.getUsed() / MEGABYTE;
        return " : Memory Use :" + usedMemory + "M/" + maxMemory + "M";
    }

    public static enum DATE_FORMAT {
        NORMAL,
        SHORT;

    }
}

