/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.ILongBuffer;
import java.util.ArrayList;

public class FastLongBuffer
implements ILongBuffer {
    private ArrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    private int size;
    private int exp;
    private int r;

    public FastLongBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new ArrayList();
    }

    public FastLongBuffer(int e) {
        if (e <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << e;
        this.exp = e;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new ArrayList();
    }

    public FastLongBuffer(int e, int c) {
        if (e <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << e;
        this.exp = e;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new ArrayList(c);
    }

    public void append(long[] long_array) {
        int lastBufferIndex;
        long[] lastBuffer;
        if (long_array == null) {
            throw new NullPointerException();
        }
        if (this.bufferArrayList.size() == 0) {
            lastBuffer = new long[this.pageSize];
            this.bufferArrayList.add(lastBuffer);
            lastBufferIndex = 0;
            this.capacity = this.pageSize;
        } else {
            lastBufferIndex = Math.min(this.size >> this.exp, this.bufferArrayList.size() - 1);
            lastBuffer = (long[])this.bufferArrayList.get(lastBufferIndex);
        }
        if (this.size + long_array.length < this.capacity) {
            if (this.size + long_array.length < lastBufferIndex + 1 << this.exp) {
                System.arraycopy(long_array, 0, lastBuffer, this.size & this.r, long_array.length);
            } else {
                int z;
                int offset = this.pageSize - (this.size & this.r);
                System.arraycopy(long_array, 0, lastBuffer, this.size & this.r, offset);
                int l = long_array.length - offset;
                int k = l >> this.exp;
                for (z = 1; z <= k; ++z) {
                    System.arraycopy(long_array, offset, (long[])this.bufferArrayList.get(lastBufferIndex + z), 0, this.pageSize);
                    offset += this.pageSize;
                }
                System.arraycopy(long_array, offset, (long[])this.bufferArrayList.get(lastBufferIndex + z), 0, l & this.r);
            }
            this.size += long_array.length;
            return;
        }
        int n = (long_array.length + this.size >> this.exp) + ((long_array.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(long_array, 0, lastBuffer, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n; ++i) {
            long[] newBuffer = new long[this.pageSize];
            if (i < n - 1) {
                System.arraycopy(long_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, this.pageSize);
            } else {
                System.arraycopy(long_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, long_array.length + this.size - this.pageSize * i - this.capacity);
            }
            this.bufferArrayList.add(newBuffer);
        }
        this.size += long_array.length;
        this.capacity += n * this.pageSize;
    }

    public void append(long i) {
        long[] lastBuffer;
        if (this.bufferArrayList.size() == 0) {
            lastBuffer = new long[this.pageSize];
            this.bufferArrayList.add(lastBuffer);
            this.capacity = this.pageSize;
        } else {
            int lastBufferIndex = Math.min(this.size >> this.exp, this.bufferArrayList.size() - 1);
            lastBuffer = (long[])this.bufferArrayList.get(lastBufferIndex);
        }
        if (this.size < this.capacity) {
            lastBuffer[this.size & this.r] = i;
            ++this.size;
        } else {
            long[] newBuffer = new long[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(newBuffer);
            newBuffer[0] = i;
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long[] getLongArray(int startingOffset, int len) {
        if (this.size <= 0 || startingOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (startingOffset + len > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        long[] result = new long[len];
        int first_index = startingOffset >> this.exp;
        int last_index = startingOffset + len >> this.exp;
        if ((startingOffset + len & this.r) == 0) {
            --last_index;
        }
        if (first_index == last_index) {
            System.arraycopy((long[])this.bufferArrayList.get(first_index), startingOffset & this.r, result, 0, len);
        } else {
            int long_array_offset = 0;
            for (int i = first_index; i <= last_index; ++i) {
                long[] currentChunk = (long[])this.bufferArrayList.get(i);
                if (i == first_index) {
                    System.arraycopy(currentChunk, startingOffset & this.r, result, 0, this.pageSize - (startingOffset & this.r));
                    long_array_offset += this.pageSize - (startingOffset & this.r);
                    continue;
                }
                if (i == last_index) {
                    System.arraycopy(currentChunk, 0, result, long_array_offset, len - long_array_offset);
                    continue;
                }
                System.arraycopy(currentChunk, 0, result, long_array_offset, this.pageSize);
                long_array_offset += this.pageSize;
            }
        }
        return result;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long longAt(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int pageNum = index >> this.exp;
        int offset = index & this.r;
        return ((long[])this.bufferArrayList.get(pageNum))[offset];
    }

    public int lower32At(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int pageNum = index >> this.exp;
        int offset = index & this.r;
        return (int)((long[])this.bufferArrayList.get(pageNum))[offset];
    }

    public void modifyEntry(int index, long newValue) {
        if (index < 0 || index > this.size + 1) {
            throw new IndexOutOfBoundsException();
        }
        ((long[])this.bufferArrayList.get((int)(index >> this.exp)))[index & this.r] = newValue;
    }

    public int size() {
        return this.size;
    }

    public long[] toLongArray() {
        if (this.size > 0) {
            int s = this.size;
            long[] resultArray = new long[this.size];
            int array_offset = 0;
            int i = 0;
            while (s > 0) {
                System.arraycopy((long[])this.bufferArrayList.get(i), 0, resultArray, array_offset, s < this.pageSize ? s : this.pageSize);
                s -= this.pageSize;
                array_offset += this.pageSize;
                ++i;
            }
            return resultArray;
        }
        return null;
    }

    public int upper32At(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int pageNum = index >> this.exp;
        int offset = index & this.r;
        return (int)((((long[])this.bufferArrayList.get(pageNum))[offset] & 0xFFFFFFFF00000000L) >> 32);
    }

    public void clear() {
        this.size = 0;
    }
}

