/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.proline.core.orm.msi.Enzyme;
import fr.proline.core.orm.msi.InstrumentConfig;
import fr.proline.core.orm.msi.SearchSettingsSeqDatabaseMap;
import fr.proline.core.orm.msi.UsedPtm;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="search_settings")
public class SearchSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="is_decoy")
    private boolean isDecoy;
    @Column(name="max_missed_cleavages")
    private Integer maxMissedCleavages;
    @Column(name="peptide_charge_states")
    private String peptideChargeStates;
    @Column(name="peptide_mass_error_tolerance")
    private Double peptideMassErrorTolerance;
    @Column(name="peptide_mass_error_tolerance_unit")
    private String peptideMassErrorToleranceUnit;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="software_name")
    private String softwareName;
    @Column(name="software_version")
    private String softwareVersion;
    @Column(name="fragmentation_rule_set_id")
    private Long fragmentationRuleSetId;
    private String taxonomy;
    @ManyToOne
    @JoinColumn(name="instrument_config_id")
    private InstrumentConfig instrumentConfig;
    @OneToMany(mappedBy="searchSetting")
    private Set<SearchSettingsSeqDatabaseMap> searchSettingsSeqDatabaseMaps;
    @ManyToMany
    @JoinTable(name="used_enzyme", joinColumns={@JoinColumn(name="search_settings_id")}, inverseJoinColumns={@JoinColumn(name="enzyme_id")})
    private Set<Enzyme> enzymes;
    @OneToMany(mappedBy="searchSetting")
    private Set<UsedPtm> usedPtms;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public boolean getIsDecoy() {
        return this.isDecoy;
    }

    public void setIsDecoy(boolean pIsDecoy) {
        this.isDecoy = pIsDecoy;
    }

    public Integer getMaxMissedCleavages() {
        return this.maxMissedCleavages;
    }

    public void setMaxMissedCleavages(Integer maxMissedCleavages) {
        this.maxMissedCleavages = maxMissedCleavages;
    }

    public String getPeptideChargeStates() {
        return this.peptideChargeStates;
    }

    public void setPeptideChargeStates(String peptideChargeStates) {
        this.peptideChargeStates = peptideChargeStates;
    }

    public Long getFragmentationRuleSetId() {
        return this.fragmentationRuleSetId;
    }

    public void setFragmentationRuleSetId(Long fragmentationRuleSetId) {
        this.fragmentationRuleSetId = fragmentationRuleSetId;
    }

    public Double getPeptideMassErrorTolerance() {
        return this.peptideMassErrorTolerance;
    }

    public void setPeptideMassErrorTolerance(Double pPeptideMassErrorTolerance) {
        this.peptideMassErrorTolerance = pPeptideMassErrorTolerance;
    }

    public String getPeptideMassErrorToleranceUnit() {
        return this.peptideMassErrorToleranceUnit;
    }

    public void setPeptideMassErrorToleranceUnit(String peptideMassErrorToleranceUnit) {
        this.peptideMassErrorToleranceUnit = peptideMassErrorToleranceUnit;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public String getSoftwareName() {
        return this.softwareName;
    }

    public void setSoftwareName(String softwareName) {
        this.softwareName = softwareName;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public void setTaxonomy(String taxonomy) {
        this.taxonomy = taxonomy;
    }

    public InstrumentConfig getInstrumentConfig() {
        return this.instrumentConfig;
    }

    public void setInstrumentConfig(InstrumentConfig instrumentConfig) {
        this.instrumentConfig = instrumentConfig;
    }

    public Set<SearchSettingsSeqDatabaseMap> getSearchSettingsSeqDatabaseMaps() {
        return this.searchSettingsSeqDatabaseMaps;
    }

    public void setSearchSettingsSeqDatabaseMaps(Set<SearchSettingsSeqDatabaseMap> pSearchSettingsSeqDatabaseMaps) {
        this.searchSettingsSeqDatabaseMaps = pSearchSettingsSeqDatabaseMaps;
    }

    public void addSearchSettingsSeqDatabaseMap(SearchSettingsSeqDatabaseMap searchSettingsSeqDatabase) {
        if (searchSettingsSeqDatabase != null) {
            Set<SearchSettingsSeqDatabaseMap> seqDatabaseMaps = this.getSearchSettingsSeqDatabaseMaps();
            if (seqDatabaseMaps == null) {
                seqDatabaseMaps = new HashSet<SearchSettingsSeqDatabaseMap>();
                this.setSearchSettingsSeqDatabaseMaps(seqDatabaseMaps);
            }
            seqDatabaseMaps.add(searchSettingsSeqDatabase);
        }
    }

    public void removeSearchSettingsSeqDatabaseMap(SearchSettingsSeqDatabaseMap searchSettingsSeqDatabase) {
        Set<SearchSettingsSeqDatabaseMap> seqDatabaseMaps = this.getSearchSettingsSeqDatabaseMaps();
        if (seqDatabaseMaps != null) {
            seqDatabaseMaps.remove(searchSettingsSeqDatabase);
        }
    }

    public Set<Enzyme> getEnzymes() {
        return this.enzymes;
    }

    public void setEnzymes(Set<Enzyme> pEnzymes) {
        this.enzymes = pEnzymes;
    }

    public void addEnzyme(Enzyme enzyme) {
        if (enzyme != null) {
            Set<Enzyme> localEnzymes = this.getEnzymes();
            if (localEnzymes == null) {
                localEnzymes = new HashSet<Enzyme>();
                this.setEnzymes(localEnzymes);
            }
            localEnzymes.add(enzyme);
        }
    }

    public void removeEnzyme(Enzyme enzyme) {
        Set<Enzyme> localEnzymes = this.getEnzymes();
        if (localEnzymes != null) {
            localEnzymes.remove(enzyme);
        }
    }

    public Set<UsedPtm> getUsedPtms() {
        return this.usedPtms;
    }

    public void setUsedPtms(Set<UsedPtm> pUsedPtms) {
        this.usedPtms = pUsedPtms;
    }

    public void addUsedPtms(UsedPtm usedPtm) {
        if (usedPtm != null) {
            Set<UsedPtm> localUsedPtms = this.getUsedPtms();
            if (localUsedPtms == null) {
                localUsedPtms = new HashSet<UsedPtm>();
                this.setUsedPtms(localUsedPtms);
            }
            localUsedPtms.add(usedPtm);
        }
    }

    public void removeUsedPtms(UsedPtm usedPtm) {
        Set<UsedPtm> localUsedPtms = this.getUsedPtms();
        if (localUsedPtms != null) {
            localUsedPtms.remove(usedPtm);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.getId()).append("taxonomy", (Object)this.getTaxonomy()).append("miss cleav.", (Object)this.getMaxMissedCleavages()).append("mass error", (Object)this.getPeptideMassErrorTolerance()).toString();
    }

    public static enum SoftwareName {
        MASCOT,
        OMSSA;

    }
}

