/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DPeptideInstance {
    private long m_id = -1L;
    private long m_peptideId = -1L;
    private int m_validatedProteinSetCount = 0;
    private Float m_elutionTime = Float.valueOf(0.0f);
    private Peptide m_peptide;
    private DPeptideMatch m_bestPeptideMatch;
    private ResultSummary resultSummary;
    private List<DPeptideMatch> m_peptideMatches;
    private Map<String, Object> m_properties = null;

    public DPeptideInstance(PeptideInstance peptideInstance) throws IOException {
        if (peptideInstance != null) {
            this.m_id = peptideInstance.getId();
            this.m_validatedProteinSetCount = peptideInstance.getValidatedProteinSetCount();
            this.m_elutionTime = peptideInstance.getElutionTime();
            this.m_peptideId = peptideInstance.getPeptide().getId();
            this.m_properties = peptideInstance.getSerializedProperties() != null ? (Map)JsonSerializer.getMapper().readValue(peptideInstance.getSerializedProperties(), Map.class) : null;
        }
        this.m_bestPeptideMatch = null;
        this.m_peptide = null;
    }

    public long getId() {
        return this.m_id;
    }

    public long getPeptideId() {
        return this.m_peptideId;
    }

    public void setPeptide(Peptide p) {
        this.m_peptide = p;
    }

    public Peptide getPeptide() {
        return this.m_peptide;
    }

    public int getValidatedProteinSetCount() {
        return this.m_validatedProteinSetCount;
    }

    public Float getElutionTime() {
        return this.m_elutionTime;
    }

    public void setElutionTime(Float elutionTime) {
        this.m_elutionTime = elutionTime;
    }

    public DPeptideMatch getBestPeptideMatch() {
        return this.m_bestPeptideMatch;
    }

    public void setBestPeptideMatch(DPeptideMatch bestPeptideMatch) {
        this.m_bestPeptideMatch = bestPeptideMatch;
    }

    public ResultSummary getResultSummary() {
        return this.resultSummary;
    }

    public void setResultSummary(ResultSummary resultSummary) {
        this.resultSummary = resultSummary;
    }

    public List<DPeptideMatch> getPeptideMatches() {
        return this.m_peptideMatches;
    }

    public void setPeptideMatches(List<DPeptideMatch> m_peptideMatches) {
        this.m_peptideMatches = m_peptideMatches;
    }

    public Map<String, Object> getProperties() {
        return this.m_properties;
    }
}

