/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.SeqDatabase;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class MsiSeqDatabaseRepository {
    private MsiSeqDatabaseRepository() {
    }

    public static SeqDatabase findSeqDatabaseForNameAndFastaAndVersion(EntityManager msiEm, String name, String fastaFilePath) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        if (StringUtils.isEmpty((String)fastaFilePath)) {
            throw new IllegalArgumentException("Invalid fastaFilePath");
        }
        SeqDatabase result = null;
        TypedQuery query = msiEm.createNamedQuery("findMsiSeqDatabaseForNameAndFasta", SeqDatabase.class);
        query.setParameter("name", (Object)name);
        query.setParameter("fastaFilePath", (Object)fastaFilePath);
        List seqDatabases = query.getResultList();
        if (seqDatabases != null && !seqDatabases.isEmpty()) {
            if (seqDatabases.size() == 1) {
                result = (SeqDatabase)seqDatabases.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one SeqDatabases for given name and fastaFilePath");
            }
        }
        return result;
    }

    public static List<Long> findSeqDatabaseIdsForProteinMatch(EntityManager msiEm, long proteinMatchId) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        TypedQuery query = msiEm.createQuery("select map.id.seqDatabaseId from fr.proline.core.orm.msi.ProteinMatchSeqDatabaseMap map where map.id.proteinMatchId = :proteinMatchId", Long.class);
        query.setParameter("proteinMatchId", (Object)proteinMatchId);
        return query.getResultList();
    }
}

