/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.repository;

import fr.proline.core.orm.msi.ObjectTreeSchema;
import fr.proline.repository.util.JPAUtils;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectTreeSchemaRepository {
    private static Logger logger = LoggerFactory.getLogger(ObjectTreeSchemaRepository.class);

    private ObjectTreeSchemaRepository() {
    }

    public static ObjectTreeSchema loadOrCreateObjectTreeSchema(EntityManager msiEm, String schemaName) {
        JPAUtils.checkEntityManager((EntityManager)msiEm);
        ObjectTreeSchema objTreeSchema = (ObjectTreeSchema)msiEm.find(ObjectTreeSchema.class, (Object)schemaName);
        if (objTreeSchema == null) {
            logger.warn("Schema " + schemaName + " has not been find in the UDSdb");
            objTreeSchema = new ObjectTreeSchema();
            objTreeSchema.setName(schemaName);
            objTreeSchema.setType("JSON");
            objTreeSchema.setVersion("0.1");
            objTreeSchema.setSchema("");
        }
        return objTreeSchema;
    }
}

