/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.repository;

import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.core.orm.uds.Project;
import fr.proline.repository.ProlineDatabaseType;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class ExternalDbRepository {
    private ExternalDbRepository() {
    }

    public static ExternalDb findExternalByType(EntityManager udsEm, ProlineDatabaseType dbType) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        if (dbType == null) {
            throw new IllegalArgumentException("DbType is null");
        }
        ExternalDb result = null;
        TypedQuery query = udsEm.createNamedQuery("findExternalDbByType", ExternalDb.class);
        query.setParameter("type", (Object)dbType);
        List externalDbs = query.getResultList();
        if (externalDbs != null && !externalDbs.isEmpty()) {
            if (externalDbs.size() == 1) {
                result = (ExternalDb)externalDbs.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one ExternalDb for given dbType");
            }
        }
        return result;
    }

    public static ExternalDb findExternalByTypeAndProject(EntityManager udsEm, ProlineDatabaseType dbType, Project project) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        if (dbType == null) {
            throw new IllegalArgumentException("DbType is null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Project is null");
        }
        ExternalDb result = null;
        TypedQuery query = udsEm.createNamedQuery("findExternalDbByTypeAndProject", ExternalDb.class);
        query.setParameter("type", (Object)dbType);
        query.setParameter("project", (Object)project);
        List externalDbs = query.getResultList();
        if (externalDbs != null && !externalDbs.isEmpty()) {
            if (externalDbs.size() == 1) {
                result = (ExternalDb)externalDbs.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one ExternalDb for given dbType and project");
            }
        }
        return result;
    }
}

