/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.util;

import fr.proline.core.orm.uds.repository.ProjectRepository;
import fr.proline.repository.DatabaseUpgrader;
import fr.proline.repository.IDataStoreConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataStoreUpgrader {
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreUpgrader.class);

    private DataStoreUpgrader() {
    }

    public static boolean upgradeAllDatabases(IDataStoreConnectorFactory connectorFactory, boolean repairChecksum) {
        if (connectorFactory == null || !connectorFactory.isInitialized()) {
            throw new IllegalArgumentException("Invalid connectorFactory");
        }
        boolean result = true;
        IDatabaseConnector udsDbConnector = connectorFactory.getUdsDbConnector();
        if (udsDbConnector == null) {
            LOG.warn("DataStoreConnectorFactory has no valid UDS Db connector");
        } else {
            int udsDbMigrationCount = DatabaseUpgrader.upgradeDatabase((IDatabaseConnector)udsDbConnector, (boolean)repairChecksum);
            if (udsDbMigrationCount < 0) {
                result = false;
                LOG.warn("Unable to upgrade UDS Db");
            } else {
                LOG.info("UDS Db :" + udsDbMigrationCount + " migration done.");
            }
        }
        if (udsDbConnector != null) {
            List<Long> projectIds = DataStoreUpgrader.retrieveProjectIds(udsDbConnector);
            if (projectIds != null && !projectIds.isEmpty()) {
                for (Long projectId : projectIds) {
                    LOG.debug("Upgrading databases of Project #{}", (Object)projectId);
                    IDatabaseConnector msiDbConnector = connectorFactory.getMsiDbConnector(projectId.longValue());
                    if (msiDbConnector == null) {
                        LOG.warn("DataStoreConnectorFactory has no valid MSI Db connector for Project #{}", (Object)projectId);
                    } else {
                        int msiDbMigrationCount = DatabaseUpgrader.upgradeDatabase((IDatabaseConnector)msiDbConnector, (boolean)repairChecksum);
                        if (msiDbMigrationCount < 0) {
                            result = false;
                            LOG.warn("Unable to upgrade MSI Db of project #{}", (Object)projectId);
                        } else {
                            LOG.info("MSI Db for project " + projectId + " : " + msiDbMigrationCount + " migration done.");
                        }
                        msiDbConnector.close();
                    }
                    IDatabaseConnector lcMsDbConnector = connectorFactory.getLcMsDbConnector(projectId.longValue());
                    if (lcMsDbConnector == null) {
                        LOG.warn("DataStoreConnectorFactory has no valid LCMS Db connector for Project #{}", (Object)projectId);
                        continue;
                    }
                    int lcMsDbMigrationCount = DatabaseUpgrader.upgradeDatabase((IDatabaseConnector)lcMsDbConnector, (boolean)repairChecksum);
                    if (lcMsDbMigrationCount < 0) {
                        result = false;
                        LOG.warn("Unable to upgrade LCMS Db of Project #{}", (Object)projectId);
                    } else {
                        LOG.info("LCMS Db for project " + projectId + " : " + lcMsDbMigrationCount + " migration done.");
                    }
                    lcMsDbConnector.close();
                }
            }
            udsDbConnector.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Long> retrieveProjectIds(IDatabaseConnector udsDbConnector) {
        List<Long> projectIds = null;
        EntityManager udsDbEm = udsDbConnector.createEntityManager();
        try {
            projectIds = ProjectRepository.findAllProjectIds(udsDbEm);
        }
        finally {
            if (udsDbEm != null) {
                try {
                    udsDbEm.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing UDS Db EntityManager", (Throwable)exClose);
                }
            }
        }
        return projectIds;
    }
}

