/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.context;

import fr.proline.context.DatabaseConnectionContext;
import fr.proline.context.IExecutionContext;
import fr.proline.context.LcMsDbConnectionContext;
import fr.proline.context.MsiDbConnectionContext;
import fr.proline.context.UdsDbConnectionContext;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutionContext
implements IExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(BasicExecutionContext.class);
    private final long m_projectId;
    private final UdsDbConnectionContext m_udsDb;
    private final MsiDbConnectionContext m_msiDb;
    private final LcMsDbConnectionContext m_lcMsDb;

    public BasicExecutionContext(long projectId, UdsDbConnectionContext udsDb, MsiDbConnectionContext msiDb, LcMsDbConnectionContext lcMsDb) {
        this.m_projectId = projectId;
        if (udsDb == null) {
            LOG.info("UDS DatabaseConnectionContext is null");
        }
        this.m_udsDb = udsDb;
        if (msiDb == null) {
            LOG.info("MSI DatabaseConnectionContext is null");
        }
        this.m_msiDb = msiDb;
        if (lcMsDb == null) {
            LOG.info("LCMS DatabaseConnectionContext is null");
        }
        this.m_lcMsDb = lcMsDb;
    }

    @Override
    public long getProjectId() {
        return this.m_projectId;
    }

    @Override
    public UdsDbConnectionContext getUDSDbConnectionContext() {
        return this.m_udsDb;
    }

    @Override
    public MsiDbConnectionContext getMSIDbConnectionContext() {
        return this.m_msiDb;
    }

    @Override
    public LcMsDbConnectionContext getLCMSDbConnectionContext() {
        return this.m_lcMsDb;
    }

    @Override
    public boolean isJPA() {
        List<DatabaseConnectionContext> contexts = Arrays.asList(this.getUDSDbConnectionContext(), this.getMSIDbConnectionContext(), this.getLCMSDbConnectionContext());
        return BasicExecutionContext.isAllJPA(contexts);
    }

    @Override
    public void closeAll() {
        if (this.m_lcMsDb != null) {
            this.m_lcMsDb.close();
        }
        if (this.m_msiDb != null) {
            this.m_msiDb.close();
        }
        if (this.m_udsDb != null) {
            this.m_udsDb.close();
        }
    }

    private static boolean isAllJPA(List<DatabaseConnectionContext> contexts) {
        boolean result = false;
        for (DatabaseConnectionContext dbContext : contexts) {
            if (dbContext == null) continue;
            if (dbContext.isJPA()) {
                result = true;
                continue;
            }
            result = false;
            break;
        }
        return result;
    }
}

