/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository;

import fr.profi.util.PropertiesUtils;
import fr.proline.repository.AbstractDatabaseConnector;
import fr.proline.repository.DriverType;
import fr.proline.repository.ProlineDatabaseType;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DatabaseConnector
extends AbstractDatabaseConnector {
    private static final Logger LOG = LoggerFactory.getLogger(H2DatabaseConnector.class);
    private static final String MEMORY_URL_PROTOCOL = ":mem:";

    public H2DatabaseConnector(ProlineDatabaseType database, Map<Object, Object> properties) {
        super(database, properties);
    }

    @Override
    public DriverType getDriverType() {
        return DriverType.H2;
    }

    @Override
    protected boolean isMemory(Map<Object, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        boolean result = false;
        String databaseURL = PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url");
        if (databaseURL != null) {
            result = databaseURL.toLowerCase().contains(MEMORY_URL_PROTOCOL);
        }
        return result;
    }

    @Override
    protected EntityManagerFactory createEntityManagerFactory(ProlineDatabaseType database, Map<Object, Object> properties, boolean ormOptimizations) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        if (properties.get("hibernate.dialect") == null) {
            properties.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        }
        return super.createEntityManagerFactory(database, properties, ormOptimizations);
    }

    @Override
    protected DataSource createDataSource(String ident, Map<Object, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        JdbcConnectionPool source = JdbcConnectionPool.create((String)PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url"), (String)PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.user"), (String)PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.password"));
        source.setMaxConnections(20);
        return source;
    }

    @Override
    public int getOpenConnectionCount() {
        if (this.m_dataSource instanceof JdbcConnectionPool) {
            JdbcConnectionPool h2Source = (JdbcConnectionPool)this.m_dataSource;
            return h2Source.getActiveConnections();
        }
        return 0;
    }

    @Override
    protected void doClose(String ident, DataSource source) {
        if (source instanceof JdbcConnectionPool) {
            LOG.debug("Disposing H2 JdbcConnectionPool for [{}]", (Object)ident);
            JdbcConnectionPool h2Source = (JdbcConnectionPool)source;
            try {
                h2Source.dispose();
            }
            catch (Exception exClose) {
                LOG.error("Error disposing H2 JdbcConnectionPool for [" + ident + ']', (Throwable)exClose);
            }
            int remainingH2ConnectionsCount = h2Source.getActiveConnections();
            if (remainingH2ConnectionsCount > 0) {
                LOG.debug("Remaining H2 Connections for [{}]: {}", (Object)ident, (Object)remainingH2ConnectionsCount);
            }
        }
    }
}

