/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository.migration.msi;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.flywaydb.core.api.migration.jdbc.JdbcMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V0_10__RSxMergeType
implements JdbcMigration {
    private static final Logger LOG = LoggerFactory.getLogger(V0_10__RSxMergeType.class);

    public void migrate(Connection msiConn) throws Exception {
        Statement statement = msiConn.createStatement();
        PreparedStatement countPepStmnt = msiConn.prepareStatement("select count(distinct peptide_match.peptide_id) from peptide_match where peptide_match.result_set_id = ? ");
        PreparedStatement countPepMatchStmnt = msiConn.prepareStatement("select count(id) from peptide_match where peptide_match.result_set_id = ? ");
        PreparedStatement countPepInstanceStmnt = msiConn.prepareStatement("select count(id) from peptide_instance where result_summary_id = ? ");
        PreparedStatement countPepInstPepMatchStmnt = msiConn.prepareStatement("select sum(peptide_match_count) from peptide_instance where result_summary_id = ? ");
        PreparedStatement updateResultSetPropsStmt = msiConn.prepareStatement("UPDATE result_set SET serialized_properties=? WHERE id=?");
        PreparedStatement updateResultSummaryPropsStmt = msiConn.prepareStatement("UPDATE result_summary SET serialized_properties=? WHERE id=?");
        JsonParser jsonParser = new JsonParser();
        ResultSet rs = statement.executeQuery("SELECT id, serialized_properties from result_set where type like '%USER' and merged_rsm_id is null");
        while (rs.next()) {
            Long rsId = rs.getLong(1);
            String prop = rs.getString(2);
            countPepStmnt.setLong(1, rsId);
            ResultSet countPepRs = countPepStmnt.executeQuery();
            countPepMatchStmnt.setLong(1, rsId);
            ResultSet countPepMatchRs = countPepMatchStmnt.executeQuery();
            if (countPepRs.next() && countPepMatchRs.next()) {
                JsonObject propsAsJson;
                try {
                    propsAsJson = jsonParser.parse(prop).getAsJsonObject();
                }
                catch (Exception e) {
                    LOG.info("Error while trying to parse to 'result set' properties. May be null, assume empty");
                    propsAsJson = jsonParser.parse("{}").getAsJsonObject();
                }
                int pepCount = countPepRs.getInt(1);
                int pepMatchCount = countPepMatchRs.getInt(1);
                if (pepCount == pepMatchCount) {
                    propsAsJson.addProperty("merge_mode", "aggregation");
                } else {
                    propsAsJson.addProperty("merge_mode", "union");
                }
                updateResultSetPropsStmt.setString(1, propsAsJson.toString());
                updateResultSetPropsStmt.setLong(2, rsId);
                updateResultSetPropsStmt.executeUpdate();
                continue;
            }
            LOG.warn("Unable to get peptide count for RS " + rsId);
        }
        ResultSet rsms = statement.executeQuery("SELECT result_summary.id, result_summary.serialized_properties from result_set inner join result_summary on result_set.merged_rsm_id = result_summary.id");
        while (rsms.next()) {
            Long rsmId = rsms.getLong(1);
            String prop = rsms.getString(2);
            countPepInstanceStmnt.setLong(1, rsmId);
            ResultSet countPepRs = countPepInstanceStmnt.executeQuery();
            countPepInstPepMatchStmnt.setLong(1, rsmId);
            ResultSet countPepMatchRs = countPepInstPepMatchStmnt.executeQuery();
            if (countPepRs.next() && countPepMatchRs.next()) {
                JsonObject propsAsJson;
                try {
                    propsAsJson = jsonParser.parse(prop).getAsJsonObject();
                }
                catch (Exception e) {
                    LOG.error("Error while trying to parse to 'result set' properties");
                    propsAsJson = jsonParser.parse("{}").getAsJsonObject();
                }
                int pepCount = countPepRs.getInt(1);
                int pepMatchCount = countPepMatchRs.getInt(1);
                if (pepCount == pepMatchCount) {
                    propsAsJson.addProperty("merge_mode", "aggregation");
                } else {
                    propsAsJson.addProperty("merge_mode", "union");
                }
                updateResultSummaryPropsStmt.setString(1, propsAsJson.toString());
                updateResultSummaryPropsStmt.setLong(2, rsmId);
                updateResultSummaryPropsStmt.executeUpdate();
                continue;
            }
            LOG.warn("Unable to get peptide count for RSM " + rsmId);
        }
    }
}

