/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.inf.sape.hac.dendrogram;

import ch.usi.inf.sape.hac.dendrogram.DendrogramNode;
import ch.usi.inf.sape.hac.dendrogram.MergeNode;
import ch.usi.inf.sape.hac.dendrogram.ObservationNode;

public final class Dendrogram {
    private final DendrogramNode root;

    public Dendrogram(DendrogramNode root) {
        this.root = root;
    }

    public DendrogramNode getRoot() {
        return this.root;
    }

    public void dump() {
        this.dumpNode("  ", this.root);
    }

    private void dumpNode(String indent, DendrogramNode node) {
        if (node == null) {
            System.out.println(String.valueOf(indent) + "<null>");
        } else if (node instanceof ObservationNode) {
            System.out.println(String.valueOf(indent) + "Observation: " + node);
        } else if (node instanceof MergeNode) {
            System.out.println(String.valueOf(indent) + "Merge:");
            this.dumpNode(String.valueOf(indent) + "  ", ((MergeNode)node).getLeft());
            this.dumpNode(String.valueOf(indent) + "  ", ((MergeNode)node).getRight());
        }
    }
}

