/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.corewrapper.util;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DPeptideMatch;

public class PeptideClassesUtils {
    public static final double PROTON_MASS = 1.007276466812;
    public static final double PEPTIDE_ISOTOPE_SHIFT = 1.00335;
    static final double EXP_CSTE = StrictMath.pow(10.0, 6.0);

    public static Float getPPMFor(DPeptideMatch pepMatch, Peptide peptide) {
        double deltaMoz = pepMatch.getDeltaMoz().floatValue();
        double calculatedMass = peptide.getCalculatedMass();
        double charge = pepMatch.getCharge();
        float ppm = (float)(deltaMoz * EXP_CSTE / ((calculatedMass + 1.00335 * (double)pepMatch.getIsotopeOffset().intValue() + charge * 1.007276466812) / charge));
        if (calculatedMass >= -1.0E-10 && calculatedMass <= 1.0E-10) {
            ppm = 0.0f;
        }
        return Float.valueOf(ppm);
    }

    public static Float getDeltaMozFor(double expMoz, double charge, Peptide peptide) {
        double calculatedMass = peptide.getCalculatedMass();
        double theoreticalMoz = (calculatedMass + charge * 1.007276466812) / charge;
        float ppm = (float)((expMoz - theoreticalMoz) * EXP_CSTE / theoreticalMoz);
        if (calculatedMass >= -1.0E-10 && calculatedMass <= 1.0E-10) {
            ppm = 0.0f;
        }
        return Float.valueOf(ppm);
    }

    public static double getIsotopMoz(double petideIonMoz, int petideIonCharge, int isotopRank) {
        return petideIonMoz + 1.007276466812 / (double)petideIonCharge * (double)isotopRank;
    }
}

