/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.Exceptions;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MzdbEncodingVerificationTask
extends AbstractDatabaseTask {
    private boolean m_result;
    private final File m_file;
    private Connection m_connection;
    private boolean m_corrupted = false;

    public MzdbEncodingVerificationTask(AbstractDatabaseCallback callback, File file) {
        super(callback, new TaskInfo("Verify encoding of " + file.getAbsolutePath(), false, "Mzdb Verification", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_file = file;
    }

    public boolean fetchData() {
        this.m_result = true;
        if (this.connect()) {
            if (this.needFix() && !this.m_corrupted) {
                this.fix();
            }
            this.closeConnection();
        }
        if (!this.m_result || this.m_corrupted) {
            this.m_taskError = new TaskError("Encoding verification & repair failed.", "File is corrupted.");
        }
        return this.m_taskError == null;
    }

    public boolean needToFetch() {
        return true;
    }

    private boolean connect() {
        String url = "jdbc:sqlite:" + this.m_file.getAbsolutePath();
        this.m_connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            this.m_connection = DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            this.m_result = false;
            return false;
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    private boolean needFix() {
        ResultSet rs;
        Statement stmt;
        String hcdSpectraCountQuery = "SELECT count(*) FROM spectrum where activation_type = 'HCD';";
        String dataEncodingCountQuery = "SELECT count(*) FROM data_encoding;";
        int hcdSpectraCount = -1;
        int dataEncodingCount = -1;
        try {
            stmt = this.m_connection.createStatement();
            rs = stmt.executeQuery(hcdSpectraCountQuery);
            if (rs.next()) {
                hcdSpectraCount = rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.m_corrupted = true;
            return false;
        }
        try {
            stmt = this.m_connection.createStatement();
            rs = stmt.executeQuery(dataEncodingCountQuery);
            if (rs.next()) {
                dataEncodingCount = rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.m_corrupted = true;
            return false;
        }
        if (hcdSpectraCount != -1 && dataEncodingCount != -1) {
            return hcdSpectraCount > 0 && dataEncodingCount == 3;
        }
        return false;
    }

    private void fix() {
        String insertEncodingSQL = "INSERT INTO data_encoding(mode, compression, byte_order, param_tree) VALUES(?,?,?,?)";
        try {
            PreparedStatement pstmt = this.m_connection.prepareStatement(insertEncodingSQL);
            pstmt.setString(1, "centroided");
            pstmt.setString(2, "none");
            pstmt.setString(3, "little_endian");
            pstmt.setString(4, "<params>\n  <cvParams>\n    <cvParam cvRef=\"MS\" accession=\"1000521\" name=\"64-bit float\" value=\"64\" />\n    <cvParam cvRef=\"MS\" accession=\"1000521\" name=\"32-bit float\" value=\"32\" />\n  </cvParams>\n</params>\n");
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.m_result = false;
            System.out.println(e.getMessage());
        }
        String sql = "UPDATE spectrum SET data_encoding_id = ? WHERE activation_type = ? AND data_encoding_id = ?;";
        try {
            PreparedStatement pstmt = this.m_connection.prepareStatement(sql);
            pstmt.setInt(1, 4);
            pstmt.setString(2, "HCD");
            pstmt.setInt(3, 3);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.m_result = false;
            System.out.println(e.getMessage());
        }
    }

    private void closeConnection() {
        try {
            this.m_connection.close();
        }
        catch (SQLException ex) {
            this.m_result = false;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

