/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.Exceptions;
import fr.proline.studio.msfiles.TransferableEntryWrapper;
import fr.proline.studio.msfiles.WorkingSet;
import fr.proline.studio.msfiles.WorkingSetEntriesTransferable;
import fr.proline.studio.msfiles.WorkingSetEntry;
import fr.proline.studio.msfiles.WorkingSetView;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class WorkingSetEntriesTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        ArrayList<TransferableEntryWrapper> transferable = new ArrayList<TransferableEntryWrapper>();
        if (c instanceof JTree) {
            TreePath[] paths;
            JTree tree = (JTree)c;
            for (TreePath path : paths = tree.getSelectionPaths()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (!(userObject instanceof WorkingSetEntry)) continue;
                transferable.add(new TransferableEntryWrapper((WorkingSetEntry)userObject, path.getParentPath()));
            }
            if (transferable.isEmpty()) {
                return null;
            }
            return new WorkingSetEntriesTransferable(transferable);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JTree.DropLocation location;
        TreePath path;
        DefaultMutableTreeNode node;
        support.setShowDropLocation(true);
        return support.isDataFlavorSupported(WorkingSetEntriesTransferable.WorkingSetEntries_FLAVOR) && support.getDropLocation() instanceof JTree.DropLocation && (node = (DefaultMutableTreeNode)(path = (location = (JTree.DropLocation)support.getDropLocation()).getPath()).getLastPathComponent()).getUserObject() instanceof WorkingSet;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            WorkingSetEntriesTransferable transferable = (WorkingSetEntriesTransferable)support.getTransferable().getTransferData(WorkingSetEntriesTransferable.WorkingSetEntries_FLAVOR);
            if (support.getComponent() instanceof JTree) {
                ArrayList<TransferableEntryWrapper> entriesWrappers = transferable.getEntries();
                JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
                TreePath dropPath = dropLocation.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)dropPath.getLastPathComponent();
                if (node.getUserObject() instanceof WorkingSet) {
                    WorkingSet set = (WorkingSet)node.getUserObject();
                    for (int i = 0; i < entriesWrappers.size(); ++i) {
                        if (!set.addEntry(WorkingSetView.getWorkingSetView().getModel().getEntiesObjects().get(entriesWrappers.get(i).getEntry().getPath()))) continue;
                        DefaultMutableTreeNode sourceNode = (DefaultMutableTreeNode)entriesWrappers.get(i).getSource().getLastPathComponent();
                        if (sourceNode.getUserObject() instanceof WorkingSet) {
                            WorkingSet sourceSet = (WorkingSet)sourceNode.getUserObject();
                            sourceSet.removeEntry(entriesWrappers.get(i).getEntry().getPath());
                        }
                        WorkingSetView.getWorkingSetView().expand(dropPath);
                        WorkingSetView.getWorkingSetView().reloadAndSave();
                    }
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }
}

