/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dpm.serverfilesystem.ServerFile;
import fr.proline.studio.msfiles.WorkingSet;
import java.io.File;
import java.io.Serializable;

public class WorkingSetEntry
implements Serializable {
    private String m_filename;
    private String m_path;
    private Location m_location;
    private boolean m_existing;
    private File m_file;
    private WorkingSet m_parent;
    private Labeling m_labeling;

    public WorkingSetEntry(String filename, String path, Location location, WorkingSet parent, Labeling labeling) {
        this.m_filename = filename;
        this.m_path = path;
        this.m_location = location;
        this.m_parent = parent;
        this.m_labeling = labeling;
        this.m_file = location == Location.LOCAL ? new File(this.m_path) : new ServerFile(path, path, true, 0L, 0L);
        this.m_existing = location == Location.REMOTE || this.m_file.exists();
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public Location getLocation() {
        return this.m_location;
    }

    public void setLocation(Location location) {
        this.m_location = location;
    }

    public boolean exists() {
        return this.m_existing;
    }

    public WorkingSet getParent() {
        return this.m_parent;
    }

    public void resetExist() {
        this.m_file = new File(this.m_path);
        this.m_existing = this.m_location == Location.REMOTE || this.m_file.exists();
    }

    public File getFile() {
        return this.m_file;
    }

    public String toString() {
        if (this.m_labeling == Labeling.DISPLAY_FILENAME) {
            return this.m_filename;
        }
        return this.m_path;
    }

    public static enum Labeling {
        DISPLAY_FILENAME,
        DISPLAY_PATH;

    }

    public static enum Location {
        LOCAL,
        REMOTE;

    }
}

