/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadLcMSTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.SecondAxisTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.AbstractDataBoxPTMPeptides;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PTMPeptidesTablePanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XICComparePeptideTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.XicAbundanceProteinTableModel;
import fr.proline.studio.types.XicMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class DataBoxPTMPeptides
extends AbstractDataBoxPTMPeptides {
    private QuantChannelInfo m_quantChannelInfo;
    private List<DMasterQuantPeptide> m_masterQuantPeptideList;
    private DMasterQuantProteinSet m_masterQuantProteinSet;
    private Long m_previousXICTaskId = null;

    private static AbstractDataBox.DataboxType getDataboxType(boolean xicResult, boolean showAllPepMatches) {
        if (xicResult) {
            if (showAllPepMatches) {
                return AbstractDataBox.DataboxType.DataBoxXicPTMPeptidesMatches;
            }
            return AbstractDataBox.DataboxType.DataBoxXicPTMPeptides;
        }
        if (showAllPepMatches) {
            return AbstractDataBox.DataboxType.DataBoxPTMPeptidesMatches;
        }
        return AbstractDataBox.DataboxType.DataBoxPTMPeptides;
    }

    public DataBoxPTMPeptides() {
        this(false, false);
    }

    public DataBoxPTMPeptides(boolean xicResult, boolean showAllPepMatches) {
        super(DataBoxPTMPeptides.getDataboxType(xicResult, showAllPepMatches), xicResult ? AbstractDataBox.DataboxStyle.STYLE_XIC : AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_displayAllPepMatches = showAllPepMatches;
        this.m_isMS1LabelFreeQuantitation = xicResult;
        StringBuilder stb = this.m_isMS1LabelFreeQuantitation ? new StringBuilder("Quanti. ") : new StringBuilder();
        this.m_typeName = this.m_displayAllPepMatches ? stb.append("Site PSMs").toString() : stb.append("Site Peptides").toString();
        stb = this.m_isMS1LabelFreeQuantitation ? new StringBuilder("Quantified ") : new StringBuilder();
        this.m_description = this.m_displayAllPepMatches ? stb.append("PSMs matching a modification site or cluster").toString() : stb.append("Peptides matching of modification site or cluster").toString();
        super.registerParameters();
    }

    @Override
    public void createPanel() {
        PTMPeptidesTablePanel p = new PTMPeptidesTablePanel(this.m_displayAllPepMatches, this.m_isMS1LabelFreeQuantitation);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    protected void setSelectedPTMPeptide(PTMPeptideInstance pepInstance) {
        ((PTMPeptidesTablePanel)this.getDataBoxPanelInterface()).setSelectedPeptide(pepInstance);
    }

    @Override
    protected DPeptideMatch getSelectedPeptideMatch() {
        return ((PTMPeptidesTablePanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
    }

    @Override
    protected PTMPeptideInstance getSelectedPTMPeptide() {
        return ((PTMPeptidesTablePanel)this.getDataBoxPanelInterface()).getSelectedPTMPeptideInstance();
    }

    @Override
    public void updateData() {
        PTMPeptidesTablePanel panel = (PTMPeptidesTablePanel)this.getDataBoxPanelInterface();
        if (panel.isShowed()) {
            if (this.m_ptmPepInstances == null || this.m_ptmPepInstances.isEmpty()) {
                panel.setData(null, null, null, null, false);
                return;
            }
            if (this.m_isMS1LabelFreeQuantitation) {
                this.m_quantChannelInfo = (QuantChannelInfo)this.getData(QuantChannelInfo.class);
                if (this.m_quantChannelInfo != null) {
                    panel.addSingleValue(this.m_quantChannelInfo);
                }
                this.m_masterQuantProteinSet = (DMasterQuantProteinSet)this.getData(DMasterQuantProteinSet.class);
            }
            this.resetPrevPTMTaskId();
            if (this.m_isMS1LabelFreeQuantitation) {
                this.loadXicAndPropagate();
            } else {
                ((PTMPeptidesTablePanel)this.getDataBoxPanelInterface()).setData(null, this.m_ptmPepInstances, this.m_ptmClusters, null, true);
                this.addDataChanged(PTMPeptideInstance.class, null);
                this.addDataChanged(DPeptideMatch.class);
                this.addDataChanged(ExtendedTableModelInterface.class);
                this.propagateDataChanged();
            }
        }
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        if (this.isMS1LabelFreeQuantitation()) {
            return new Class[]{DMasterQuantPeptide.class, PTMPeptideInstance.class};
        }
        return new Class[]{PTMPeptideInstance.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        try {
            Peptide peptide = null;
            if (this.isMS1LabelFreeQuantitation()) {
                DMasterQuantPeptide qPep = ((PTMPeptidesTablePanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptide();
                if (qPep != null) {
                    peptide = qPep.getPeptideInstance().getPeptide();
                }
            } else {
                DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
                if (p != null) {
                    peptide = p.getPeptide();
                }
            }
            if (peptide != null) {
                return peptide.getSequence();
            }
            return null;
        }
        catch (Exception e) {
            m_logger.error("Error getting (quant) peptide information ", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void loadXicAndPropagate() {
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void run(boolean success, final long taskId, SubTask subTask, boolean finished) {
                block6: {
                    if (subTask == null) {
                        if (DataBoxPTMPeptides.this.m_quantChannelInfo != null) {
                            HashMap<Long, DMasterQuantPeptide> qpepByPepId = new HashMap<Long, DMasterQuantPeptide>();
                            for (DMasterQuantPeptide masterQPep : DataBoxPTMPeptides.this.m_masterQuantPeptideList) {
                                qpepByPepId.put(masterQPep.getPeptideInstanceId(), masterQPep);
                            }
                            ((PTMPeptidesTablePanel)DataBoxPTMPeptides.this.getDataBoxPanelInterface()).setData(taskId, DataBoxPTMPeptides.this.m_ptmPepInstances, DataBoxPTMPeptides.this.m_ptmClusters, qpepByPepId, finished);
                            break block6;
                        } else {
                            AbstractDatabaseCallback mapCallback = new AbstractDatabaseCallback(){

                                public boolean mustBeCalledInAWT() {
                                    return true;
                                }

                                public void run(boolean success, long task2Id, SubTask subTask, boolean finished) {
                                    DataBoxPTMPeptides.this.m_quantChannelInfo = new QuantChannelInfo(DataBoxPTMPeptides.this.m_ptmDataset.getDataset());
                                    DataBoxPTMPeptides.this.getDataBoxPanelInterface().addSingleValue(DataBoxPTMPeptides.this.m_quantChannelInfo);
                                    HashMap<Long, DMasterQuantPeptide> qpepByPepId = new HashMap<Long, DMasterQuantPeptide>();
                                    for (DMasterQuantPeptide masterQPep : DataBoxPTMPeptides.this.m_masterQuantPeptideList) {
                                        masterQPep.getPeptideInstanceId();
                                        qpepByPepId.put(masterQPep.getPeptideInstanceId(), masterQPep);
                                    }
                                    ((PTMPeptidesTablePanel)DataBoxPTMPeptides.this.getDataBoxPanelInterface()).setData(taskId, DataBoxPTMPeptides.this.m_ptmPepInstances, DataBoxPTMPeptides.this.m_ptmClusters, qpepByPepId, finished);
                                    DataBoxPTMPeptides.this.unregisterTask(task2Id);
                                    DataBoxPTMPeptides.this.addDataChanged(PTMPeptideInstance.class, null);
                                    DataBoxPTMPeptides.this.addDataChanged(ExtendedTableModelInterface.class);
                                    DataBoxPTMPeptides.this.propagateDataChanged();
                                }
                            };
                            DatabaseLoadLcMSTask maptask = new DatabaseLoadLcMSTask(mapCallback);
                            maptask.initLoadAlignmentForXic(DataBoxPTMPeptides.this.getProjectId(), DataBoxPTMPeptides.this.m_ptmDataset.getDataset());
                            DataBoxPTMPeptides.this.registerTask((AbstractDatabaseTask)maptask);
                            if (finished) {
                                DataBoxPTMPeptides.this.m_previousXICTaskId = null;
                                DataBoxPTMPeptides.this.setLoaded(loadingId);
                                DataBoxPTMPeptides.this.unregisterTask(taskId);
                            }
                            return;
                        }
                    }
                    ((PTMPeptidesTablePanel)DataBoxPTMPeptides.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                if (finished) {
                    DataBoxPTMPeptides.this.m_previousXICTaskId = null;
                    DataBoxPTMPeptides.this.setLoaded(loadingId);
                    DataBoxPTMPeptides.this.unregisterTask(taskId);
                    DataBoxPTMPeptides.this.addDataChanged(PTMPeptideInstance.class, null);
                    DataBoxPTMPeptides.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxPTMPeptides.this.propagateDataChanged();
                }
            }
        };
        this.m_masterQuantPeptideList = new ArrayList<DMasterQuantPeptide>();
        if (this.m_previousXICTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousXICTaskId);
            this.m_previousXICTaskId = null;
        }
        if (this.m_ptmPepInstances != null && !this.m_ptmPepInstances.isEmpty()) {
            DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
            List<Long> parentPepInstanceIdsL = this.m_ptmPepInstances.stream().map(ptmPepInst -> ptmPepInst.getPeptideInstance().getId()).collect(Collectors.toList());
            task.initLoadPeptides(this.getProjectId(), this.m_ptmDataset.getDataset(), parentPepInstanceIdsL.toArray(new Long[parentPepInstanceIdsL.size()]), this.m_masterQuantPeptideList, true);
            this.m_previousXICTaskId = task.getId();
            this.registerTask((AbstractDatabaseTask)task);
        }
    }

    @Override
    protected ArrayList<Integer> getSelectedIndex() {
        ArrayList selection = ((PTMPeptidesTablePanel)this.m_panel).getCrossSelectionInterface().getSelection();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Long l : selection) {
            result.add(l.intValue());
        }
        return result;
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        DataBoxPanelInterface panel = this.getDataBoxPanelInterface();
        if (parameterType != null && (!(panel instanceof SplittedPanelContainer.ReactiveTabbedComponent) || panel instanceof SplittedPanelContainer.ReactiveTabbedComponent && ((SplittedPanelContainer.ReactiveTabbedComponent)panel).isShowed()) && this.m_isMS1LabelFreeQuantitation) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                if (parameterType.equals(SecondAxisTableModelInterface.class)) {
                    if (this.m_quantChannelInfo == null || this.m_masterQuantProteinSet == null) {
                        return null;
                    }
                    XicAbundanceProteinTableModel protTableModel = new XicAbundanceProteinTableModel();
                    protTableModel.setData(this.m_quantChannelInfo.getQuantChannels(), this.m_masterQuantProteinSet);
                    protTableModel.setName("Protein");
                    return protTableModel;
                }
                if (parameterType.equals(DMasterQuantPeptide.class)) {
                    return ((PTMPeptidesTablePanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptide();
                }
                if (parameterType.equals(XicMode.class)) {
                    return new XicMode(this.m_isMS1LabelFreeQuantitation);
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA && parameterType.equals(ExtendedTableModelInterface.class)) {
                return this.getTableModelInterfaceList();
            }
            if (parameterSubtype == ParameterSubtypeEnum.PEPTIDES_SELECTION_LIST && parameterType.equals(Integer.class)) {
                CrossSelectionInterface crossSelectionInterface = ((PTMPeptidesTablePanel)this.m_panel).getCrossSelectionInterface();
                ArrayList<Integer> result = new ArrayList<Integer>();
                if (crossSelectionInterface != null) {
                    ArrayList selection = null;
                    try {
                        selection = crossSelectionInterface.getSelection();
                    }
                    catch (Exception e) {
                        m_logger.error("wart : selection not ready ", (Throwable)e);
                    }
                    if (selection != null) {
                        for (Long l : selection) {
                            result.add(l.intValue());
                        }
                    }
                }
                return result;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    private List<XICComparePeptideTableModel> getTableModelInterfaceList() {
        ArrayList<XICComparePeptideTableModel> list = new ArrayList<XICComparePeptideTableModel>();
        if (this.m_quantChannelInfo == null && this.m_previousDataBox != null) {
            this.m_quantChannelInfo = (QuantChannelInfo)this.getData(QuantChannelInfo.class);
        }
        if (this.m_quantChannelInfo != null && this.m_masterQuantPeptideList != null) {
            for (DMasterQuantPeptide quantPeptide : this.m_masterQuantPeptideList) {
                XICComparePeptideTableModel peptideData = new XICComparePeptideTableModel();
                peptideData.setData(this.m_quantChannelInfo.getQuantChannels(), quantPeptide, true);
                list.add(peptideData);
            }
        }
        return list;
    }
}

