/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ObjectTree;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadSpectrumsTask;
import fr.proline.studio.dam.tasks.DatabaseObjectTreeTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.rsmexplorer.gui.spectrum.RsetPeptideSpectrumPanel;

public class DataBoxRsetPeptideSpectrum
extends AbstractDataBox {
    private DPeptideMatch m_previousPeptideMatch = null;
    private PeptideFragmentationData m_fragmentationData = null;
    private Long m_previousTaskId = null;
    private Long m_previousFragmentationTaskId = null;

    public DataBoxRsetPeptideSpectrum() {
        super(AbstractDataBox.DataboxType.DataBoxRsetPeptideSpectrum, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "Spectrum";
        this.m_description = "Spectrum of a Peptide";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DPeptideMatch.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DMsQuery.class);
        outParameter.addParameter(DSpectrum.class);
        outParameter.addParameter(PeptideFragmentationData.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsetPeptideSpectrumPanel p = new RsetPeptideSpectrumPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        boolean needToLoadData;
        final DPeptideMatch peptideMatch = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (this.m_previousPeptideMatch == peptideMatch) {
            return;
        }
        this.m_previousPeptideMatch = peptideMatch;
        this.m_fragmentationData = null;
        if (peptideMatch == null) {
            ((RsetPeptideSpectrumPanel)this.getDataBoxPanelInterface()).setData(null, null);
            return;
        }
        boolean bl = needToLoadData = !peptideMatch.isMsQuerySet() || !peptideMatch.getMsQuery().isSpectrumFullySet();
        if (needToLoadData) {
            final int loadingId = this.setLoading();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    DataBoxRsetPeptideSpectrum.this.loadAnnotations(peptideMatch);
                    DataBoxRsetPeptideSpectrum.this.setLoaded(loadingId);
                    if (finished) {
                        DataBoxRsetPeptideSpectrum.this.unregisterTask(taskId);
                    }
                }
            };
            DatabaseLoadSpectrumsTask task = new DatabaseLoadSpectrumsTask(callback, this.getProjectId(), peptideMatch);
            Long taskId = task.getId();
            if (this.m_previousTaskId != null) {
                AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
            }
            this.m_previousTaskId = taskId;
            this.registerTask((AbstractDatabaseTask)task);
        } else {
            this.loadAnnotations(peptideMatch);
        }
    }

    public void loadAnnotations(final DPeptideMatch peptideMatch) {
        final ObjectTree[] objectTreeResult = new ObjectTree[1];
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                ObjectTree objectTree = objectTreeResult[0];
                PeptideFragmentationData previousValue = DataBoxRsetPeptideSpectrum.this.m_fragmentationData;
                DataBoxRsetPeptideSpectrum.this.m_fragmentationData = objectTree != null ? new PeptideFragmentationData(peptideMatch, objectTree) : null;
                ((RsetPeptideSpectrumPanel)DataBoxRsetPeptideSpectrum.this.getDataBoxPanelInterface()).setData(peptideMatch, DataBoxRsetPeptideSpectrum.this.m_fragmentationData);
                if (DataBoxRsetPeptideSpectrum.this.m_fragmentationData != null || DataBoxRsetPeptideSpectrum.this.m_fragmentationData == null && previousValue != null) {
                    DataBoxRsetPeptideSpectrum.this.addDataChanged(DPeptideMatch.class);
                    DataBoxRsetPeptideSpectrum.this.propagateDataChanged();
                }
                if (finished) {
                    DataBoxRsetPeptideSpectrum.this.unregisterTask(taskId);
                }
            }
        };
        DatabaseObjectTreeTask task = new DatabaseObjectTreeTask(callback, this.getProjectId(), peptideMatch, objectTreeResult);
        Long taskId = task.getId();
        if (this.m_previousFragmentationTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousFragmentationTaskId);
        }
        this.m_previousFragmentationTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            DSpectrum spectrum;
            DMsQuery msQuery;
            DPeptideMatch peptideMatch;
            if (parameterType.equals(DMsQuery.class) && (peptideMatch = (DPeptideMatch)this.getData(DPeptideMatch.class)) != null && (msQuery = peptideMatch.getMsQuery()) != null) {
                return msQuery;
            }
            if (parameterType.equals(DSpectrum.class) && (peptideMatch = (DPeptideMatch)this.getData(DPeptideMatch.class)) != null && (msQuery = peptideMatch.getMsQuery()) != null && (spectrum = msQuery.getDSpectrum()) != null) {
                return spectrum;
            }
            if (parameterType.equals(PeptideFragmentationData.class)) {
                return this.m_fragmentationData;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }
}

