/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProteinsFromProteinSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsmProteinsOfProteinSetPanel;

public class DataBoxRsmProteinsOfProteinSet
extends AbstractDataBox {
    private long m_proteinSetCurId = -1L;
    private Long m_previousTaskId = null;

    public DataBoxRsmProteinsOfProteinSet() {
        super(AbstractDataBox.DataboxType.DataBoxRsmProteinsOfProteinSet, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Proteins";
        this.m_description = "All Proteins of a Protein Set";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DProteinSet.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DProteinMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsmProteinsOfProteinSetPanel p = new RsmProteinsOfProteinSetPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final DProteinSet proteinSet = (DProteinSet)this.getData(DProteinSet.class);
        if (proteinSet == null) {
            ((RsmProteinsOfProteinSetPanel)this.getDataBoxPanelInterface()).setData(null, null);
            this.m_proteinSetCurId = -1L;
            return;
        }
        if (this.m_proteinSetCurId != -1L && proteinSet.getId() == this.m_proteinSetCurId) {
            return;
        }
        this.m_proteinSetCurId = proteinSet.getId();
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                ((RsmProteinsOfProteinSetPanel)DataBoxRsmProteinsOfProteinSet.this.getDataBoxPanelInterface()).setData(proteinSet, null);
                DataBoxRsmProteinsOfProteinSet.this.setLoaded(loadingId);
                DataBoxRsmProteinsOfProteinSet.this.unregisterTask(taskId);
                DataBoxRsmProteinsOfProteinSet.this.addDataChanged(ExtendedTableModelInterface.class);
                DataBoxRsmProteinsOfProteinSet.this.propagateDataChanged();
            }
        };
        DatabaseProteinsFromProteinSetTask task = new DatabaseProteinsFromProteinSetTask(callback, this.getProjectId(), proteinSet);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DProteinMatch.class)) {
                return ((RsmProteinsOfProteinSetPanel)this.getDataBoxPanelInterface()).getSelectedProteinMatch();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DProteinMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        DProteinMatch pm = (DProteinMatch)this.getData(DProteinMatch.class);
        if (pm != null) {
            return pm.getAccession();
        }
        return null;
    }
}

