/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.tasklog.TasksPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class DataBoxTaskList
extends AbstractDataBox {
    private static final int UPDATE_DELAY = 1000;
    private Timer m_updateTimer = null;

    public DataBoxTaskList() {
        super(AbstractDataBox.DataboxType.DataBoxTaskList, AbstractDataBox.DataboxStyle.STYLE_UNKNOWN);
        this.m_typeName = "User Tasks Logs";
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(TaskInfo.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        TasksPanel p = new TasksPanel();
        p.initListener();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA && parameterType.equals(TaskInfo.class)) {
            return ((TasksPanel)this.getDataBoxPanelInterface()).getSelectedTaskInfo();
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
    }

    @Override
    public void windowClosed() {
        this.m_updateTimer.stop();
        super.windowClosed();
    }

    @Override
    public void windowOpened() {
        if (this.m_updateTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ((TasksPanel)DataBoxTaskList.this.getDataBoxPanelInterface()).updateData();
                }
            };
            this.m_updateTimer = new Timer(1000, taskPerformer);
        }
        this.m_updateTimer.start();
    }
}

