/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptideMatchTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PeptideMatchPanel;

public class DataboxRsmPSMOfProteinSet
extends AbstractDataBox {
    private boolean m_mergedData;

    public DataboxRsmPSMOfProteinSet() {
        this(false);
    }

    public DataboxRsmPSMOfProteinSet(boolean mergedData) {
        super(AbstractDataBox.DataboxType.DataboxRsmPSMOfProteinSet, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_mergedData = mergedData;
        this.m_typeName = "PSMs";
        this.m_description = "All PSMs of a Protein Set";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSummary.class);
        inParameter.addParameter(DProteinSet.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        PeptideMatchPanel p = new PeptideMatchPanel(true, this.m_mergedData, false, false, false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        ResultSummary _rsm = (ResultSummary)this.getData(ResultSummary.class);
        final DProteinSet proteinSet = (DProteinSet)this.getData(DProteinSet.class);
        if (proteinSet == null) {
            ((PeptideMatchPanel)this.getDataBoxPanelInterface()).setData(-1L, null, null, true);
            return;
        }
        this.linkCache((TransientDataInterface)_rsm);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DPeptideMatch[] peptideMatchArray = proteinSet.getTypicalProteinMatch().getPeptideMatches();
                    long[] peptideMatchIdArray = proteinSet.getTypicalProteinMatch().getPeptideMatchesId();
                    ((PeptideMatchPanel)DataboxRsmPSMOfProteinSet.this.getDataBoxPanelInterface()).setData(taskId, peptideMatchArray, peptideMatchIdArray, finished);
                } else {
                    ((PeptideMatchPanel)DataboxRsmPSMOfProteinSet.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                if (finished) {
                    DataboxRsmPSMOfProteinSet.this.unregisterTask(taskId);
                    DataboxRsmPSMOfProteinSet.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxRsmPSMOfProteinSet.this.propagateDataChanged();
                }
            }
        };
        this.registerTask((AbstractDatabaseTask)new DatabaseLoadPeptideMatchTask(callback, this.getProjectId(), _rsm, proteinSet));
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((PeptideMatchPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        return new Class[]{DPeptideMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

